/*******************************************************************************
* FILE NAME: iflypain.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in iflypain.hpp.                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1995       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
// Priority INT_MIN (-2147483647 - 1) + 1024 + 512
#pragma priority( -2147482112 )

extern "C"
{
  #define INCL_GPIPRIMITIVES
  #include <iwindefs.h>
}

#include <iflypain.hpp>
#include <iflytext.hpp>
#include <igstring.hpp>
#include <igrect.hpp>
#include <igpyline.hpp>
#include <igbundle.hpp>

// Segment definitions
#ifdef IC_PAGETUNE
  #define _IFLYPAIN_CPP_
  #include <ipagetun.h>
#endif

/*------------------------------------------------------------------------------
| IFlyTextPaintHandler::IFlyTextPaintHandler                                   |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IFlyTextPaintHandler::IFlyTextPaintHandler()
{}

/*------------------------------------------------------------------------------
| IFlyTextPaintHandler::~IFlyTextPaintHandler                                  |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IFlyTextPaintHandler::~IFlyTextPaintHandler()
{}

/*------------------------------------------------------------------------------
| IFlyTextPaintHandler::paintWindow                                            |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
Boolean IFlyTextPaintHandler::paintWindow( IPaintEvent& event )
{
  IGraphicContext gc( event.presSpaceHandle() );
  IFlyText*       flyText(((IFlyText*)event.window()));
  IGString        text(flyText->text());
  IRectangle      box(event.rect());

  box.sizeTo(box.size() - ISize(1,1));
  IRectangle      rc(box);
  box.shrinkBy(IPair(5,5));
  IGRectangle     outline( box );

  GpiSetTextAlignment( gc.handle(),  TA_STANDARD_HORIZ, TA_BOTTOM);

  rc.shrinkBy(IPair( 7,7 ));

  // Draw the filled box upon which the text will be drawn.
  IGRectangle fill(rc);
  gc.setFillColor(flyText->backgroundColor())
    .setDrawOperation( IGraphicBundle::fillAndFrame );
  fill.drawOn( gc );

  gc.setDrawOperation( IGraphicBundle::frame );

  // Add 3 to both x and y values so that text appears centered
  text.moveTo(IPoint(rc.left() + 3,rc.bottom() + 3));

  gc.setPenColor(flyText->foregroundColor());
  text.drawOn( gc );

  // Draw the three outline boxes.  The outer one is white, the
  // middle one is black and the inner one is white.

  gc.setPenColor( flyText->shadowColor() );
  outline.drawOn( gc );
  box.shrinkBy(IPair(1,1));
  outline.setEnclosingRect(box);
  gc.setPenColor( flyText->borderColor() );
  outline.drawOn( gc );
  box.shrinkBy(IPair(1,1));
  outline.setEnclosingRect(box);
  gc.setPenColor( flyText->shadowColor() );
  outline.drawOn( gc );

  // Set the bundle for the arrow to use the current background color
  // as the pen and fill color.

  IGraphicBundle arrowBundle(flyText->fHelpArrow.graphicBundle());
  arrowBundle.setPenColor(flyText->shadowColor())
             .setFillColor(flyText->backgroundColor());
  flyText->fHelpArrow.setGraphicBundle(arrowBundle);
  arrowBundle = flyText->fArrow->graphicBundle();
  arrowBundle.setPenColor(flyText->backgroundColor());
  flyText->fArrow->setGraphicBundle(arrowBundle);
  arrowBundle = flyText->fBorderArrow->graphicBundle();
  arrowBundle.setPenColor(flyText->borderColor());
  flyText->fBorderArrow->setGraphicBundle(arrowBundle);


  // determine which direction to draw the arrow

  switch (flyText->fArrowPos)
  {
    case IFlyText::upperLeft:
      flyText->fHelpArrow.translateBy( IPoint( 0, event.rect().height() - 13 ));
    break;
    case IFlyText::upperRight:
      flyText->fHelpArrow.rotateBy( -90.0, IPoint( 6,6 ))
                        .translateBy( IPoint( event.rect().width() -13,
                                              event.rect().height() - 13 ));
    break;
    case IFlyText::lowerLeft:
      flyText->fHelpArrow.rotateBy( 90.0, IPoint( 6,6 ));
    break;
    case IFlyText::lowerRight:
      flyText->fHelpArrow.rotateBy( 180.0, IPoint( 6,6 ))
                        .translateBy( IPoint( event.rect().width() - 13, 0 ));
    break;
  }
  // draw the arrow and reset the matrix so transform
  // will no accumulate.
  flyText->fHelpArrow.drawOn( gc ).resetTransformMatrix();

/* The following linees were commented out as they generated extra WM_PAINT */
/*     messages even for hidden windows, and ultimatly trapps - defect 9783 */
  // Show the flytext control. 
  //  flyText->positionOnSiblings();
  //  flyText->show();

  return true;
}

/*------------------------------------------------------------------------------
| IFlyTextPaintHandler::dispatchHandlerEvent                                   |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
Boolean IFlyTextPaintHandler::dispatchHandlerEvent( IEvent& event )
{
  if (event.eventId() == IC_UM_FLY_PAINT)
  {
    event.window()->positionOnSiblings();
    event.window()->show();
  }
  return Inherited::dispatchHandlerEvent( event );
}
