#ifndef _ICNRCTL_
#define _ICNRCTL_
/*******************************************************************************
* FILE NAME: icnrctl.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IContainerControl                                                        *
*     IContainerControl::ObjectCursor                                          *
*     IContainerControl::TextCursor                                            *
*     IContainerControl::ColumnCursor                                          *
*     IContainerControl::FilterFn                                              *
*     IContainerControl::CompareFn                                             *
*     IContainerControl::Iterator                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1995       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#include <icontrol.hpp>
#include <icnrobj.hpp>
#include <irect.hpp>

class IContainerControl;
class IContainerColumn;
class IResourceId;
class IPrivateResource;
class IMultiLineEdit;
class IColor;
class ICnrControlList;
class ICnrObjectSet;
class ICnrControlData;
class ICnrObjCursorData;
class ICnrTextCursorData;
class ICnrColCursorData;
struct ICnrInfo;
class ICnrRecord;

#pragma pack(4)


class IContainerControl : public IControl {
typedef IControl
  Inherited;

public:

class Style;
class Attribute;

/*-------------------------- Related Types -----------------------------------*/
enum EnumerationOrder {
  itemOrder,
  zOrder
  };

enum TitleAlignment {
  left,
  right,
  centered
  };

/*------------------------ Constructors --------------------------------------*/
  IContainerControl ( unsigned long     id,
                      IWindow*          parent,
                      IWindow*          owner,
                      const IRectangle& location  = IRectangle(),
                      const Style&      style     = defaultStyle(),
                      const Attribute&  attribute = defaultAttribute());
#ifndef IC_MOTIF
  IContainerControl ( unsigned long id,
                      IWindow*      parentDialog);

  IContainerControl ( const IWindowHandle& handle);
#endif


virtual
 ~IContainerControl ( );

/*-------------------------------- Styles ------------------------------------*/
INESTEDBITFLAGCLASSDEF2( Style, IContainerControl, IWindow, IControl);

static const Style
  classDefaultStyle,
  readOnly,
  autoPosition,
  extendedSelection,
  singleSelection,
  multipleSelection,
  verifyPointers,
  noSharedObjects,
  pmCompatible;

static Style
  defaultStyle      ( );
static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      Boolean         extendedOnly = false ) const;
Boolean
  isPMCompatible    ( ) const;

/*-------------------------------- Attributes -------------------------------*/
INESTEDBITFLAGCLASSDEF0( Attribute, IContainerControl);

static const Attribute
  textView,
  iconView,
  nameView,
  detailsView,
  treeView,
  flowedView,
  miniIcons,
  readOnlyTitle,
  titleSeparator,
  detailsViewTitles,
  visibleTitle,
  alignTitleCentered,
  alignTitleLeft,
  alignTitleRight,
  handleDrawItem,
  handleDrawBackground,
  orderedTargetEmphasis,
  mixedTargetEmphasis,
  visibleTreeLine,
  classDefaultAttribute;

static Attribute
  defaultAttribute    ( );
static void
  setDefaultAttribute ( const  Attribute& attribute);


/*------------------------ Comparison ----------------------------------------*/
Boolean
  operator==( const IContainerControl& container);

/*------------------------ Initialization ------------------------------------*/
static void
     initialize ( );


class FilterFn : public IVBase {
typedef IVBase
  Inherited;
public:
/*------------------------ Constructors -----------------------------------*/
  FilterFn ( );

virtual
 ~FilterFn ( );

/*------------------------ Object Filtering -------------------------------*/
virtual Boolean
  isMemberOf  ( IContainerObject* object,
                IContainerControl* container) const = 0;

};  /* end FilterFn */


class CompareFn : public IVBase {
typedef IVBase
  Inherited;
public:
/*------------------------ Constructors -----------------------------------*/
  CompareFn  ( );

virtual
 ~CompareFn  ( );

/*------------------------ Object Sorting ---------------------------------*/
virtual int
  isEqual     ( IContainerObject* object1,
                IContainerObject* object2,
                IContainerControl* container) const = 0;

};  /* end CompareFn */


class ObjectCursor : public IVBase {
typedef IVBase
  Inherited;
public:
/*------------------------ Constructors -----------------------------------*/
  ObjectCursor ( const IContainerControl&   container,
                 IContainerObject::Emphasis emphasis    = IContainerObject::none,
                 EnumerationOrder           enumeration = itemOrder);

  ObjectCursor ( const IContainerControl& container,
                 const IContainerObject*  parentObject,
                 Boolean                  allDescendents = false);

virtual
 ~ObjectCursor ( );

/*------------------------ Cursor Movement --------------------------------*/
virtual  Boolean
  setToFirst    ( ),
  setToNext     ( ),
  setToLast     ( ),
  setToPrevious ( );

/*------------------------ Object Retrieval -------------------------------*/
virtual IContainerObject
 *first       ( ),
 *next        ( ),
 *previous    ( ),
 *last        ( ),
 *current     ( ) const;

virtual ObjectCursor
 &setCurrent  ( const IContainerObject* currentObject);

/*------------------------ Cursor Validation ------------------------------*/
virtual  Boolean
  isValid       ( ) const;
virtual ObjectCursor
 &invalidate    ( );

private:


IContainerObject
 *object          ( const IContainerObject* objectAfter,
                    unsigned long           command),
 *selectedObject  ( const IContainerObject* objectAfter,
                    unsigned long           emphasis),
 *lastObject      ( const IContainerObject* objectAfter = 0),
 *previousObject  ( const IContainerObject* objectBefore),
 *nextObject      ( const IContainerObject* objectAfter),
 *nextBranchObject( const IContainerObject* objectAfter);

enum State {
  all=1,
  child=2,
  emphasis=4,
  allSubTree=8
  };


IContainerObject
 *pcnrobjClCurrent,
 *pcnrobjClParent;
unsigned long
  ulClChanges;
IContainerControl
 *pcnrctlClOwner;
unsigned long
  flClEmphasis;
unsigned long
  flClEnumeration;
unsigned long
  flClState;
ICnrObjCursorData
  *objectCursorData;
};  /* end ObjectCursor */


class TextCursor : public IVBase {
typedef IVBase
  Inherited;
public:
/*------------------------ Constructors -----------------------------------*/
  TextCursor ( const IContainerControl& container,
               const char*              text,
               Boolean                  isCaseSensitive = true,
               Boolean                  isFirstInRecord = false,
               Boolean                  isExactMatch = false );

virtual
 ~TextCursor ( );

/*------------------------ Cursor Movement --------------------------------*/
virtual  Boolean
  setToFirst    ( ),
  setToNext     ( ),
  setToLast     ( ),
  setToPrevious ( );

/*------------------------ Object Retrieval -------------------------------*/
virtual IContainerObject
  *first       ( ),
  *next        ( ),
  *previous    ( ),
  *last        ( ),
  *current     ( ) const;

virtual TextCursor
 &setCurrent   ( const IContainerObject* currentObject);

/*------------------------ Cursor Validation ------------------------------*/
virtual  Boolean
  isValid      ( ) const;
virtual TextCursor
 &invalidate   ( );

private:
IContainerObject
 *find( unsigned long     view,
        IContainerObject* objectAfter,
        const char*       text,
        Boolean           caseSensitive,
        Boolean           firstInRecord);
IContainerObject
 *pcnrobjClCurrent,
 *pcnrobjClParent;
unsigned long
  ulClView;
unsigned long
  ulClChanges;
IContainerControl
 *pcnrctlClOwner;
IString
  strClSearchString;
Boolean
  fClIsCaseSensitive,
  fClIsFirstInRecord,
  fClIsExactMatch;
ICnrTextCursorData
  *textCursorData;
};  /* end TextCursor */


class ColumnCursor : public IVBase {
typedef IVBase
  Inherited;
public:
/*------------------------ Constructors -----------------------------------*/
  ColumnCursor  ( const IContainerControl& container,
                  Boolean                  visibleOnly = false );

virtual
 ~ColumnCursor  ( );

/*------------------------ Cursor Movement --------------------------------*/
virtual  Boolean
  setToFirst     ( ),
  setToNext      ( ),
  setToLast      ( ),
  setToPrevious  ( );

/*------------------------ Column Retrieval -------------------------------*/
virtual IContainerColumn
 *first        ( ),
 *next         ( ),
 *previous     ( ),
 *last         ( ),
 *current      ( ) const;

virtual ColumnCursor
 &setCurrent   ( const IContainerColumn* currentColumn);

/*------------------------ Cursor Validation ------------------------------*/
virtual  Boolean
  isValid     ( ) const;
virtual ColumnCursor
 &invalidate  ( );

private:
IContainerColumn
  *pcnrcolClCurrent;
unsigned long
  ulClChanges;
IContainerControl
  *pcnrctlClOwner;
Boolean
  fClVisible;
ICnrColCursorData
  *colCursorData;
};  /* end ColumnCursor */


class Iterator : public IVBase {
typedef IVBase
  Inherited;
public:
/*------------------------ Constructors ------------------------------------*/
  Iterator    ( );

virtual
 ~Iterator    ( );

/*------------------------ Filter Behavior --------------------------------*/
virtual Boolean
  applyTo     ( IContainerObject* object ) = 0;

};  /* end Iterator */



/*-------------------------------- Appearance --------------------------------*/
#ifndef IC_MOTIF_FLAGNOP
virtual IContainerControl
 &setTitle                 ( const char*        title),
 &setTitle                 ( const IResourceId& resourceId),
 &setTitleAlignment        ( TitleAlignment     alignment = centered),
 &showTitle                ( Boolean            show = true),
 &hideTitle                ( ),
 &enableTitleUpdate        ( Boolean            enable = true),
 &disableTitleUpdate       ( ),
 &showTitleSeparator       ( Boolean            show = true),
 &hideTitleSeparator       ( );
#endif

virtual IContainerControl
 &showDetailsViewTitles    ( Boolean            show = true),
 &hideDetailsViewTitles    ( );

#ifndef IC_MOTIF_FLAGNOP
virtual IContainerControl
 &setLineSpacing           ( long               lineSpacing),
 &setIconSize              ( const ISize&       iconSize);
#endif

virtual IContainerControl
 &setSingleSelection       ( ),
 &setMultipleSelection     ( ),
 &setExtendedSelection     ( );

#ifndef IC_MOTIF_FLAGNOP
virtual IContainerControl
 &setNormalTargetEmphasis  ( ),
 &setOrderedTargetEmphasis ( ),
 &setMixedTargetEmphasis   ( );
#endif

#ifndef IC_MOTIF_FLAGNOP
virtual IString
   title                   ( ) const;

Boolean
  areDetailsViewTitlesVisible  ( ) const,
  hasNormalTargetEmphasis      ( ) const,
  hasOrderedTargetEmphasis     ( ) const,
  hasMixedTargetEmphasis       ( ) const,
  isTitleVisible               ( ) const,
  isTitleSeparatorVisible      ( ) const,
  isTitleWriteable             ( ) const;

long
  lineSpacing              ( ) const;

ISize
  iconSize                 ( ) const;

IRectangle
  titleRectangle           ( ) const;
#endif

Boolean
  isSingleSelection        ( ) const,
  isMultipleSelection      ( ) const,
  isExtendedSelection      ( ) const;

/*-------------------------- Automatic Deletion Behavior --------------------*/
virtual IContainerControl
 &setDeleteObjectsOnClose  ( Boolean            destroy = true),
 &setDeleteColumnsOnClose  ( Boolean            destroy = true);

Boolean
  willDeleteObjectsOnClose ( ) const,
  willDeleteColumnsOnClose ( ) const;



/*-------------------- Changing Views ----------------------------------------*/
virtual IContainerControl
 &showTextView             ( ),
 &showFlowedTextView       ( ),
 &showNameView             ( ),
 &showFlowedNameView       ( ),
 &showDetailsView          ( ),
 &showTreeIconView         ( ),
 &showTreeTextView         ( ),
 &showTreeNameView         ( ),
 &showIconView             ( ),
 &arrangeIconView          ( );
#ifndef IC_MOTIF_FLAGNOP
virtual IContainerControl
 &showMiniIcons            ( Boolean  mini=true );
#endif

/*-------------- Determining the View ----------------------------------------*/
Boolean
  isTextView       ( Boolean textOnly=false ) const,
  isNameView       ( Boolean nameOnly=false ) const,
  isIconView       ( Boolean iconOnly=false ) const,
  isDetailsView    ( ) const,
  isTreeView       ( ) const,
  isFlowedTextView ( ) const,
  isFlowedNameView ( ) const,
  isTreeIconView   ( ) const,
  isTreeTextView   ( ) const,
  isTreeNameView   ( ) const,
  isFlowed         ( ) const;

#ifndef IC_MOTIF_FLAGNOP
Boolean
  isShowingMiniIcons ( ) const;
#endif

/*-------------------- Container Refresh -------------------------------------*/
#ifndef IC_MOTIF_FLAGNOP
virtual IContainerControl
 &setRefreshOn           ( Boolean on = true),
 &setRefreshOff          ( ),
 &refresh                ( Boolean immediate=false );

static void
  refreshAllContainers   ( Boolean immediate=false );

Boolean
  isRefreshOn            ( ) const;
#endif

/*-------------- Querying the View Port Rectangle ----------------------------*/
#ifndef IC_MOTIF_FLAGNOP
IRectangle
  viewPortOnWorkspace         ( ) const,
  viewPortOnWindow            ( ) const,
  detailsViewPortOnWorkspace  ( Boolean rightSide = false) const,
  detailsViewPortOnWindow     ( Boolean rightSide = false) const;
#endif

/*------------------- Container Scrolling ------------------------------------*/
#ifndef IC_MOTIF_FLAGNOP
virtual IContainerControl
 &scrollVertically           ( long     pixels),
 &scrollHorizontally         ( long     pixels,
                               Boolean  rightSide = false),
 &scroll                     ( long     vericalPixels,
                               long     horizontalPixels,
                               Boolean  rightSide = false),
 &scrollDetailsHorizontally  ( long     horizontalPixels,
                               Boolean  rightSide = false),

 &scrollToObject             ( const IContainerObject* object),
 &scrollToObject             ( const IContainerObject* object,
                               const IContainerColumn* column,
                               Boolean                 leftJustify = true );
#endif

/*------------------- Tree View Functions ------------------------------------*/
virtual IContainerControl
 &showTreeLine            ( long   treeLinePixelWidth = -1),
 &hideTreeLine            ( ),
#ifndef IC_MOTIF_FLAGNOP
 &setTreeExpandIconSize   ( const  ISize&         sizeIcon),
#endif
 &setTreeViewIndent       ( long                  indentPixels = -1),
 &setTreeItemIcons        ( const IPointerHandle& expanded,
                            const IPointerHandle& collapsed),
 &setTreeItemIcons        ( const IResourceId&    expanded,
                            const IResourceId&    collapsed);

#ifndef IC_MOTIF_FLAGNOP
virtual IContainerControl
 &collapseTree            ( ),
 &expandTree              ( );
#endif

/*------------------- Details View Functions ---------------------------------*/
#ifndef IC_MOTIF_FLAGNOP
virtual IContainerControl
 &showSplitBar        ( Boolean showSplitBar=true),
 &hideSplitBar        ( ),
 &setDetailsViewSplit ( const IContainerColumn* lastColumnBeforeSplit,
                        unsigned long           pixelsFromLeft=50);
Boolean
  isColumnRight      ( const IContainerColumn* column) const;
#endif

virtual IContainerControl
 &addColumn          ( const IContainerColumn*          column,
                       const IContainerColumn*          afterColumn=0),
 &removeColumn       ( const IContainerColumn*          column),
 &removeColumnAt     ( IContainerControl::ColumnCursor& cursor);

IContainerColumn
 *columnAt           ( unsigned long       index) const,
 *columnAt           ( const ColumnCursor& cursor) const;

#ifndef IC_MOTIF_FLAGNOP
IContainerColumn
 *detailsViewSplit   ( ) const;
#endif

unsigned long
    columnCount      ( ) const;

#ifndef IC_MOTIF_FLAGNOP
unsigned long
    splitBarOffset   ( ) const;

IRectangle
  detailsTitleRectangle  ( Boolean rightSide = false ) const;
#endif

/*------------------- Adding and Removing Objects ----------------------------*/
virtual IContainerControl
 &addObjects            ( ICnrAllocator&          allocator,
                          IContainerObject*       parentObject = 0),
 &addObjectsAfter       ( ICnrAllocator&          allocator,
                          const IContainerObject* afterObject,
                          IContainerObject*       parentObject = 0),
 &addObject             ( const IContainerObject* newObject,
                          IContainerObject*       parentObject = 0),
 &addObjectAfter        ( const IContainerObject* newObject,
                          const IContainerObject* afterObject,
                                IContainerObject* parentObject = 0);

virtual IContainerControl
 &removeObject          ( IContainerObject*                object,
                          Boolean                          allContainers = false),
 &removeObjectAt        ( IContainerControl::ObjectCursor& cursor),
 &removeObjectAt        ( IContainerControl::TextCursor&   cursor),
 &removeSelectedObjects ( ),
 &removeAllObjects      ( ),
 &deleteSelectedObjects ( ),
 &deleteAllObjects      ( );

/*----------------- Moving and Copying Subtrees ------------------------------*/
virtual Boolean
  isMoveValid    ( IContainerObject*  moveObject,
                   IContainerObject*  newParentObject = 0,
                   IContainerControl* newContainer = 0,
                   IContainerObject*  afterObject = 0);
virtual Boolean
  moveObjectTo   ( IContainerObject*  moveObject,
                   IContainerObject*  newParentObject = 0,
                   IContainerControl* newContainer = 0,
                   IContainerObject*  afterObject = 0,
                   const IPoint&      iconViewLocation = IPoint(0,0));
virtual IContainerObject
 *copyObjectTo   ( IContainerObject*  copyObject,
                   IContainerObject*  parentObject = 0,
                   IContainerControl* newContainer = 0,
                   IContainerObject*  afterObject =0,
                   const IPoint&      iconViewLocation = IPoint(0,0));


/*-------------------- Retrieving Objects ------------------------------------*/
virtual IContainerObject
 *objectAt           ( unsigned long                          index) const,
 *objectAt           ( const IContainerControl::ObjectCursor& cursor) const,
#ifndef IC_MOTIF_FLAGNOP
 *objectAt           ( const IContainerControl::TextCursor&   cursor) const,
#endif
 *parentObject       ( const IContainerObject*                childObject) const;


ICnrObjectSet
  descendentsOf           ( IContainerObject* parentObject) const,
  immediateDescendentsOf  ( IContainerObject* parentObject) const,
  objectList              ( ) const;


unsigned long
  objectCount             ( ) const;

Boolean
   containsObject( const IContainerObject* object) const;

#ifndef IC_MOTIF_FLAGNOP
virtual IContainerObject
 *cursoredObject          ( ) const;
#endif

/*------------------ Setting Object Attributes -------------------------------*/
virtual IContainerControl
 &setSelected           ( IContainerObject* object,
                           Boolean          select = true),
 &removeSelected        ( IContainerObject* object);

#ifndef IC_MOTIF_FLAGNOP
virtual IContainerControl
 &showSourceEmphasis    ( Boolean           source = true),
 &showSourceEmphasis    ( IContainerObject* object,
                          Boolean           source = true),
 &hideSourceEmphasis    ( ),
 &hideSourceEmphasis    ( IContainerObject* object),
 &setInUse              ( IContainerObject* object,
                          Boolean           inUse = true),
 &removeInUse           ( IContainerObject* object),
 &setCursor             ( IContainerObject* object),
 &enableDataUpdate      ( IContainerObject* object,
                          Boolean           enable=true),
 &disableDataUpdate     ( IContainerObject* object),
 &expand                ( IContainerObject* object),
 &collapse              ( IContainerObject* object),
 &refresh               ( IContainerObject* object,
                          Boolean immediate=false),
 &enableDrop            ( IContainerObject* object,
                          Boolean           enable=true);
#endif

virtual IContainerControl
 &showObject            ( IContainerObject* object,
                          Boolean           visible=true),
 &hideObject            ( IContainerObject* object);

#ifndef IC_MOTIF_FLAGNOP
virtual IContainerControl
 &disableDrop           ( IContainerObject* object);
#endif

/*------------------ Querying Object Attributes ------------------------------*/
#ifndef IC_MOTIF_FLAGNOP
Boolean
  isTarget         ( const IContainerObject* object) const,
  isSource         ( const IContainerObject* object) const;
#endif

Boolean
  isSelected       ( const IContainerObject* object) const;

#ifndef IC_MOTIF_FLAGNOP
Boolean
  isInUse          ( const IContainerObject* object) const,
  isCursored       ( const IContainerObject* object) const,
  isVisible        ( const IContainerObject* object) const,
  isExpanded       ( const IContainerObject* object) const,
  isCollapsed      ( const IContainerObject* object) const,
  isWriteable      ( const IContainerObject* object) const,
  isDropOnAble     ( const IContainerObject* object) const;
#endif

/*------------------ Object Position -----------------------------------------*/
#ifndef IC_MOTIF_FLAGNOP
virtual IContainerControl
 &moveIconTo               ( IContainerObject* object,
                             const IPoint&     point);
IRectangle
  iconRectangle            ( const IContainerObject* object,
                             Boolean                 includeText = false) const,
  detailsObjectRectangle   ( const IContainerObject* object,
                             Boolean                 rightWindow = false ) const,
  detailsObjectRectangle   ( const IContainerObject* object,
                             const IContainerColumn* column) const,
  textRectangle            ( const IContainerObject* object) const,
  convertToWorkspace       ( const IRectangle&       windowRectangle,
                             Boolean                 rightWindow = false) const;

IContainerObject
 *objectUnderPoint         ( const IPoint& point) const;

IContainerColumn
 *columnUnderPoint         ( const IPoint& point) const;
#endif

/*------------------------ Sorting Objects -----------------------------------*/
virtual IContainerControl
 &sortByIconText    ( Boolean                             ascending = true),
 &sort              ( const IContainerControl::CompareFn& sortObject);

static long
  nlsCompare        ( const char* text1,
                      const char* text2) ;

/*------------------------ Filtering Objects ---------------------------------*/
virtual IContainerControl
 &filter            ( ),
 &filter            ( const IContainerControl::FilterFn& filterObject);

/*------------------------ Iterating Objects ---------------------------------*/
virtual IContainerControl
 &allObjectsDo      ( IContainerControl::Iterator& iteratorObject,
                      Boolean                      includeDescendents = false);

/*------------------------ Direct Editing ------------------------------------*/
#ifndef IC_MOTIF_FLAGNOP
virtual IContainerControl
 &editContainerTitle         ( ),
 &editColumnTitle            ( IContainerColumn* column),
 &editObject                 ( IContainerObject* object,
                               IContainerColumn* column=0),
 &closeEdit                  ( ),
 &setEditMLE                 ( IMultiLineEdit*   editField),
 &setEditColumn              ( IContainerColumn* column),
 &setEditObject              ( IContainerObject* object);

IMultiLineEdit
 *currentEditMLE             ( )  const;
IContainerColumn
 *currentEditColumn          ( )  const;
IContainerObject
 *currentEditObject          ( )  const;
#endif


/*------------------------ Miscellaneous -------------------------------------*/
#ifndef IC_MOTIF_FLAGNOP
virtual IContainerControl
 &enableCaching            ( unsigned long deltaValue = 30),
 &disableCaching           ( ),
 &enableDrawItem           ( Boolean enable=true),
 &disableDrawItem          ( ),
 &enableDrawBackground     ( Boolean enable=true),
 &disableDrawBackground    ( );

Boolean
  isCachingEnabled         ( ) const,
  isDrawItemEnabled        ( ) const,
  isDrawBackgroundEnabled  ( ) const;
#endif

static IContainerControl
 *containerFromHandle      ( const IWindowHandle& handle);

unsigned long
  numberOfObjectChanges    ( ) const,
  numberOfColumnChanges    ( ) const;

/*-------------------------------- Overrides ---------------------------------*/
#ifndef IC_MOTIF_FLAGNOP
virtual IContainerControl
 &refresh ( const IRectangle& invalidRectangle,
            Boolean           immediate ),
 &refresh ( IWindow::RefreshType type );
#endif

virtual Boolean
  isVisible               ( ) const;

#ifdef IC_MOTIF
IContainerControl
  &setBackgroundColor    ( const IColor &color );

virtual IEventResult
  sendEvent ( unsigned long           eventId,
              const IEventParameter1& parameter1 = 0,
              const IEventParameter2& parameter2 = 0 ) const,
  sendEvent ( const IEvent&           event )     const,
  sendEvent ( EventType               eventType,
              const IEventParameter1& parameter1 = 0,
              const IEventParameter2& parameter2 = 0 ) const;
#endif

/*----------------------- Notification Members -------------------------------*/
static INotificationId const
  addId,
  removeId,
  selectId,
  enterId,
  titleId,
  titleVisibleId,
  detailsViewTitlesId;

virtual IContainerControl
 &enableNotification ( Boolean enable=true );


protected:
/*----------------------------- Implementation -------------------------------*/
virtual void
  setContainerAttributes    ( unsigned long     attributeToTurnOff,
                              unsigned long     attributeToTurnOn),
  setEmphasis               ( IContainerObject* object,
                              unsigned long     emphasisAttribute,
                              Boolean           setOn=true),
  setAttributes             ( IContainerObject* object,
                              unsigned long     attributeToTurnOn,
                              unsigned long     attributeToTurnOff);

unsigned long
  containerAttributes       ( ) const,
  attributes                ( const IContainerObject* object) const;

IContainerColumn
 *column                    ( IContainerColumn* column,
                              unsigned long     command,
                              Boolean           visible);

virtual unsigned long
  baseRecordSize            ( );

static IWindowHandle
  hwndAllocation            ( );
static ICnrControlList
 &containerList             ( );
static IPrivateResource
 &containerKey              ( );

virtual ISize
 calcMinimumSize            ( ) const;

#ifdef IC_MOTIF
/*------------------------- Compound Control Method --------------------------*/
virtual IWindowHandle
  topHandle() const;

void
  registerCallbacks(),
  unregisterCallbacks();

#endif  //IC_MOTIF


private:
/*------------------------------- Hidden Functions ---------------------------*/
IContainerControl     ( const IContainerControl& container );
IContainerControl
 &operator=           ( const IContainerControl& container );

/*--------------------------------- Private ----------------------------------*/
enum State {
  ok=1,
  noRefresh=2,
  invalid=4,
  autoDeleteObjects=8,
  autoDeleteColumns=16,
  needsRefresh=32
  };

friend class IContainerColumn;
friend class IContainerControl::ColumnCursor;
friend class IContainerControl::ObjectCursor;
friend class IContainerObject;
friend class ICnrEditHandler;
friend class ICnrDestroyHandler;
friend class ICnrControlData;
friend class ICnrObjPrivateData;
friend class ICnrAllocator;
#ifndef IC_WIN
friend Boolean _System pfnCleanUpObjects(ICnrRecord* pRecord,
                                         void* thisCnr);
#endif
#ifdef IC_WIN
friend Boolean __stdcall pfnCleanUpObjects(ICnrRecord* pRecord,
                                           void* thisCnr);
#endif

void
  addContainer        ( ),
  showView            ( unsigned long     viewFlags),
  collectDescendents  ( ICnrObjectSet&    containerSet,
                        IContainerObject* object) const,
  addDefaultHandler   ( ),
  removeDefaultHandler( );

IContainerObject
 *findFirst           ( unsigned long view,
                        const char*   text,
                        Boolean       isCaseSensitive = false,
                        Boolean       isFirstInRecord = false ) const,
 *selectedObject      ( const IContainerObject* objectAfter,
                        unsigned long           emphasis ) const,
 *object              ( const IContainerObject* objectAfter,
                        unsigned long           command ) const;


IRectangle
  viewport            ( unsigned long coordinateSpace,
                        Boolean       rightSplitWindow) const;

static ICnrDestroyHandler
 &destroyHandler         ( );
static void
  setAllocationContainer ( unsigned long handle);

void
  cleanUp();

long
  removeRecords(void* prec, unsigned short number, unsigned short cmd);

void containerInfo       ( ICnrInfo* pCnrInfo ) const,
     setContainerInfo    ( ICnrInfo* pCnrInfo, unsigned long flags ),
     setDefaultContainer ( const Attribute& attribute );

IString
  strContainerTitle;

IContainerColumn
 *pcnrcolClSplitbar;

IContainerColumn
 *pcnrcolClEdit;
IContainerObject
 *pcnrobjClEdit;
IMultiLineEdit
 *pmleClEdit;

Boolean
  fClInvalidate;
int
  lClSplitbar,
  flClState;
unsigned long
  ulClDragEvent;
IBitmapHandle
  hbmClIconViewBackground;
unsigned long
  ulClObjectChanges;
unsigned long
  ulClColumnChanges;

static Attribute
  currentDefaultAttribute;
static Style
  currentDefaultStyle;

ICnrControlData
 *ppd;

public:
#if (IC_OBSOLETE <= IC_OBSOLETE_1)
/*-------------------------- Obsolete Members --------------------------------*/
enum ColorArea {
  background=1,
  foreground,
  border,
  highlightBackground,
  highlightForeground
};
virtual IContainerControl
  &setColor         ( ColorArea value, const IColor& color);
IColor
  color             ( ColorArea value) const;


#ifndef IC_MOTIF_FLAGNOP
Boolean
  isReadOnly       ( const IContainerObject* object) const;
IRectangle
  detailObjectRectangle    ( const IContainerObject* object,
                             Boolean                 rightWindow = false ) const,
  detailObjectRectangle    ( const IContainerObject* object,
                             const IContainerColumn* column) const;
#endif
#endif  //IC_OBSOLETE

};  /* end IContainerControl */



INESTEDBITFLAGCLASSFUNCS(Style, IContainerControl);

#pragma pack()

#ifndef I_NO_INLINES
  #include <icnrctl.inl>
#endif


#endif  /* _ICNRCTL_ */
