/*

Copyright (C) 1996, 1997 John W. Eaton

This file is part of Octave.

Octave is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

Octave is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with Octave; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#if !defined (octave_load_save_h)
#define octave_load_save_h 1

class ostream;

class octave_value;

#include <string>

extern bool save_ascii_data (ostream& os, const octave_value& t,
			     const string& name = string (),
			     bool strip_nan_and_inf = false,
			     bool mark_as_global = false,
			     int precision = 0);

extern bool save_three_d (ostream& os, const octave_value& t,
			  bool parametric = false);

extern void save_user_variables (void);

#endif

/*
;;; Local Variables: ***
;;; mode: C++ ***
;;; End: ***
*/
