function v = qtrans(v,q)
# function v = qtrans(v,q)
# transform the unit quatern v by the unit quatern q;
# v = [w x y z], q = transformation quatern
# returns v = q*v/q

if(!is_vec(v) | length(v) != 4)
  error(sprintf("qtrans: v(%d,%d) must be a quatern",rows(v),columns(v)))
elseif(!is_vec(q) | length(q) != 4)
  error(sprintf("qtrans: q(%d,%d) must be a quatern",rows(q),columns(q)))
endif

v = qmult(q,qmult(v,qinv(q)));
