/*******************************************************************************
* mgn.h                                                                        *
* header for the definition of genlib functions, and macros                    *
* author  : Frederic Petrot                                                    *
* version : 3.18                                                               *
* date    : 03/09/93                                                           *
*******************************************************************************/
/*******************************************************************************
* physical placement functions                                                 *
*******************************************************************************/
void genDEF_PHFIG();
void genLOAD_PHFIG();
void genSAVE_PHFIG();
void genDEF_AB();
void genDEF_PHINS();
phcon_list *genPHCON();
chain_list *genCOPY_UP_CON();
chain_list *genCOPY_UP_CON_FACE();
chain_list *genCOPY_UP_ALL_CON();
phseg_list *genPHSEG();
phseg_list *genCOPY_UP_SEG();
phseg_list *genTHRU_H();
phseg_list *genTHRU_V();
chain_list *genTHRU_CON_H();
chain_list *genTHRU_CON_V();
chain_list *genWIRE1();
chain_list *genWIRE2();
chain_list *genWIRE3();
phvia_list *genPHVIA();
void genPLACE();
void genPLACE_RIGHT();
void genPLACE_TOP();
void genPLACE_LEFT();
void genPLACE_BOTTOM();
void genPLACE_REF();
void genPLACE_ON();
phref_list *genPHREF();
phref_list *genCOPY_UP_REF();
chain_list *genCOPY_UP_ALL_REF();
phvia_list *genPLACE_VIA_REF();
chain_list *genPLACE_CON_REF();
phseg_list *genPLACE_SEG_REF();
void genFLATTEN_PHFIG();
void genFLATTEN_ALL_PHINS();
long genGET_REF_X();
long genGET_REF_Y();
long genGET_CON_X();
long genGET_CON_Y();
long genGET_INS_X();
long genGET_INS_Y();
long genHEIGHT();
long genWIDTH();
void genREVERSE_PHCON();
void genOUTLINE();
/*******************************************************************************
* netlist description functions                                                *
*******************************************************************************/
void genDEF_LOFIG();
void genLOAD_LOFIG();
void genSAVE_LOFIG();
void genLOINS();
void genLOINSE();
void genLOTRS();
void genLOCON();
void genLOSIGMERGE();
void genFLATTEN_LOFIG();
void genFLATTEN_ALL_LOINS();
void genDEF_PHSC();
void genSAVE_PHSC();
void genSC_PLACE();
void genSC_RIGHT();
void genSC_LEFT();
void genSC_TOP();
void genSC_BOTTOM();
void genSC_CHANNEL();
void genSC_CON_CHANNEL();
/*******************************************************************************
* name forming functions, for both views                                       *
*******************************************************************************/
char *genBUS();
char *genELM();
char *genNAME();

/*******************************************************************************
* macro definitions for allowed stdlib functions                               *
*******************************************************************************/
#define PRINTF       printf
#define STRLEN(a)    (long)(a == NULL ? 0 : strlen(a))

/*******************************************************************************
* macro definitions in order to allows float and integer typed parameters      *
*******************************************************************************/
#define DEF_PHFIG(name) 							genDEF_PHFIG(name)
#define LOAD_PHFIG(name)							genLOAD_PHFIG(name)
#define SAVE_PHFIG									genSAVE_PHFIG
#define DEF_AB(dx1,dy1,dx2,dy2) \
				genDEF_AB((long)((dx1)*SCALE_X),(long)((dy1)*SCALE_X), \
								(long)((dx2)*SCALE_X),(long)((dy2)*SCALE_X))
#define DEF_PHINS(name) \
				genDEF_PHINS(name)
#define PHCON(layer,width,name,orient,x,y) \
				genPHCON(layer,(long)((width)*SCALE_X),name,orient, \
							(long)((x)*SCALE_X),(long)((y)*SCALE_X))
#define COPY_UP_CON(index,locname,insname,newname) \
				genCOPY_UP_CON(index,locname,insname,newname)
#define COPY_UP_ALL_CON(orient,insname,cheminom) \
				genCOPY_UP_ALL_CON(orient,insname,cheminom)
#define COPY_UP_CON_FACE(orient,locname,insname,newname) \
				genCOPY_UP_CON_FACE(orient,locname,insname,newname)
#define PHSEG(layer,width,name,x1,y1,x2,y2) \
				genPHSEG(layer,(long)((width)*SCALE_X),name,(long)((x1)*SCALE_X), \
							(long)((y1)*SCALE_X), (long)((x2)*SCALE_X), \
							(long)((y2)*SCALE_X))
#define COPY_UP_SEG(locname,insname,newname) \
				genCOPY_UP_SEG(locname,insname,newname)
#define WIRE1(layer,width,ins1,con1,index1,ins2,con2,index2) \
				genWIRE1(layer,(long)((width)*SCALE_X),ins1,con1,index1,ins2, \
							con2,index2)
#define WIRE2(layer,width,ins1,con1,index1,ins2,con2,index2,x,y) \
				genWIRE2(layer,(long)((width)*SCALE_X),ins1,con1,index1,ins2, \
							con2,index2, (long)((x)*SCALE_X),(long)((y)*SCALE_X))
#define WIRE3(layer,width,ins1,con1,index1,ins2,con2,index2,x1,y1,x2,y2)  \
				genWIRE3(layer,(long)((width)*SCALE_X),ins1,con1,index1,ins2, \
							con2,index2, (long)((x1)*SCALE_X),(long)((y1)*SCALE_X), \
							(long)((x2)*SCALE_X),(long)((y2)*SCALE_X))
#define PHVIA(type,x,y) \
				genPHVIA(type,(long)((x)*SCALE_X),(long)((y)*SCALE_X))
#define PLACE(figname,insname,sym,x,y) \
				genPLACE(figname,insname,sym,(long)((x)*SCALE_X),(long)((y)*SCALE_X))
#define PLACE_RIGHT(figname,insname,sym)	genPLACE_RIGHT(figname,insname,sym)
#define PLACE_TOP(figname,insname,sym)		genPLACE_TOP(figname,insname,sym)
#define PLACE_LEFT(figname,insname,sym)	genPLACE_LEFT(figname,insname,sym)
#define PLACE_BOTTOM(figname,insname,sym)	genPLACE_BOTTOM(figname,insname,sym)
#define PLACE_REF(figname,insname,sym,insref,refname) \
				genPLACE_REF(figname,insname,sym,insref,refname)
#define PLACE_ON(figname,insname1,con1,index1,sym,insname2,con2,index2) \
				genPLACE_ON(figname,insname1,con1,index1,sym,\
							insname2,con2,index2)
#define THRU_H(layer,width,y) \
				genTHRU_H(layer,(long)((width)*SCALE_X),(long)((y)*SCALE_X))
#define THRU_V(layer,width,x) \
				genTHRU_V(layer,(long)((width)*SCALE_X),(long)((x)*SCALE_X))
#define THRU_CON_H(layer,width,name,y) \
				genTHRU_CON_H(layer,(long)((width)*SCALE_X),name,(long)((y)*SCALE_X))
#define THRU_CON_V(layer,width,name,x) \
				genTHRU_CON_V(layer,(long)((width)*SCALE_X),name,(long)((x)*SCALE_X))
#define PHREF(type,name,x,y) \
				genPHREF(type,name,(long)((x)*SCALE_X),(long)((y)*SCALE_X))
#define COPY_UP_REF(refname,insname,newname) \
				genCOPY_UP_REF(refname,insname,newname)
#define COPY_UP_ALL_REF(reftype,insname,cheminom) \
				genCOPY_UP_ALL_REF(reftype,insname,cheminom)
#define PLACE_VIA_REF(insname,refname,type) \
				genPLACE_VIA_REF(insname,refname,type)
#define PLACE_CON_REF(insname,refname,conname,layer,width,face) \
				genPLACE_CON_REF(insname,refname,conname,layer,\
									(long)((width)*SCALE_X),face)
#define PLACE_SEG_REF(insname,refname,layer,width,face) \
				genPLACE_SEG_REF(insname,refname,layer,(long)((width)*SCALE_X),face)
#define GET_REF_X(insname,refname) \
				((genGET_REF_X(insname,refname)/SCALE_X))
#define GET_REF_Y(insname,refname) \
				((genGET_REF_Y(insname,refname)/SCALE_X))
#define GET_INS_X(insname) 					((genGET_INS_X(insname)/SCALE_X))
#define GET_INS_Y(insname)						((genGET_INS_Y(insname)/SCALE_X))
#define GET_CON_X(insname,conname,index) \
				((genGET_CON_X(insname,conname,index)/SCALE_X))
#define GET_CON_Y(insname,conname,index) \
				((genGET_CON_Y(insname,conname,index)/SCALE_X))
#define HEIGHT(cellName)						((genHEIGHT(cellName)/SCALE_X))
#define WIDTH(cellName)							((genWIDTH(cellName)/SCALE_X))
#define FLATTEN_PHFIG(insname,concat)		genFLATTEN_PHFIG(insname,concat)
#define FLATTEN_ALL_PHINS(concat, catal)	genFLATTEN_ALL_PHINS(concat, catal)
#define REVERSE_PHCON(conname)				genREVERSE_PHCON(conname)
#define OUTLINE	 								genOUTLINE

#define DEF_LOFIG(name) 						genDEF_LOFIG(name)
#define LOAD_LOFIG(name) 						genLOAD_LOFIG(name)
#define SAVE_LOFIG 								genSAVE_LOFIG
#define LOSIG(name)								genLOSIG(name)
#define LOINS 										genLOINS
#define LOINSE										genLOINSE
#define LOTRS(type,width,length,grid,source,drain) \
				genLOTRS(type,(long)((width)*SCALE_X), \
							(long)((length)*SCALE_X),grid,source,drain)
#define LOCON(conname,direction,signame)	genLOCON(conname,direction,signame)
#define LOSIGMERGE(signame1, signame2)		genLOSIGMERGE(signame1, signame2)
#define FLATTEN_LOFIG(insname,concat)		genFLATTEN_LOFIG(insname,concat)
#define FLATTEN_ALL_LOINS(concat, catal)	genFLATTEN_ALL_LOINS(concat, catal)
#define UNFLATTEN_LOFIG							genUNFLATTEN_LOFIG

#define DEF_PHSC(name)							genDEF_PHSC(name)
#define SAVE_PHSC									genSAVE_PHSC
#define SC_PLACE(insname,sym,x,y) \
				genSC_PLACE(insname,sym,(long)((x)*SCALE_X),(long)((y)*SCALE_X))
#define SC_RIGHT(insname,sym)					genSC_RIGHT(insname,sym)
#define SC_LEFT(insname,sym)					genSC_LEFT(insname,sym)
#define SC_TOP(insname,sym)					genSC_TOP(insname,sym)
#define SC_BOTTOM(insname,sym)				genSC_BOTTOM(insname,sym)
#define SC_CHANNEL(direction,width,insname) \
				genSC_CHANNEL(direction,(long)((width)*SCALE_X),insname)
#define SC_CON_CHANNEL(conname,orient,layer,width,insname) \
				genSC_CON_CHANNEL(conname,orient,layer,\
										(long)((width)*SCALE_X),insname)

#define BUS(signame,from,to)					genBUS(signame,from,to)
#define ELM(signame,number)					genELM(signame,number)
#define NAME 										genNAME
