/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit : Icon library                                                */
/*    Fichier : IconAccess.h (access macros to icons definition)            */
/*                                                                          */
/*    (c) copyright 1991 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) : Vincent POUILLEY                      le : 29/05/1992     */
/*                                                                          */
/*    Modifie par : Vincent POUILLEY                    le : 16/11/1992     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/*    $Id: iac.h,v 2.1.1.1 1993/09/23 16:04:30 sax Exp sax $                    */
/*                                                                          */
/****************************************************************************/

#ifndef __ICONACCESS_H__
#define __ICONACCESS_H__

/*****************************/
/* constantes definitions    */
/*****************************/
#define COMP_ISLINE     0x01
#define COMP_ISARCSTART 0x02
#define COMP_ISARCEND   0x04
#define COMP_ISARCCOMP  0x08

#ifndef SAX_NORTH
#define SAX_NORTH 0
#define SAX_SOUTH 1
#define SAX_WEST  2
#define SAX_EAST  3
#endif

#ifndef SAX_CENTER
#define SAX_LEFT   0
#define SAX_CENTER 1
#define SAX_RIGHT  2

#define SAX_UP     0
/*#define SAX_CENTER 1*/
#define SAX_DOWN   2
#endif

#ifndef SAX_HORIZONTAL
#define SAX_HORIZONTAL 0
#define SAX_VERTICAL   1
#endif

/* connector direction */
#ifndef IN
#define IN          'I'
#define OUT         'O'
#define INOUT       'B'
#define UNKNOWN     'X'
#define TRISTATE    'Z'
#define TRANSCV     'T'
#endif

#ifndef min
#define min(a, b) (((a) > (b)) ? (b) : (a))
#endif
#ifndef max
#define max(a, b) (((a) > (b)) ? (a) : (b))
#endif

/********************/
/* access to gates  */
/********************/

/*
 *  access to next gate
 */
    /*
	 * ICONGATE_NEXT :
	 * parameter :
	 *     icon_gate : IconGate_list * (pointer to a gate)
	 * return :
	 *     IconGate_list * (pointer to the next gate)
	 */
#define ICONGATE_NEXT(icon_gate) ((icon_gate)->NEXT)

/*
 *  access to the dimensions
 */
	/*
	 * ICONGATE_X :
	 * parameter :
	 *     icon_gate : IconGate_list * (pointer to a gate)
	 * return :
	 *     t_pitchcoord (top-left corner of icon)
	 */
#define ICONGATE_X(icon_gate) ((icon_gate)->x)
    /*
	 * ICONGATE_Y :
	 * parameter :
	 *     icon_gate : IconGate_list * (pointer to a gate)
	 * return :
	 *     t_pitchcoord (top-left corner of icon)
	 */
#define ICONGATE_Y(icon_gate) ((icon_gate)->y)
	/*
	 * ICONGATE_WIDTH :
	 * parameter :
	 *     icon_gate : IconGate_list * (pointer to a gate)
	 * return :
	 *     t_pitchcoord (width of icon)
	 */
#define ICONGATE_WIDTH(icon_gate) ((icon_gate)->width)
    /*
	 * ICONGATE_HEIGHT :
	 * parameter :
	 *     icon_gate : IconGate_list * (pointer to a gate)
	 * return :
	 *     t_pitchcoord (height of icon)
	 */
#define ICONGATE_HEIGHT(icon_gate) ((icon_gate)->height)
    /*
	 * ICONGATE_ISDEFAULT :
	 * parameter :
	 *     icon_gate : IconGate_list * (pointer to a gate)
	 * return :
	 *     BOOL
	 */
#define ICONGATE_ISDEFAULT(icon_gate) ((icon_gate)->default_description)
    /*
	 * ICONGATE_SCALE :
	 * parameter :
	 *     icon_gate : IconGate_list * (pointer to a gate)
	 * return :
	 *     double (scale of the icon)
	 */
#define ICONGATE_SCALE(icon_gate) ((icon_gate)->scale)

/*
 *  access to texts
 */
    /*
	 * ICONGATE_MODELNAME :
	 * parameter :
	 *     icon_gate : IconGate_list * (pointer to a gate)
	 * return :
	 *     char * (model name of the gate)
	 */
#define ICONGATE_MODELNAME(icon_gate) ((icon_gate)->model_name.string)
    /*
	 * ICONGATE_X_MODELNAME :
	 * parameter :
	 *     icon_gate : IconGate_list * (pointer to a gate)
	 * return :
	 *     t_pitchcoord (x coordinate of the model name)
	 */
#define ICONGATE_X_MODELNAME(icon_gate) ((icon_gate)->model_name.geo.x)
    /*
	 * ICONGATE_Y_MODELNAME :
	 * parameter :
	 *     icon_gate : IconGate_list * (pointer to a gate)
	 * return :
	 *     t_pitchcoord (y coordinate of the model name)
	 */
#define ICONGATE_Y_MODELNAME(icon_gate) ((icon_gate)->model_name.geo.y)
    /*
	 * ICONGATE_HALIGN_MODELNAME :
	 * parameter :
	 *	   icon_gate : IconGate_list * (pointer to a gate)
	 * return :
	 *     int  returning the alignment :
	 *	      SAX_LEFT
	 *		  SAX_CENTER
	 *		  SAX_RIGHT
	 */
#define ICONGATE_HALIGN_MODELNAME(icon_gate) ((icon_gate)->model_name.geo.halign)
    /*
	 * ICONGATE_VALIGN_MODELNAME :
	 * parameter :
	 *     icon_gate : IconGate_list * (pointer to a gate)
	 * return :
	 *     int  returning the alignment :
	 *	      SAX_UP
	 *		  SAX_CENTER
	 *		  SAX_DOWN
	 */
#define ICONGATE_VALIGN_MODELNAME(icon_gate) ((icon_gate)->model_name.geo.valign)
    /*
	 * ICONGATE_DIRECTION_MODELNAME :
	 * parameter :
	 *     icon_gate : IconGate_list * (pointer to a gate)
	 * return :
	 *     int  returning the direction of the texte :
	 *	     SAX_HORIZONTAL
	 *		 SAX_VERTICAL
	 */
#define ICONGATE_DIRECTION_MODELNAME(icon_gate) ((icon_gate)->model_name.geo.direction)
    /*
	 * ICONGATE_X_INSNAME :
	 * parameter :
	 *     icon_gate : IconGate_list * (pointer to a gate)
	 * return :
	 *     t_pitchcoord (x coordinate of the instance name)
	 */
#define ICONGATE_X_INSNAME(icon_gate) ((icon_gate)->ins_geo.x)
    /*
	 * ICONGATE_Y_INSNAME :
	 * parameter :
	 *     icon_gate : IconGate_list * (pointer to a gate)
	 * return :
	 *     t_pitchcoord (y coordinate of the instance name)
	 */
#define ICONGATE_Y_INSNAME(icon_gate) ((icon_gate)->ins_geo.y)
    /*
	 * ICONGATE_HALIGN_INSNAME :
	 * parameter :
	 *     icon_gate : IconGate_list * (pointer to a gate)
	 * return :
	 *     int  returning the alignment :
	 *	      SAX_LEFT
	 *		  SAX_CENTER
	 *		  SAX_RIGHT
	 */
#define ICONGATE_HALIGN_INSNAME(icon_gate) ((icon_gate)->ins_geo.halign)
    /*
	 * ICONGATE_VALIGN_INSNAME :
	 * parameter :
	 *     icon_gate : IconGate_list * (pointer to a gate)
	 * return :
	 *     int  returning the alignment :
	 *	      SAX_UP
	 *		  SAX_CENTER
	 *		  SAX_DOWN
	 */
#define ICONGATE_VALIGN_INSNAME(icon_gate) ((icon_gate)->ins_geo.valign)
    /*
	 * ICONGATE_DIRECTION_INSNAME :
	 * parameter :
	 *     icon_gate : IconGate_list * (pointer to a gate)
	 * return :
	 *     int  returning the direction of the texte :
	 *	     SAX_HORIZONTAL
	 *		 SAX_VERTICAL
	 */
#define ICONGATE_DIRECTION_INSNAME(icon_gate) ((icon_gate)->ins_geo.direction)
    /*
	 * ICONGATE_X_LABEL :
	 * parameter :
	 *     icon_gate : IconGate_list * (pointer to a gate)
	 * return :
	 *     t_pitchcoord (x coordinate of the label)
	 */
#define ICONGATE_X_LABEL(icon_gate) ((icon_gate)->label_geo.x)
    /*
	 * ICONGATE_Y_LABEL :
	 * parameter :
	 *     icon_gate : IconGate_list * (pointer to a gate)
	 * return :
	 *     t_pitchcoord (y coordinate of the label)
	 */
#define ICONGATE_Y_LABEL(icon_gate) ((icon_gate)->label_geo.y)
    /*
	 * ICONGATE_HALIGN_LABEL :
	 * parameter :
	 *     icon_gate : IconGate_list * (pointer to a gate)
	 * return :
	 *     int  returning the alignment :
	 *	      SAX_LEFT
	 *		  SAX_CENTER
	 *		  SAX_RIGHT
	 */
#define ICONGATE_HALIGN_LABEL(icon_gate) ((icon_gate)->label_geo.halign)
    /*
	 * ICONGATE_VALIGN_LABEL :
	 * parameter :
	 *     icon_gate : IconGate_list * (pointer to a gate)
	 * return :
	 *     int  returning the alignment :
	 *	      SAX_UP
	 *		  SAX_CENTER
	 *		  SAX_DOWN
	 */
#define ICONGATE_VALIGN_LABEL(icon_gate) ((icon_gate)->label_geo.valign)
    /*
	 * ICONGATE_DIRECTION_LABEL :
	 * parameter :
	 *     icon_gate : IconGate_list * (pointer to a gate)
	 * return :
	 *     int  returning the direction of the texte :
	 *	     SAX_HORIZONTAL
	 *		 SAX_VERTICAL
	 */
#define ICONGATE_DIRECTION_LABEL(icon_gate) ((icon_gate)->label_geo.direction)

/*
 *  access to connectors
 */
    /*
	 * ICONGATE_CONNECTORS :
	 * parameter :
	 *     icon_gate : IconGate_list * (pointer to a gate)
	 * return :
	 *     IconCon_list * (list of connectors)
	 */
#define ICONGATE_CONNECTORS(icon_gate) ((icon_gate)->connectors)

/*
 *  access to lines
 */
    /*
	 * ICONGATE_LINES :
	 * parameter :
	 *     icon_gate : IconGate_list * (pointer to a gate)
	 * return :
	 *     IconLine_list * (list of lines)
	 */
#define ICONGATE_LINES(icon_gate) ((icon_gate)->lines)

/*
 *  access to shapes
 */
    /*
	 * ICONGATE_SHAPES :
	 * parameter :
	 *     icon_gate : IconGate_list * (pointer to a gate)
	 * return :
	 *     IconShape_list * (list of shapes)
	 */
#define ICONGATE_SHAPES(icon_gate) ((icon_gate)->shapes)

/*
 *  access to circles
 */
    /*
	 * ICONGATE_CIRCLES :
	 * parameter :
	 *     icon_gate : IconGate_list * (pointer to a gate)
	 * return :
	 *     IconCircle_list * (list of circles)
	 */
#define ICONGATE_CIRCLES(icon_gate) ((icon_gate)->circles)

/*
 *  access to arcs
 */
    /*
	 * ICONGATE_ARCS :
	 * parameter :
	 *     icon_gate : IconGate_list * (pointer to a gate)
	 * return :
	 *     IconArc_list * (list of arcs)
	 */
#define ICONGATE_ARCS(icon_gate) ((icon_gate)->arcs)

/*
 *  access to USER field
 */
    /*
	 * ICONGATE_USER :
	 * parameter :
	 *     icon_gate : IconGate_list * (pointer to a gate)
	 * return :
	 *     ptype_list * (USER field)
	 */
#define ICONGATE_USER(icon_gate) ((icon_gate)->USER)

/*
 *  access to bitmap definition
 */
    /*
	 * ICONGATE_BITMAP :
	 * parameter :
	 *     icon_gate : IconGate_list * (pointer to a gate)
	 * return :
	 *     char * (pointer to the Bitmap definition)
	 */
#define ICONGATE_BITMAP(icon_gate) ((icon_gate)->data)

/*************************/
/* access to connectors */
/*************************/

/*
 *  access to next connector
 */
    /*
	 * ICONCON_NEXT :
	 * parameter :
	 *     icon_con : IconCon_list * (pointer to a connector)
	 * return :
	 *     IconCon_list * (pointer to the next connector)
	 */
#define ICONCON_NEXT(icon_con) ((icon_con)->NEXT)

/*
 *  coordinates of connector
 */
    /*
	 * ICONCON_X :
	 * parameter :
	 *     icon_con : IconCon_list * (pointer to a connector)
	 * return :
	 *     t_pitchcoord (x coordinate of connector)
	 */
#define ICONCON_X(icon_con) ((icon_con)->x)
    /*
	 * ICONCON_Y :
	 * parameter :
	 *     icon_con : IconCon_list * (pointer to a connector)
	 * return :
	 *     t_pitchcoord (y coordinate of connector)
	 */
#define ICONCON_Y(icon_con) ((icon_con)->y)

/*
 *  access to the face on which the connector is placed
 */
    /*
	 * ICONCON_SIDE :
	 * parameter :
	 *     icon_con : IconCon_list * (pointer to a connector)
	 * return :
	 *     int returning the face :
	 *	      SAX_NORTH
	 *		  SAX_SOUTH
	 *		  SAX_EAST
	 *		  SAX_WEST
	 */
#define ICONCON_SIDE(icon_con) ((icon_con)->side)

/*
 *  access to the logical direction of the connector
 */
    /*
	 * ICONCON_DIRECTION :
	 * parameter :
	 *     icon_con : IconCon_list * (pointer to a connector)
	 * return :
	 *     char returning the direction :
	 *	      IN
	 *	      OUT
	 *	      INOUT
	 *	      UNKNOWN
	 *	      TRISTATE
	 *	      TRANSCV
	 */
#define ICONCON_DIRECTION(icon_con) ((icon_con)->direction)

/*
 *  access to text of connector
 */
    /*
	 * ICONCON_NAME :
	 * parameter :
	 *     icon_con : IconCon_list * (pointer to a connector)
	 * return :
	 *     char * (name of connector)
	 */
#define ICONCON_NAME(icon_con) ((icon_con)->name.string)
    /*
	 * ICONCON_X_NAME :
	 * parameter :
	 *     icon_con : IconCon_list * (pointer to a connector)
	 * return :
	 *     t_pitchcoord (x coordinate of name of connector)
	 */
#define ICONCON_X_NAME(icon_con) ((icon_con)->name.geo.x)
    /*
	 * ICONCON_Y_NAME :
	 * parameter :
	 *     icon_con : IconCon_list * (pointer to a connector)
	 * return :
	 *     t_pitchcoord (y coordinate of name of connector)
	 */
#define ICONCON_Y_NAME(icon_con) ((icon_con)->name.geo.y)
    /*
	 * ICONCON_HALIGN_NAME :
	 * parameter :
	 *     icon_con : IconCon_list * (pointer to a connector)
	 * return :
	 *     int  returning the alignment :
	 *	      SAX_LEFT
	 *		  SAX_CENTER
	 *		  SAX_RIGHT
	 */
#define ICONCON_HALIGN_NAME(icon_con) ((icon_con)->name.geo.halign)
    /*
	 * ICONCON_VALIGN_NAME :
	 * parameter :
	 *     icon_con : IconCon_list * (pointer to a connector)
	 * return :
	 *     int  returning the alignment :
	 *	      SAX_UP
	 *		  SAX_CENTER
	 *		  SAX_DOWN
	 */
#define ICONCON_VALIGN_NAME(icon_con) ((icon_con)->name.geo.valign)
    /*
	 * ICONCON_DIRECTION_NAME :
	 * parameter :
	 *     icon_con : IconCon_list * (pointer to a connector)
	 * return :
	 *     int  returning the direction of the texte :
	 *	     SAX_HORIZONTAL
	 *		 SAX_VERTICAL
	 */
#define ICONCON_DIRECTION_NAME(icon_con) ((icon_con)->name.geo.direction)

/*
 *  access to USER field
 */
    /*
	 * ICONCON_USER :
	 * parameter :
	 *     icon_con : IconCon_list * (pointer to a connector)
	 * return :
	 *     ptype_list * (USER field)
	 */
#define ICONCON_USER(icon_con) ((icon_con)->USER)

/********************/
/* access to lines */
/********************/

/*
 *  access to next line
 */
    /*
	 * ICONLINE_NEXT :
	 * parameter :
	 *     icon_line : IconLine_list * (pointer to a line)
	 * return :
	 *     IconLine_list * (pointer to the next line)
	 */
#define ICONLINE_NEXT(icon_line) ((icon_line)->NEXT)

/*
 *  access to each end of the line
 */
    /*
	 * ICONLINE_X0 :
	 * parameter :
	 *     icon_line : IconLine_list * (pointer to a line)
	 * return :
	 *     t_pitchcoord (x coordinate of the start of the line)
	 */
#define ICONLINE_X0(icon_line) ((icon_line)->x0)
    /*
	 * ICONLINE_Y0 :
	 * parameter :
	 *     icon_line : IconLine_list * (pointer to a line)
	 * return :
	 *     t_pitchcoord (y coordinate of the start of the line)
	 */
#define ICONLINE_Y0(icon_line) ((icon_line)->y0)
    /*
	 * ICONLINE_X1 :
	 * parameter :
	 *     icon_line : IconLine_list * (pointer to a line)
	 * return :
	 *     t_pitchcoord (x coordinate of the end of the line)
	 */
#define ICONLINE_X1(icon_line) ((icon_line)->x1)
    /*
	 * ICONLINE_Y1 :
	 * parameter :
	 *     icon_line : IconLine_list * (pointer to a line)
	 * return :
	 *     t_pitchcoord (y coordinate of the end of the line)
	 */
#define ICONLINE_Y1(icon_line) ((icon_line)->y1)


/**********************/
/* access to shapes */
/**********************/

/*
 *  access to the next shape
 */
    /*
	 * ICONSHAPE_NEXT :
	 * parameter :
	 *     icon_shape : IconSahpe_list * (pointer to a shape)
	 * return :
	 *     IconSahpe_list * (pointer to the next shape)
	 */
#define ICONSHAPE_NEXT(icon_shape) ((icon_shape)->NEXT)

/*
 *  access to the first component of the shape
 */
    /*
	 * ICONSHAPE_FIRSTCOMP :
	 * parameter :
	 *     icon_shape : IconSahpe_list * (pointer to a shape)
	 * return :
	 *     IconComp_list * (pointer to the first component of the shape)
	 */
#define ICONSHAPE_FIRSTCOMP(icon_shape) ((icon_shape)->components)

/*
 *  access to the number of components in the shape
 */
    /*
	 * ICONSHAPE_NBCOMP :
	 * parameter :
	 *     icon_shape : IconSahpe_list * (pointer to a shape)
	 * return :
	 *     int (number of components)
	 */
#define ICONSHAPE_NBCOMP(icon_shape) ((icon_shape)->number_of_components)

/*
 *  access to the next component
 */
    /*
	 * ICONSHAPE_NEXTCOMP :
	 * parameter :
	 *     icon_comp : IconComp_list * (pointer to a component of shape)
	 * return :
	 *     IconComp_list * (pointer to the next component of shape)
	 */
#define ICONSHAPE_NEXTCOMP(icon_comp) ((icon_comp)->NEXT)

/*
 *  access to the component coordinates
 */
    /*
	 * ICONSHAPE_X_COMP :
	 * parameter :
	 *     icon_comp : IconComp_list * (pointer to a component of shape)
	 * return :
	 *     t_pitchcoord (x coordinate of the component)
	 */
#define ICONSHAPE_X_COMP(icon_comp) ((icon_comp)->x)
    /*
	 * ICONSHAPE_Y_COMP :
	 * parameter :
	 *     icon_comp : IconComp_list * (pointer to a component of shape)
	 * return :
	 *     t_pitchcoord (y coordinate of the component)
	 */
#define ICONSHAPE_Y_COMP(icon_comp) ((icon_comp)->y)

/*
 *  type of the component
 */
    /*
	 * ICONSHAPE_COMP_ISLINE :
	 * parameter :
	 *     icon_comp : IconComp_list * (pointer to a component of shape)
	 * return :
	 *     BOOL
	 */
#define ICONSHAPE_COMP_ISLINE(icon_comp) (((icon_comp)->type & COMP_ISLINE) ? 1 : 0)
    /*
	 * ICONSHAPE_COMP_ISARCSTART :
	 * parameter :
	 *     icon_comp : IconComp_list * (pointer to a component of shape)
	 * return :
	 *     BOOL
	 */
#define ICONSHAPE_COMP_ISARCSTART(icon_comp) (((icon_comp)->type & COMP_ISARCSTART) ? 1 : 0)
    /*
	 * ICONSHAPE_COMP_ISARCEND :
	 * parameter :
	 *     icon_comp : IconComp_list * (pointer to a component of shape)
	 * return :
	 *     BOOL
	 */
#define ICONSHAPE_COMP_ISARCEND(icon_comp) (((icon_comp)->type & COMP_ISARCEND) ? 1 : 0)
    /*
	 * ICONSHAPE_COMP_ISARCCOMP :
	 * parameter :
	 *     icon_comp : IconComp_list * (pointer to a component of shape)
	 * return :
	 *     BOOL
	 */
#define ICONSHAPE_COMP_ISARCCOMP(icon_comp) (((icon_comp)->type & COMP_ISARCCOMP) ? 1 : 0)

/*
 *  type of the component
 */
	/*
	 * ICONSHAPE_TYPE_COMP   :
	 *  parameter :
	 *  	   icon_comp : IconComp_list * (pointer to a component of shape)
     *  return
	 *  	   COMP_ISLINE | COMP_ISARCSTART | COMP_ISARCEND | COMP_ISARCCOMP
	 */
#define ICONSHAPE_TYPE_COMP(icon_comp) ((icon_comp)->type )



/*********************/
/* access to circles */
/*********************/

/*
 *  access to the next circle
 */
    /*
	 * ICONCIRCLE_NEXT :
	 * parameter :
	 *     icon_circle : IconCircle_list * (pointer to a circle)
	 * return :
	 *     IconCircle_list * (pointer to the next circle)
	 */
#define ICONCIRCLE_NEXT(icon_circle) ((icon_circle)->NEXT)

/*
 *  access to dimensions of englobing rectangle of circle
 */
    /*
	 * ICONCIRCLE_WIDTH :
	 * parameter :
	 *     icon_circle : IconCircle_list * (pointer to a circle)
	 * return :
	 *     t_pitchcoord (width of englobing rectangle)
	 */
#define ICONCIRCLE_WIDTH(icon_circle) ((icon_circle)->width)
    /*
	 * ICONCIRCLE_HEIGHT :
	 * parameter :
	 *     icon_circle : IconCircle_list * (pointer to a circle)
	 * return :
	 *     t_pitchcoord (height of englobing rectangle)
	 */
#define ICONCIRCLE_HEIGHT(icon_circle) ((icon_circle)->height)

/*
 *  access to englobing rectangle of circle
 */
    /*
	 * ICONCIRCLE_X0 :
	 * parameter :
	 *     icon_circle : IconCircle_list * (pointer to a circle)
	 * return :
	 *     t_pitchcoord (x coordinate of up/left corner of englobing rectangle)
	 */
#define ICONCIRCLE_X0(icon_circle) ((icon_circle)->x)
    /*
	 * ICONCIRCLE_Y0 :
	 * parameter :
	 *     icon_circle : IconCircle_list * (pointer to a circle)
	 * return :
	 *     t_pitchcoord (y coordinate of up/left corner of englobing rectangle)
	 */
#define ICONCIRCLE_Y0(icon_circle) ((icon_circle)->y)
    /*
	 * ICONCIRCLE_X1 :
	 * parameter :
	 *     i_circle : IconCircle_list * (pointer to a circle)
	 * return :
	 *     t_pitchcoord (x coordinate of bottom/right corner of englobing rectangle)
	 */
#define ICONCIRCLE_X1(i_circle) (ICONCIRCLE_X0(i_circle) + ICONCIRCLE_WIDTH(i_circle))
    /*
	 * ICONCIRCLE_Y1 :
	 * parameter :
	 *     icon_circle : IconCircle_list * (pointer to a circle)
	 * return :
	 *     t_pitchcoord (y coordinate of bottom/right corner of englobing rectangle)
	 */
#define ICONCIRCLE_Y1(i_circle) (ICONCIRCLE_Y0(i_circle) + ICONCIRCLE_HEIGHT(i_circle))


/******************/
/* access to arcs */
/******************/

/*
 *  access to the next arc
 */
    /*
	 * ICONARC_NEXT :
	 * parameter :
	 *     icon_arc : IconArc_list * (pointer to an arc)
	 * return :
	 *     IconArc_list * (pointer to the next arc)
	 */
#define ICONARC_NEXT(icon_arc) ((icon_arc)->NEXT)

/*
 *  access to dimensions of englobing rectangle of the arc
 */
    /*
	 * ICONARC_WIDTH :
	 * parameter :
	 *     icon_arc : IconArc_list * (pointer to an arc)
	 * return :
	 *     t_pitchcoord (width of englobing rectangle)
	 */
#define ICONARC_WIDTH(icon_arc) ((icon_arc)->width)
    /*
	 * ICONARC_HEIGHT :
	 * parameter :
	 *     icon_arc : IconArc_list * (pointer to an arc)
	 * return :
	 *     t_pitchcoord (height of englobing rectangle)
	 */
#define ICONARC_HEIGHT(icon_arc) ((icon_arc)->height)

/*
 *  access to englobing rectangle of the arc
 */
    /*
	 * ICONARC_X0 :
	 * parameter :
	 *     icon_arc : IconArc_list * (pointer to an arc)
	 * return :
	 *     t_pitchcoord (x coordinate of up/left corner of englobing rectangle)
	 */
#define ICONARC_X0(icon_arc) ((icon_arc)->x)
    /*
	 * ICONARC_Y0 :
	 * parameter :
	 *     icon_arc : IconArc_list * (pointer to an arc)
	 * return :
	 *     t_pitchcoord (y coordinate of up/left corner of englobing rectangle)
	 */
#define ICONARC_Y0(icon_arc) ((icon_arc)->y)
    /*
	 * ICONARC_X1 :
	 * parameter :
	 * 	icon_arc : IconArc_list * (pointer to an arc)
	 * return :
	 *     t_pitchcoord (x coordinate of bottom/right corner of englobing rectangle)
	 */
#define ICONARC_X1(icon_arc) (ICONARC_X0(icon_arc) + ICONARC_WIDTH(icon_arc))
    /*
	 * ICONARC_Y1 :
	 * parameter :
	 *     icon_arc : IconArc_list * (pointer to an arc)
	 * return :
	 *     t_pitchcoord (y coordinate of bottom/right corner of englobing rectangle)
	 */
#define ICONARC_Y1(icon_arc) (ICONARC_Y0(icon_arc) + ICONARC_HEIGHT(icon_arc))

/*
 *  access to angles
 */
    /*
	 * ICONARC_ANGLE1 :
	 * parameter :
	 *     icon_arc : IconArc_list * (pointer to an arc)
	 * return :
	 *     int (starting angle of the arc in degree)
	 */
#define ICONARC_ANGLE1(icon_arc) ((icon_arc)->angle1)
    /*
	 * ICONARC_ANGLE2 :
	 * parameter :
	 *     icon_arc : IconArc_list * (pointer to an arc)
	 * return :
	 *     int (angle in degree (like a lenght) of the arc)
	 */
#define ICONARC_ANGLE2(icon_arc) ((icon_arc)->angle2)

#endif /*__ICONACCESS_H__*/
