/**************************************************************************/
/*                                                                        */
/* QUOTES.CMD     Example program to demonstrate the use of WarpNote in   */
/*                connection with WarpNote Command. This program randomly */
/*                selects a quote from the file QUOTES.TXT and displays   */
/*                it in a note window.                                    */
/*                This program could be run in your Startup folder. You   */
/*                may and you should customize this program for your own  */
/*                needs.                                                  */
/*                                                                        */
/* Created on November 11th, 1997, Uwe Schlenther,70193 Stuttgart,Germany */
/**************************************************************************/

NoteNumber=102     /* This is the number of the note we will create. Make */
                   /* sure that you don't use this number for your own    */
                   /* needs and change it if necessary.                   */

InFile="QUOTES.TXT"       /* This is the file containing the quotes text. */

OutFile="NEWNOTE"

"del "OutFile

"wncomm wait"                               /* Wait for WarpNote startup. */
"wncomm delete "NoteNumber     /* Delete a previous instance of the note. */

call LINEOUT OutFile,"Quote of the Day",1
call LINEOUT OutFile,"================"
call LINEOUT OutFile,""

/* Count available quotes.                                                */

NumQuotes=1
LINEIN(InFile,1,0)

do while LINES(InFile)
  Line=LINEIN(InFile)
  if Line="" then NumQuotes=NumQuotes+1
end

/* Select a quote.                                                        */

QuoteNumber=RANDOM(NumQuotes-1)

LINEIN(InFile,1,0)

/* Find the selected quote.                                              */

do while QuoteNumber>0
  Line=LINEIN(InFile)
  if Line="" then QuoteNumber=QuoteNumber-1
end

/* Write the quote to a file.                                            */

do until Line=""
  Line=LINEIN(InFile)
  if Line<>"" then call LINEOUT OutFile,Line
end

/* Now create a note and paste the note text.                            */


"wncomm getdesktopx"                  /* Get horizontal desktop size. */
DesktopX=rc
"wncomm getdesktopy"                    /* Get vertical desktop size. */
DesktopY=rc
"wncomm create "NoteNumber                        /* Create the note. */
"wncomm setsizexy "NoteNumber DesktopX%2 DesktopY%4
"wncomm center "NoteNumber
"wncomm load "NoteNumber" newnote"
"wncomm show "NoteNumber

exit
