.*******************************************************************************
.* QuickMotion Information (English)
.*******************************************************************************

.*******************************************************************************
.* Symbol definitions
.*******************************************************************************
.nameit symbol=whatIs text='What is QuickMotion?'
.nameit symbol=install text='Installation'
.nameit symbol=usage text='Usage'
.nameit symbol=movies text='Movie Notes'
.nameit symbol=limits text='Known Limitations'
.nameit symbol=tips text='Performance Tips'
.nameit symbol=support text='Support'
.nameit symbol=license text='License'
.nameit symbol=acks text='Acknowledgements'

.*******************************************************************************
.* Table of contents entries
.*   These panels work with forward/back.  All of them launch the improved
.*   table of contents.
.*******************************************************************************
:h1 id=english rules=border scroll=none titlebar=none clear.English

:link reftype=hd refid=contents auto split.
:link reftype=hd refid=cover auto split.

.*------------------------------------------------------------------------------
:h2 id=whatIs rules=border scroll=none titlebar=none clear.&whatIs.

:link reftype=hd refid=contents auto split.
:link reftype=hd res=04401 auto split.

.*------------------------------------------------------------------------------
:h2 id=install rules=border scroll=none titlebar=none clear.&install.

:link reftype=hd refid=contents auto split.
:link reftype=hd res=04403 auto split.

.*------------------------------------------------------------------------------
:h2 id=usage rules=border scroll=none titlebar=none clear.&usage.

:link reftype=hd refid=contents auto split.
:link reftype=hd res=04404 auto split.

.*------------------------------------------------------------------------------
:h2 id=movies rules=border scroll=none titlebar=none clear.&movies.

:link reftype=hd refid=contents auto split.
:link reftype=hd res=04407 auto split.

.*------------------------------------------------------------------------------
:h2 id=limits rules=border scroll=none titlebar=none clear.&limits.

:link reftype=hd refid=contents auto split.
:link reftype=hd res=04406 auto split.

.*------------------------------------------------------------------------------
:h2 id=tips rules=border scroll=none titlebar=none clear.&tips.

:link reftype=hd refid=contents auto split.
:link reftype=hd res=04408 auto split.

.*------------------------------------------------------------------------------
:h2 id=support rules=border scroll=none titlebar=none clear.&support.

:link reftype=hd refid=contents auto split.
:link reftype=hd res=04409 auto split.

.*------------------------------------------------------------------------------
:h2 id=license rules=border scroll=none titlebar=none clear.&license.

:link reftype=hd refid=contents auto split.
:link reftype=hd res=04405 auto split.

.*------------------------------------------------------------------------------
:h2 id=acks rules=border scroll=none titlebar=none clear.&acks.

:link reftype=hd refid=contents auto split.
:link reftype=hd res=04402 auto split.

.*------------------------------------------------------------------------------
:h2 res=04401 hide rules=border group=2 x=25% y=0% width=75% height=100% titlebar=yes.&whatIs.
:p.
:font facename=Helv size=28x18.
&whatIs.
:font facename=default size=0x0.
:p.
Using the power of OS/2 Multimedia, QuickMotion brings native
playback of QuickTime movie files, popular on the world wide web,
to your OS/2 desktop.
:p.
With QuickMotion, your existing movie player applications
can instantly play QuickTime movies.  QuickMotion also
allows future movie players, such as IBM's Multimedia OpenDoc components and custom
applications, to play QuickTime movies.
:p.
QuickTime movie files usually have names that end with :link reftype=fn refid=mov..mov:elink..

:fn id=mov.
:p.
Occasionally, QuickTime movie files have names ending with .qt instead of .mov.
:efn.
.*------------------------------------------------------------------------------
:h2 res=04403 hide rules=border group=2 x=25% y=0% width=75% height=100% titlebar=yes.&install.
:p.
:font facename=Helv size=28x18.
&install.
:font facename=default size=0x0.
:p.
To install QuickMotion:
:ol.
:li.
Run Multimedia Application Install, which is
located in your multimedia folder.  If you do not have a multimedia
folder, you may need to use Selective Install to install OS/2 Multimedia.
:li.Once inside the Multimedia Application Install program, use the controls to
change the source directory to the
directory containing the QuickMotion files.  A QuickMotion icon
should appear, selected for installation by default.
:li.
Click Install.
:eol.
:p.
Alternatively, from a command prompt, change to the directory containing the
QuickMotion files, run MINSTALL.EXE, and proceed from step 2, above.

.*------------------------------------------------------------------------------
:h2 res=04404 hide rules=border group=2 x=25% y=0% width=75% height=100% titlebar=yes.&usage.
:p.
:font facename=Helv size=28x18.
&usage.
:font facename=default size=0x0.
:p.
To use QuickMotion, simply run your favorite movie OS/2 Multimedia movie player application
and open a QuickTime movie.  OS/2 Warp has three movie player applications to choose from:
:ul.
:li.
:link reftype=launch object='MPPM.EXE'.MPPM.EXE:elink. is run by the Digital Video icon in
your multimedia folder.  The QuickMotion icon in your QuickMotion folder also runs MPPM.EXE.
:li.
:link reftype=launch object='VB.EXE'.VB.EXE:elink. is part of the Multimedia Viewer in the
Warp Bonus Pack.
:li.
:link reftype=launch object='SWVR.EXE'.SWVR.EXE:elink. is part of the Video IN product in the
Warp Bonus Pack.
:eul.
:p.
When you choose Open... in these applications, they may list only *.AVI files.  Remove
the *.AVI selection in order to list all files, including QuickTime movies.
:p.
You will probably want to watch QuickTime movies that you download from the world wide web.
There are a few things you should know about this:
:ul.
:li.
:link reftype=launch object='EXPLORE.EXE'.Web Explorer:elink. is set to use VB to view
QuickTime movies.  This has never worked because, before QuickMotion came along, OS/2 Multimedia
could not play QuickTime files.  The good news is that QuickMotion actually makes this work.
However, VB does not allow you to save downloaded movies.  A workaround is to turn on "Save
to Disk Mode" before clicking on a movie link.  
:li.
We recommend using MPPM or SWVR, rather than VB. SWVR has a Save As... feature that
allows you to save downloaded movies.  If you do not have a video capture card, SWVR will
display a message, which you can ignore.
:eul.

.*------------------------------------------------------------------------------
:h2 res=04407 hide rules=border group=2 x=25% y=0% width=75% height=100% titlebar=yes.&movies.
:p.
:font facename=Helv size=28x18.
&movies.
:font facename=default size=0x0.
:p.
Your QuickMotion CD-ROM features movies from the Quantum Leap :hp5.QuickTime Test Kit:ehp5.
in the MOVIES directory.
:p.
You can see how your hardware stacks up by using SWVR (see :link reftype=hd res=04404
split.&usage.:elink.) to play the movies in MOVIES/TESTCLPS, and watching the dropped
frame percentage.  Some of these movies have very high data rates (by early-1996 standards).
This means that they will push your disk, video, and
processor to the limit.  The movie
:xmp.
    640_30.MOV
:exmp.
:p.
is 640x480, 30 frames/second, full-color compressed video.  Even though it has no sound, it has a
maximum data rate of over 2400K/second.  Our 32MB Pentium 90 with HPFS, SCSI and VRAM video
drops 75% of the frames in this movie.  Drop us a note (see :link reftype=hd res=04409
split.&support.:elink.) to tell us how your system compares!
:p.
Check out Quantum Leap at
:link reftype=launch object='EXPLORE.EXE' data='http://www.quantumleap.net'.http&colon.//www.quantumleap.net:elink.

.*------------------------------------------------------------------------------
:h2 res=04406 hide rules=border group=2 x=25% y=0% width=75% height=100% titlebar=yes.&limits.
:p.
:font facename=Helv size=28x18.
&limits.
:font facename=default size=0x0.
:p.
Some aspects of the QuickTime architecture are not supported by
OS/2 Multimedia, and therefore are not currently supported by
QuickMotion.  Also, some of the features added in later versions
of QuickTime are not yet supported by QuickMotion.  These are:
:ul.
:li.Recording.  At this time,  QuickMotion is playback-only.
:li.Changing frame rate.  QuickMotion plays QuickTime movies at
the average frame rate for the movie.
:li.MIDI.  QuickMotion does not recognize MIDI tracks.
:li.More than 2 tracks.  QuickMotion requires a video track, and
currently supports at most one sound track.
:li.Edits.  QuickMotion plays the entire media contained in a track.
:li.Multiple decompression methods.  QuickMotion supports one video
and one audio decompression method per track.
:li.Virtual reality.
:eul.
:p.
Movies which use these features of QuickTime are relatively
rare.  We are working on these and other features for future versions
of QuickMotion.  Watch our web site for the latest information.


.*--------------------------------------------------------------------------
:h2 res=04408 hide rules=border group=2 x=25% y=0% width=75% height=100% titlebar=yes.&tips.
:p.
:font facename=Helv size=28x18.
&tips.
:font facename=default size=0x0.
:p.
If you are experiencing jerky video or interrupted sound:
:p.
:lm margin=5.
Reducing the size of your soundcard's buffer may produce a
dramatic improvement.  For soundblasters, try using
:xmp.
    /B&colon.2 or /B&colon.1
:exmp.
:p.
on the
:xmp.
    DEVICE=...\SBxxxxxx.SYS
:exmp.
:p.
statement in your CONFIG.SYS, where "..." is your
multimedia directory and xxxxxx depends on the particular
soundblaster model.  Smaller soundcard buffers are better for multitasking
because the sound playback won't interfere with reading and displaying the
movie.
:p.
If you have more than 8MB of memory, you might also want to tune the multimedia
subsystem to take advantage of it.  Try adding the following to your CONFIG.SYS:
:lm margin=1.
:xmp.
    SET MMBUF=49152
    REM This increases the size of the read buffer.  The default is 32768.
    REM It can be set even higher, but movies will take longer to load.

    SET MMSTREAM=/H&colon.256
    REM This increases the heap space for the stream manager to 256K, which
    REM allows more movies to be open at once and may improve performance.
    REM The default is 64K, and 256K is the maximum.
:exmp.
:p.
If you are experiencing dropped frames, you may be able to improve the performance of your video
display subsystem by moving the video aperture.  Try adding one of the following lines to your
CONFIG.SYS (select the line appropriate for your system):
:xmp.
    SET VIDEO_APERTURE=A00
    REM Video optimization for PCI bus system

    SET VIDEO_APERTURE=78
    REM Video optimization for VL bus system

    SET VIDEO_APERTURE=3C
    REM Video optimization for EISA bus system

    SET VIDEO_APERTURE=E
    REM Video optimization for ISA-Bus System (RAM + VRAM must be <= 16MB)
:exmp.

.*------------------------------------------------------------------------------
:h2 res=04409 hide rules=border group=2 x=25% y=0% width=75% height=100% titlebar=yes.&support.
:p.
:font facename=Helv size=28x18.
&support.
:font facename=default size=0x0.
:p.
In the United States, contact:
:lines.
  Practice Corporation
  1030 E. El Camino Real #513
  Sunnyvale, CA  94087
  USA

  email&colon. :link reftype=launch object='EXPLORE.EXE' data='mailto:quickmo@practice.xo.com'.quickmo@practice.xo.com:elink.
  WWW&colon. :link reftype=launch object='EXPLORE.EXE' data='http://www.practice.xo.com'.http&colon.//www.practice.xo.com:elink.
  FAX: 510-742-1734
:elines.
:p.
In Europe, contact:
:lines.
  Portele Systemsoftware
  Andreas Portele
  Plattenweg 11
  64823 Gross-Umstadt
  Germany

  email&colon. :link reftype=launch object='EXPLORE.EXE' data='mailto:portele@rbg.informatik.th-darmstadt.de'.portele@rbg.informatik.th-darmstadt.de:elink.
  WWW&colon. :link reftype=launch object='EXPLORE.EXE' data='http://www.student.informatik.th-darmstadt.de/~portele'.http&colon.//www.student.informatik.th-darmstadt.de/~portele:elink.
  FAX: ++49-6078-911028
  FIDO&colon. 2&colon.2464/6.27
:elines.

.*------------------------------------------------------------------------------
:h2 res=04405 hide rules=border group=2 x=25% y=0% width=75% height=100% titlebar=yes.&license.
:p.
:font facename=Helv size=28x18.
&license.
:font facename=default size=0x0.
:p.
:lines.
Your use of QuickMotion for OS/2 is governed by the following terms.
By installing QuickMotion for OS/2, you agree to these terms.

       Practice Corporation grants you a license to use the Program
       only in the country where you acquired it. The Program is
       copyrighted and licensed (not sold). We do not transfer title
       to the Program to you. You obtain no rights other than those
       granted you under this license.

       Under this license, you may:

       1. use the Program on one machine at a time;
       2. make copies of the Program for backup purposes;

       You may NOT:

       1. sublicense, rent, lease, or assign the Program;
       2. reverse assemble, reverse compile, or otherwise translate the
          Program.

       We do not warrant that the Program is free from claims by a third
       party of copyright, patent, trademark, trade secret, or any other
       intellectual property infringement.

       Under no circumstances are we liable for any of the following:

       1. third-party claims against you for losses or damages;
       2. loss of, or damage to, your records or data; or
       3. economic consequential damages (including lost profits or
          savings) or incidental damages, even if we are informed of
          their possibility.

       Some jurisdictions do not allow these limitations or exclusions,
       so they may not apply to you.

       We do not warrant uninterrupted or error free operation of the
       Program. We have no obligation to provide service, defect
       correction, or any maintenance for the Program. We have no
       obligation to supply any Program updates or enhancements to you
       even if such are or later become available.

       THERE ARE NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING THE
       IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
       PARTICULAR PURPOSE.

       Some jurisdictions do not allow the exclusion of implied
       warranties, so the above exclusion may not apply to you.

       You may not sell, transfer, assign, or subcontract any of your
       rights or obligations under this license. Any attempt to do so is
       void.

       Neither of us may bring a legal action more than two years after
       the cause of action arose.

       If you acquired the Program in the United States, this license is
       governed by the laws of the State of California.  Otherwise, this
       license is governed by the laws of the country in which you
       acquired the Program.

       6/96
:elines.

.*------------------------------------------------------------------------------
:h2 res=04402 hide rules=border group=2 x=25% y=0% width=75% height=100% titlebar=yes.&acks.
:p.
:font facename=Helv size=28x18.
&acks.
:font facename=default size=0x0.
:p.
OS/2 is a registered trademark of IBM, Inc.
:p.
QuickTime is a registered trademark of Apple Computer, Inc.
:p.
QuickMotion for OS/2 is based in part on the work of the Independent
JPEG Group, version 6.
:p.
Our sincerest thanks to Nigel Clarke, Darryl Sperber, and Gail Zimmerman for going out of
their way to help bring QuickMotion to you.

.*******************************************************************************
.* Improved Table of Contents
.*******************************************************************************
:h2 id=contents group=1 hide nosearch noprint scroll=vertical rules=border titlebar=yes x=0% y=0%
width=25% height=100%.Contents
:p.
:artwork align=left name='quickmo.bmp'.
:artlink.
:link reftype=hd refid=cover split.
:eartlink.
&rahead.:link reftype=hd res=04401 split.&whatIs.:elink.

:p.
:artwork align=left name='install.bmp'.
&rahead.:link reftype=hd res=04403 split.&install.:elink.

:p.
:artwork align=left name='info2.bmp'.
&rahead.:link reftype=hd res=04404 split.&usage.:elink.
.br
&rahead.:link reftype=hd res=04407 split.&movies.:elink.
.br
&rahead.:link reftype=hd res=04406 split.&limits.:elink.
.br
&rahead.:link reftype=hd res=04408 split.&tips.:elink.
.br
&rahead.:link reftype=hd res=04409 split.&support.:elink.
.br
&rahead.:link reftype=hd res=04405 split.&license.:elink.
.br
&rahead.:link reftype=hd res=04402 split.&acks.:elink.
