/*
** WORKLab, Krebber
** create LogoArt Folder and Data-Objects on Desktop
*/

hyellow  ='[1;33m[1A'
hwhite   ='[1;37m[1A'
nline    = "0D0A"x                                        /* new line */

call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs

parse arg version wait

if version = "" then version = "V1.1X";

folder_id="<FLDR_LOGOART_"||version||">";
clipart_id="<FLDR_CLIPART_"||version||">";
kvec_id="<FLDR_KVEC_"||version||">";
workshop_id="<FLDR_WORKSHOP_"||version||">";
program_id="<LOGOART_"||version||">";
readme_id="<README_"||version||">";
license_id="<LICENSE_"||version||">";
register_id="<REGISTER_"||version||">";

say nline "Starting with LogoArt folder generation V."||version
say "All previous objects of this same version will be replaced"

if wait \= "" then do
   say "Press Enter to continue.."
   pull
end

say "creating folders"
call create_folders 

if result>0 then do
   say "creating program object"
   call create_program
end

say "--------- Done with LogoArt folder generation. ---------"
exit;

/*
** create folders
*/
create_folders:

clipart_path = directory()||"\CLIPART"
kvec_path = directory()||"\KVEC"
workshop_path = directory()||"\WORKSHOP"

   parse arg path

   /* create data type in os2.ini */
   call SysIni 'USER', 'PMWP_ASSOC_TYPE', 'LogoArt', ''

   /* create main folder (replace if exists) */
   rc = SysCreateObject(WPFolder, "LogoArt", "<WP_DESKTOP>", "TREEVIEW=LINES,MINI;OBJECTID="||folder_id, "R");

   /* and shadow to clipart directory (folder and subfolders will be automatically created) */
   rc = SysCreateObject("WPShadow", "Clipart", folder_id, "SHADOWID="||clipart_path||";"||dataicon||"ASSOCTYPE=LogoArt;OBJECTID="||clipart_id, "R");

   /* and shadow to clipart directory (folder and subfolders will be automatically created) */
   rc = SysCreateObject("WPShadow", "Vectorizer", folder_id, "SHADOWID="||kvec_path||";"||dataicon||"ASSOCTYPE=LogoArt;OBJECTID="||kvec_id, "R");

   /* and shadow to clipart directory (folder and subfolders will be automatically created) */
   rc = SysCreateObject("WPShadow", "Workshop", folder_id, "SHADOWID="||workshop_path||";"||dataicon||"ASSOCTYPE=LogoArt;OBJECTID="||workshop_id, "R");

return rc;

/*
** create program object
*/

create_program:
/* assuming all executables are on current directory .. */
title = "LogoArt "||version
name= "EXENAME="||directory()||"\Logoart.exe;"
icon= "ICONFILE="||directory()||"\LogoArt.ico;"
defdir="STARTUPDIR="||directory()||";"
assoc="ASSOCTYPE=LogoArt;ASSOCFILTER=*.art;"

vals = "PROGTYPE=PM;"||name||icon||defdir||assoc||"OBJECTID="||program_id;
rc = SysCreateObject(WPProgram, title, folder_id, vals, "R");

shadow_path= directory()||"\read.me"
   rc = SysCreateObject("WPShadow", "read.me", folder_id, "SHADOWID="||shadow_path||";"||dataicon||"OBJECTID="||readme_id, "R");

shadow_path= directory()||"\license.txt"
   rc = SysCreateObject("WPShadow", "license.txt", folder_id, "SHADOWID="||shadow_path||";"||dataicon||"OBJECTID="||license_id, "R");

shadow_path= directory()||"\register"
   rc = SysCreateObject("WPShadow", "license.txt", folder_id, "SHADOWID="||shadow_path||";"||dataicon||"OBJECTID="||register_id, "R");

return rc;


