/*===========================================================================*/
#ifndef _GLOBJECTS_INC
   #define _GLOBJECTS_INC

   #include <math.h>
   #include <GL/gl.h>
   #include "glMathUtils.h"
   /*========================================================================*/
   /* Magic defines.                                                         */
   /*========================================================================*/
   #ifndef TEXTURE_ON
      #define  TEXTURE_ON        0x010
   #endif
   #ifndef ALL
      #define  ALL               0x001
   #endif
   #ifndef TOP
      #define  TOP               0x002
   #endif
   #ifndef BOTTOM
      #define  BOTTOM            0x004
   #endif
   #ifndef SIDES
      #define  SIDES             0x008
   #endif
   #ifndef INSIDE
      #define  INSIDE            0x020
   #endif
   #ifndef OUTSIDE
      #define  OUTSIDE           0x040
   #endif
   #ifndef AXIS_ON              
      #define AXIS_ON            0x080
   #endif
   #ifndef GRID_ON             
      #define GRID_ON            0x100
   #endif

   #define  NUM_CYLINDER_FACES   16
   #define  NUM_CONE_FACES       16
   #define  STACKS               20
   #define  SLICES               20
   /*========================================================================*/
   /* Function prototyping.                                                  */
   /*========================================================================*/
   void  glObjCube( float width, float height, float depth, int parts );
   void  glObjCylinder( float radius, float height, int parts );
   void  glObjCone( float radius, float height, int parts );
   void  glObjSphere( float radius, int parts );
   void  glObjGrids( float gridSize, float gridGap, float radius, int flags );
   void  glObjSetLight( int lightNumber, int show, int positional, float x, float y, float z );

#endif
/*===========================================================================*/
