/*
 What's it called: ESMP3.C

 What does it do : Sample program that demonstrates how to imbed an E-MLE
                   into a dialog box.

 .DLL functions  : EditWndRegisterWnd()

 Who and When    : Gennaro (Jerry) Cuomo                          2 -89
                   John Ponzo (Modified for E toolkit 5.60 + 6.00)
*/

/*ͻ
 Included Header Files:                                             GC 9-88 
*/
#define INCL_WIN         // WIN functions and WM_ msgs
#define INCL_DOS         // DOS functions
#include <os2.h>         //
#include <stdio.h>       // C library functions...
#include <string.h>
#include <malloc.h>      // C library functions...

#include "esmp3.h"     // Constants.
#include <edll.h>        // E Toolkit header file

#if OS2VERSION < 20
   #define MSG USHORT
#else
   #define MSG ULONG
#endif

/*ͻ
 The following are Global   variables.                              GC 9-88 
*/
HWND       hwndQ1;                // E-MLE 1
HWND       hwndQ2;                // E-MLE 2

MRESULT EXPENTRY SubclassedEditWndProc(HWND hwnd, MSG msg, MPARAM mp1, MPARAM mp2);

PFNWP   EditWndDefWndProc;
#define NEWEMLECLASS "NEWEMLECLASS"
BOOL    EMLESubclassed = 0;

/*Ŀ
                                                                            
 What's it called:  SampleDlgProc                                           
                                                                            
 What does it do :  Drives a dialog box that contains 2 multi-line edit     
                    controls from the E toolkit.                            
                                                                            
 Who and when    :  Gennaro A. Cuomo                               10-88    
                                                                            
*/
VOID FormatDialog( HWND hDlg )
{
  HWND  hStatRect1, hStatRect2;

  // Get the window handle of the 2 STATIC rectangle controls
  hStatRect1   = WinWindowFromID( hDlg, IDD_RECT1);
  hStatRect2   = WinWindowFromID( hDlg, IDD_RECT2);

  if (hStatRect1 && hStatRect2) {
     SWP  swpr1, swpr2;
     ERRORID ErrorID;

     // Make the E-MLE  children of the Dialog box
     WinSetParent(hwndQ1, hDlg, FALSE);
     ErrorID = WinGetLastError(WinQueryAnchorBlock(hDlg));
     WinSetParent(hwndQ2, hDlg, FALSE);
     ErrorID = WinGetLastError(WinQueryAnchorBlock(hDlg));

     // Get the position of the 2 STATIC rectangle controls
     WinQueryWindowPos( hStatRect1, &swpr1 );
     WinQueryWindowPos( hStatRect2, &swpr2 );

     // Move the 2 E-MLE's on top of the STATIC rectangle controls
     WinSetWindowPos(hwndQ1, swpr1.hwndInsertBehind, (SHORT)swpr1.x ,(SHORT)swpr1.y ,(SHORT)swpr1.cx, (SHORT)swpr1.cy ,SWP_MOVE | SWP_SIZE | SWP_ACTIVATE | SWP_ZORDER | SWP_NOADJUST | SWP_SHOW);
     WinSetWindowPos(hwndQ2, swpr2.hwndInsertBehind, (SHORT)swpr2.x ,(SHORT)swpr2.y ,(SHORT)swpr2.cx, (SHORT)swpr2.cy ,SWP_MOVE | SWP_SIZE | SWP_ACTIVATE | SWP_ZORDER | SWP_NOADJUST | SWP_SHOW);

  } /* endif*/
}

MRESULT EXPENTRY SampDlgProc ( HWND hDlg, MSG msg, MPARAM mp1, MPARAM mp2 )
{

  switch ( msg )  {
       /*Ŀ
       Initialize dialog box by positioning the edit windows in  
       the dialog box and re-assigning ownership of the edit     
       window to the dialog box.  This will make it easier to    
       control the edit windows from the dialog proc.            
       */
  case WM_INITDLG:
       FormatDialog(hDlg);
       return((MRESULT)0);

  case WM_FORMATFRAME:
  case WM_SIZE:
       {  MRESULT rc;
          rc=WinDefDlgProc( hDlg, msg, mp1, mp2);
          FormatDialog( hDlg );
          return(rc);
       }
       break;

  case WM_COMMAND:
       if ( LOUSHORT( mp1 )==DID_OK || LOUSHORT( mp1 )==DID_CANCEL )  {

          // make them E-MLEs children of the desktop, because we are about to
          // destroy the dialog box
          WinSetParent(hwndQ1, HWND_DESKTOP, FALSE);
          WinSetParent(hwndQ2, HWND_DESKTOP, FALSE);

          if (LOUSHORT(mp1)==DID_OK) {
             /* save data in the E-MLE windows */
             WinSendMsg( hwndQ1, EPM_EDIT_COMMAND, (PSZ)"SAVE", 0L );
             WinSendMsg( hwndQ2, EPM_EDIT_COMMAND, (PSZ)"SAVE", 0L );
          } /* endif */

          /* hide the MLE windows */
          WinShowWindow( hwndQ1, FALSE );
          WinShowWindow( hwndQ2, FALSE );

          /* destroy the dialog */
          WinShowWindow( hDlg, FALSE );
          WinDismissDlg( hDlg,TRUE);
       } else {
          return( (MRESULT)WinDefDlgProc( hDlg, msg, mp1, mp2 ) );
       }
       break;

  default:
      return( (MRESULT)WinDefDlgProc( hDlg, msg, mp1, mp2 ) );
  }
  return( 0L );
}
/*Ŀ
                                                                            
 What's it called: TestWndProc()                                            
                                                                            
 What does it do :                                                          
                                                                            
                                                                            
                                                                            
 Who and when    : Gennaro (Jerry) Cuomo   9-88                             
                                                                            
*/
MRESULT EXPENTRY TestWndProc( HWND hwnd, MSG msg, MPARAM mp1, MPARAM mp2 )
{
    switch (msg)   {
         /*Ŀ
           This message is received when CLOSE is selected on the system     
           menu of the Test Edit Application window.  When this is received, 
           Send a destroy message to the Edit Windows.                       
         */
    case WM_CLOSE:
         WinSendMsg( hwndQ1, EPM_EDIT_CLOSE, (MPARAM)1, (MPARAM)0);
         WinSendMsg( hwndQ2, EPM_EDIT_CLOSE, (MPARAM)1, (MPARAM)0);

         WinPostMsg( hwnd,              /* Edit Window was destroyed... */
                     WM_QUIT,           /* Now, quit application by     */
                     0L,                /* posting a quit message...    */
                     0L
                   );
         break;

         /*Ŀ
           Application window has become invalid...                        
           or window has changed size...                                   
         */
    case WM_PAINT:
    case WM_SIZE:
         {
           HPS    hPS;      /* local handle to a cashed micro PS */
           hPS = WinBeginPaint( hwnd, (HPS)NULL, (PWRECT)NULL );
           GpiErase( hPS );
           WinEndPaint( hPS );
         }
         break;

    case WM_COMMAND:
         if (SHORT1FROMMP(mp1)==IDD_CMD) {
           /* display dialog box */
           WinDlgBox(HWND_DESKTOP, hwnd, (PFNWP)SampDlgProc,(HMODULE) 0, DLG_SAMP, (PCH)NULL);
         }
         break;

    default:
        return( WinDefWindowProc( hwnd, msg, mp1, mp2 ) );
        break;
    }
    return(0L);
}

//+------------------------------------------------------------------------------+
//|                                                                              |
//|  What's it called: CreateEditWindow                                          |
//|                                                                              |
//|  What does it do : Create an E-MLE window using the ETKExxx.DLL function     |
//|                    EtkCreate.    Note that key events are defined            |
//|                    by the ESIMPLE.EX  macro file. (See ESIMPLE.EX for deta   |
//|                                                                              |
//|  Who and when    : Gennaro (Jerry) Cuomo   9-88                              |
//|                    John Ponzo              3-93                              |
//+------------------------------------------------------------------------------+
HWND CreateEditWindow(HWND hwnd, PSZ Fname, PSZ EditWndClass, USHORT WindowID)
{
   EDITORINFO epm;               // Editor Application Information Struct
   SWP   swp;                    // E-MLE position
   HWND  hwndEdit;               // E-MLE (client) handle

#if 0
   // allow for Line/Column at the bottom of application window
   WinQueryWindowPos(hwnd, &swp);
   swp.cy -=30; swp.y +=20;
#endif

   memset(&epm, 0, sizeof(EDITORINFO));

   // fill in the editor information structure
   epm.FileName    = (PSZ)Fname;            // file to be edited (with wildcard)
   epm.EditorStyle = EDIT_STYLE_CURSORON |
                     EDIT_STYLE_ACTIVATEFOCUS |
                     EDIT_STYLE_COMMANDMSGTOMACROS  |
                     EDIT_STYLE_DISPLAYERRORRETRY;
   epm.ExFile      = (PSZ)"ESMP3.EX";     // Pre-compiled macro code file.
   epm.TopMkr      =                        // top and bottom file indicator
   epm.BotMkr      = (PSZ)"";
   epm.ExePath     = ".";
   epm.Size        = sizeof(EDITORINFO);

   /*----------  Create E-MLE Window -----------*/
   hwndEdit = WinCreateWindow(hwnd,
                   EditWndClass,
                   (PSZ)0,
                   0,
                   0, 0, 0, 0, //swp.x, swp.y, swp.cx, swp.cy,
                   hwnd,
                   HWND_TOP,
                   WindowID,
                   &epm,
                   (PVOID)0);
   // See error handling in ESMP1.C if hwndEdit is NULL.

   return( (HWND)hwndEdit );
}

/*Ŀ
                                                                            
 What's it called: main()                                                   
                                                                            
 What does it do : creates a application window and creates a child edit    
                   window that contains file(s) specified on the system     
                   command line.                                            
                                                                            
 Who and when    : Gennaro (Jerry) Cuomo   9-88                             
                                                                            
*/
void main( )
{
    HAB   hab;
    HMQ   hmq;
    QMSG  qmsg;                             /* queue message structure      */
    ULONG pmstyle;                          /* application window style     */
    RECTL rect;                             /* rectangle structure for pos. */
    HWND  hwndAppClient, hwndAppFrame;

    hab = WinInitialize(0);              /* Initialize app as a PM app   */

    hmq = WinCreateMsgQueue(hab,0x100);      /* Create Queue                 */

    WinRegisterClass( hab,                  /* Register Application window  */
                      (PSZ)"TEST",          /*...class name                 */
                      (PFNWP)TestWndProc,   /*...application window proc    */
                      CS_SIZEREDRAW,        /*...window class style         */
                      0 );                  /*...no window data             */

    pmstyle = FCF_SIZEBORDER | // window style of application
              FCF_TITLEBAR   |
              FCF_MINMAX     |
              FCF_SYSMENU    |
              FCF_MENU;

    hwndAppFrame =WinCreateStdWindow(       /* Create application window    */
                     HWND_DESKTOP,          /*...parent is the desk top wnd */
                     0L,
                     &pmstyle,              /*...window style flags         */
                     (PSZ)"TEST",           /*...window class name          */
                     (PSZ)"Sample of an E-MLE in a Dialog Box",
                     0L,                    /*...                           */
                     (HMODULE)NULL,         /*...                           */
                     EDIALOG_RC,            /*...                           */
                     (PHWND)&hwndAppClient  /*...(return) client wnd handle */
                     );

    rect.xLeft   =  10;                     /* Position Application Window  */
    rect.yBottom =  10;
    rect.xRight  =  500;
    rect.yTop    =  400;

    WinSetWindowPos ((HWND)hwndAppFrame,   /* Set position of app window  */
                     (HWND)HWND_TOP,
                     (SHORT)rect.xLeft,
                     (SHORT)rect.yBottom,
                     (SHORT)rect.xRight,
                     (SHORT)rect.yTop,
                     SWP_MOVE | SWP_SIZE | SWP_SHOW);

   //--- Statically subclass the EMLE control --------
   if(!EMLESubclassed) {
     ULONG     flStyle;
     USHORT    cbData;
     CLASSINFO OriginalClass;
     PSZ       EMLEClass;

     EMLEClass   = EtkRegisterEMLEClass(hab);

     WinQueryClassInfo(hab, EMLEClass,  &OriginalClass);

     EditWndDefWndProc = OriginalClass.pfnWindowProc;

     flStyle  = OriginalClass.flClassStyle & ~CS_PUBLIC;
     cbData   = OriginalClass.cbWindowData ;

     WinRegisterClass(hab, NEWEMLECLASS, SubclassedEditWndProc, flStyle, cbData);

     EMLESubclassed = 1;
   }


   /*----------  Create Two Edit Windows   -------------*/
   hwndQ1=CreateEditWindow(hwndAppClient, "QUEST1.DOC", NEWEMLECLASS, 1001);
   hwndQ2=CreateEditWindow(hwndAppClient, "QUEST2.DOC", NEWEMLECLASS, 1002);

   WinShowWindow(hwndAppFrame, TRUE);

   /* dispatch messages to Test Application */
   while( WinGetMsg( hab, (PQMSG)&qmsg, (HWND)0, 0, 0 ) ) {
       WinDispatchMsg( hab, (PQMSG)&qmsg );
   }

   /* Close up shop  */

   WinDestroyWindow( hwndAppFrame );
   WinDestroyMsgQueue( hmq );
   WinTerminate( hab );
}

MRESULT EXPENTRY SubclassedEditWndProc(HWND hwnd, MSG msg, MPARAM mp1, MPARAM mp2)
{
   switch(msg) {
      case EPM_QUERYHINI:
           return((MRESULT)HINI_USERPROFILE);
   }

   return EditWndDefWndProc(hwnd, msg, mp1, mp2);
}
