{ --------------------------------------------------------------- }
{ Dieser Quelltext ist urheberrechtlich geschuetzt.               }
{ (c) 1991-1999 Peter Mandrella                                   }
{ (c) 2000-2001 OpenXP-Team                                       }
{ (c) 2002-2005 FreeXP, http://www.freexp.de                      }
{ CrossPoint ist eine eingetragene Marke von Peter Mandrella.     }
{                                                                 }
{ Die Nutzungsbedingungen fuer diesen Quelltext finden Sie in der }
{ Datei SLIZENZ.TXT oder auf www.crosspoint.de/oldlicense.html.   }
{ --------------------------------------------------------------- }
{ $Id: xpfiles.inc,v 1.6 2005/01/01 11:16:27 mw Exp $ }

{ Include fr UUZ.PAS und UUCICO.PAS }


{ fn:         Unix-Dateiname, evtl. incl. Pfad                   }
{ destdir<>'' -> Namenskollision in diesem Verzeichnis vermeiden }

function Unix2DOSfile(fn,destdir:pathstr):pathstr;
var p,i     : byte;
    allowed : set of char;
    name    : namestr;
    ext     : extstr;
    n       : word;
begin
  UpString(fn);
  p:=length(fn);
  while (fn[p]<>'/') and (p>0) do dec(p);
  if p>0 then delete(fn,1,p);
  if fn='~' then fn:='';
  if right(fn,6)='.TAR.Z' then            { .tar.z -> .taz }
    fn:=left(fn,length(fn)-5)+'TAZ';
  p:=cpos(':',fn);
  if (p>0) and (p<length(fn)) then        { device: entfernen }
    delete(fn,1,p);
  p:=length(fn);
  while (p>0) and (fn[p]<>'.') do dec(p);
  if p>1 then begin
    fn:=left(fn,p+3);           { Extension auf 3 Zeichen krzen }
    dec(p);
    end;
  allowed:=['A'..'Z','_','-','','','','','','','#','@','$','!','0'..'9'];
  for i:=1 to p do
    if not (fn[i] in allowed) then   { linken Teil nach DOS konvertieren }
      fn[i]:='-';
  allowed:=allowed+['.'];
  for i:=max(1,p) to length(fn) do   { Extension nach DOS konvertieren }
    if not (fn[i] in allowed) then
      fn[i]:='-';
  p:=cpos('.',fn);
  if p=0 then begin             { Datei ohne Extension auf 8 Zeichen krzen }
    name:=left(fn,8); ext:='';
    end
  else begin                    { Datei mit Extension auf 8+3 zeichen krzen }
    name:=left(fn,min(8,p-1)); ext:=mid(fn,p);
    end;
  if length(ext)=2 then n:=10
  else n:=1;
  while (destdir<>'') and (n<999) and exist(destdir+name+ext) do begin
    ext:=left(ext,4-length(strs(n)))+strs(n);   { '.' mitrechnen! }
    inc(n);
    end;
  Unix2DOSfile:=name+ext;
end;

function Unix2LFNfile(fn,destdir:pathstr):pathstr;
var p,i     : byte;
    allowed : set of char;
    name    : namestr;
    ext     : extstr;
    n       : word;
begin
  UpString(fn);
  p:=length(fn);
  while (fn[p]<>'/') and (p>0) do dec(p);
  if p>0 then delete(fn,1,p);
  if fn='~' then fn:='';
  if right(fn,6)='.TAR.Z' then            { .tar.z -> .taz }
    fn:=left(fn,length(fn)-5)+'TAZ';
  p:=cpos(':',fn);
  if (p>0) and (p<length(fn)) then        { device: entfernen }
    delete(fn,1,p);
  p:=length(fn);
  allowed:=['A'..'Z','_','-','','','','','','','#','@','$','!','0'..'9'];
  allowed:=allowed+['.'];
  for i:=1 to p do
    if not (fn[i] in allowed) then   { linken Teil nach DOS konvertieren }
      fn[i]:='-';
  n:=1;
  ext:='';
  while (destdir<>'') and (n<999) and exist(destdir+fn+ext) do begin
    ext:='.'+strs(n);
    inc(n);
    end;
  Unix2LFNfile:=fn+ext;
end;

{
  $Log: xpfiles.inc,v $
  Revision 1.6  2005/01/01 11:16:27  mw
  MW: - Willkommen im Jahr 2005

  Revision 1.5  2004/01/09 16:19:02  mw
  MW: - Wir haben jetzt 2004!!

  Revision 1.4  2003/07/30 23:09:51  my
  MY:- Source-Header auf "FreeXP" aktualisiert, einige Detailkorrekturen
       an CVS-Logs vorgenommen und hier und da CVS-Loginfos implementiert.

}
