{ --------------------------------------------------------------- }
{ Dieser Quelltext ist urheberrechtlich geschuetzt.               }
{ (c) 2003-2005      Martin Wodrich, http://www.martinwodrich.de  }
{                               software@martinwodrich.de         }
{                                                                 }
{ Dieser Quelltext ist Freeware.                                  }
{                                                                 }
{ Die allgemeinen Nutzungsbedingungen fuer diesen Quelltext       }
{ finden Sie in der Datei TOUCH.TXT oder auf                      }
{ http://www.martinwodrich.de/Software/Touch/nutzung.htm          }
{ --------------------------------------------------------------- }
{ $Id: touch.pas,v 1.22 2005/09/29 08:33:15 mw Exp $ }
program touch;
{$I TOUCH.INC }

{ Betriebsystemabhaeniges }
{$IFNDEF WINDOWS }
{$IFDEF VPOS2}
uses use32,dos,crt;
{$ELSE }
uses dos,crt{$IFDEF BPLFN},touchlfn{$ENDIF};
{$ENDIF }
{$ELSE }
uses windos,wincrt,strings;
{$ENDIF }

const anyfile=$21;
      {$IFNDEF DPMI}
      {$IFNDEF unix}
      beta='.2';  {Patchlevel 1}
      {$ELSE}
      !!! Touch 1.2 luft nicht auf unixartigen Betriebsystemen !!
      beta=' Alpha 6';
      {$ENDIF}
      {$ELSE}
      beta=' Alpha 6';
      {$ENDIF}
      version='1.2'+beta;
      touchname='Touch '+version;
      copyright=' (c) 2003-2004 by Martin Wodrich';

      { Betriebsystemstrings }
      {$IFDEF MSDOS}
        {$IFDEF BPLFN}
           pform = ' (DOS16,LFN)';
        {$ELSE}
           pform = ' (DOS16,NON LFN)';
        {$ENDIF}
      {$ENDIF}
      {$IFDEF DPMI}
      pform = ' (DPMI16)';
      {$ENDIF}
      {$IFDEF WINDOWS}
      pform = ' (WIN16)';
      {$ENDIF}
      {$IFDEF Dos32}
      pform = ' (DOS32)';
      {$ENDIF}
      {$IFDEF Win32}
      pform = ' (WIN32)';
      {$ENDIF}
      {$IFDEF Linux}
      pform = ' (Linux)';
      {$ENDIF}  
      {$IFDEF OS2}
        {$IFDEF BP}
        pform = ' (OS2,16 Bit)';
        {$ELSE}
        pform = ' (OS2,EMX)';
        {$ENDIF}
      {$ENDIF}   

      { Betriebsystemabhngiges }
      {$IFNDEF unix}
      OSDirSeparator = '\';
      Paramark = '/';
      CR='';    
      {$ELSE}
      OSDirSeparator = '/';
      Paramark = '-';
      CR=#13;       
      {$ENDIF}

type
 macrop = ^macro;
 macro = record
   text : string[79];
   next : macrop;
   end;

var f:file;
    g:text;
{$IFDEF WINDOWS }
   dt          : TDateTime;
   DirInfo     : TSearchRec;
   FName,own   : String[79];
   FNamep      : Array[0..79] of Char;
   Dir         : Array[0..67] of Char;
   Name        : Array[0..8] of Char;
   Ext         : Array[0..4] of Char;
   sp          : Array[0..255] of Char;
   reffile     : String[79];
   nc          : boolean;
{$ELSE }
   dt          : DateTime;
   DirInfo     : SearchRec;
   FName,own   : Pathstr;
   Dir         : DirStr;
   Name        : NameStr;
   Ext         : ExtStr;
   reffile     : PathStr;
{$ENDIF }
   i,t         : integer;
   h,mi,se,hund: Word;
   y,mo,d,dw   : Word;
   ftime       : Longint;
   ref         : boolean;
   s,u         : string[100];
   sim,zcout   : boolean;
   files       : byte;
   st,n        : macrop;
   dateSet,timeSet : boolean;
   findone,uc,nt : boolean;

{$IFNDEF WINDOWS}
function ownfile:Pathstr;
{$ELSE}
function ownfile:String;
{$ENDIF}
begin
  FName:=paramstr(0);
  {$IFDEF WINDOWS }
  StrPCopy(fnamep,fname);
  FileExpand(Dir,fnamep);
  StrCopy(Dir,fnamep);
  fname:=StrPas(fnamep);
  {$ELSE}
  fname:=FExpand(fname);
  {$ENDIF}
  ownfile:=fname;  
end;

procedure logo;
begin
  {$IFNDEF WINDOWS}
  writeln (touchname+pform+copyright+CR);
  writeln (''+CR);
  {$ELSE}
  StrCopy(WindowTitle,touchname+pform+copyright);
  {$ENDIF}
  own:=ownfile;
end;

procedure StandardIO;
begin
     assign( Input, '' );
     reset( Input );
     assign( Output, '' );
     rewrite( Output );
end;

procedure hilfe;
var i:char;
begin
    writeln ('Parameter fehlt'+CR);
    writeln (''+CR);
    writeln ('touch file1 file2 ... '+Paramark+'T=hh:mm:ss '+Paramark+'D=tt.mm.[yy]yy '+
              Paramark+'R=refdatei '+Paramark+'H '+Paramark+'S '+Paramark+'V '+
              Paramark+'G '+Paramark+'K'+CR);
    write ('                      ');
    {$IFDEF BPLFN}
    write(Paramark+'LFN ');
    {$ENDIF}
    {$IFDEF WINDOWS}
    write(Paramark+'NC ');
    {$ENDIF}
    writeln (Paramark+'J=Jobfile '+Paramark+'ZC '+Paramark+'I '+CR);
    writeln (''+CR);
    writeln ('Macros:'+CR);
    {$IFDEF BP}
    writeln (' #:             jedes Laufwerk'+CR);
    {$ENDIF}
    writeln (' '+OSDirSeparator+'#'+OSDirSeparator+
             '            jeder Verzeichnis einschliesslich gar keins'+CR);
    writeln (' '+OSDirSeparator+'##'+OSDirSeparator+
             '           und das ganze nochmals rekursiv'+CR);
    writeln (' #              Das aktuelle Verzeichnis und alle alle Dateien in direkten'+CR);
    writeln ('                Unterverzeichnissen touchen'+CR);
    writeln (' ##             Alle Dateien die im aktuellen Verzeichnis und rekursiv in'+CR);
    writeln ('                allen Unterverzeichnissen'+CR);
    {$IFDEF BP}
    writeln (' ###            alle verfuegbaren Dateien (Vorsicht: Auf eigene Gefahr!!!)'+CR);
    {$ENDIF}
    writeln (''+CR);
    writeln (' '+Paramark+'T=Zeitangabe  Zeit, auf das die Dateizeit gesetzt werden soll.'+CR);
    writeln (' '+Paramark+'D=Datum       Datum, auf das das Dateidatum gesetzt werden soll.'+CR);
    writeln (' '+Paramark+'R=reffile     Referenzdatei verwenden'+CR);
    writeln (' '+Paramark+'H             auch versteckte Dateien'+CR);
    writeln (' '+Paramark+'S             auch Systemdateien'+CR);
    writeln (' '+Paramark+'V             Vortaeuschmodus (Simulationslauf)'+CR);
    writeln (' '+Paramark+'G             Dateien in Grossbuchstaben wandeln'+CR);
    writeln (' '+Paramark+'K             (nur bei '+Paramark+'G wirksam) Dateidatum und Uhrzeit beibehalten'+CR);
    writeln ('Weiter mit beliebiger Taste'+CR);
    i:=Readkey;
    {$IFDEF BPLFN}
    writeln (' '+Paramark+'LFN           lange Dateinamen benutzen (Vorsicht: Nur bei Verwendung'+CR);
    writeln ('                eines Betriebsystems benutzen, das in seiner DOS-Emulation'+CR);
    writeln ('                lange Dateinamen unterstuetzt z.B. Windows ab 95'+CR);
    {$ENDIF}
    {$IFDEF WINDOWS}
    writeln (' '+Paramark+'NC            Konsolenfenster nicht schliessen'+CR);
    {$ENDIF}
    writeln (' '+Paramark+'J=Jobfile     Dateiliste verwenden, statt lange Argumentliste'+CR);
    writeln (' '+Paramark+'ZC            Neue Dateien als ZConnect-PUFFER erstellen'+CR);
    writeln (' '+Paramark+'I             Interaktiver Modus (Lesen der Dateiinfos von Standard-Input)'+CR);
end;

procedure isok(meldung:integer);
begin
 if t<>0 then begin
    case meldung of
    1: Writeln('Datumsangabe ungueltig'+CR);
    2: Writeln('Zeitangabe ungueltig'+CR);
    end;
    halt(1);
 end;
end;

procedure newmacro;
begin
  {Dateien und Macros speichern}
  NEW(n);
  n^.text:=s;
  n^.next:=st;
  st:=n;
end;

function ismacro:boolean;
var re :boolean;
begin
 re:=false;
 {Alle Laufwerke touchen}
 if (copy(s,1,2)='#:') then re:=true;
 {\#\ = keines oder beliebiges Verzeichnis}
 if pos(OSDirSeparator+'#'+OSDirSeparator,s)<>0 then re:=true;
 {\##\ Rekursives Verzeichnisladen}
 if pos(OSDirSeparator+'##'+OSDirSeparator,s)<>0 then re:=true;
 {# entspricht .\#\*.*}
 if s='#' then re:=true;
 {## entspricht .\##\*.*}
 if s='##' then re:=true;
 {### entspricht #:\##\*.*}
 if s='###' then re:=true;
 ismacro:=re;
end;

procedure exmacro;
const test='ABCDEFGHIJKLMNOPQRSTUVWXYZ';
var x,y : string[79];
    z   : byte;

  procedure newentry;
  begin
    NEW(n);
    n^.text:=x;
    n^.next:=st;
    st:=n;
  end;

begin
y:=test;
writeln('Expandiere Makro: '+s+CR);
  if (copy(s,1,2)='#:') then begin
  {$IFDEF BP}
  if s<>'#:' then begin
     for i:=1 to 26 do begin
       {Alle Laufwerke touchen}
       {$I-}
       assign(f,y[i]+':'+OSDirSeparator+'touch.$$$');
       rewrite(f);
       {$I+}
       if ioresult=0 then begin
         x:=y[i]+copy(s,2,255);
         newentry;
         close(f);
         erase(f);
       end;
     end;
    end;
  {$ENDIF}
  end
  else if pos(OSDirSeparator+'#'+OSDirSeparator,s)<>0 then begin
   {# = keines oder beliebiges Verzeichnis}
   x:=copy(s,1,pos(OSDirSeparator+'#'+OSDirSeparator,s))+
      copy(s,pos(OSDirSeparator+'#'+OSDirSeparator,s)+3,255);
   NewEntry;
   y:=copy(s,1,pos(OSDirSeparator+'#'+OSDirSeparator,s));
   x:=copy(s,1,pos(OSDirSeparator+'#'+OSDirSeparator,s))+'*.*';
   {$IFDEF WINDOWS }
   StrPCopy(sp,x);
   Findfirst(sp,$10,DirInfo);
   {$ELSE}
   {$IFNDEF BPLFN}
   Findfirst(x,$10,DirInfo);
   {$ELSE}
   touchlfn.Findfirst(x,$10,DirInfo);
   {$ENDIF}
   {$ENDIF}
   while DosError=0 do
    begin
      z:=(DirInfo.Attr and $10);
      if ((DirInfo.Name[1]<>'.') and (z=$10)) then begin
        x:=y+DirInfo.Name+OSDirSeparator+copy(s,pos(OSDirSeparator+'#'+
             OSDirSeparator,s)+3,255);
        NewEntry;
      end;
      {$IFNDEF BPLFN}
      FindNext(DirInfo);
      {$ELSE}
      touchlfn.FindNext(DirInfo);
      {$ENDIF}
    end;
  end
  else if pos(OSDirSeparator+'##'+OSDirSeparator,s)<>0 then begin
   {## = keines oder beliebiges Verzeichnis recursiv}
   x:=copy(s,1,pos(OSDirSeparator+'##'+OSDirSeparator,s))+
      copy(s,pos(OSDirSeparator+'##'+OSDirSeparator,s)+4,255);
   NewEntry;
   y:=copy(s,1,pos(OSDirSeparator+'##'+OSDirSeparator,s));
   x:=copy(s,1,pos(OSDirSeparator+'##'+OSDirSeparator,s))+'*.*';
   {$IFDEF WINDOWS }
   StrPCopy(sp,x);
   Findfirst(sp,$10,DirInfo);
   {$ELSE }
   {$IFNDEF BPLFN}
   Findfirst(x,$10,DirInfo);
   {$ELSE}
   touchlfn.Findfirst(x,$10,DirInfo);
   {$ENDIF}
   {$ENDIF }
   while DosError=0 do
   begin
     z:=(DirInfo.Attr and $10);
     if ((DirInfo.Name[1]<>'.') and (z=$10)) then begin
       x:=y+DirInfo.Name+OSDirSeparator+'##'+OSDirSeparator+
          copy(s,pos(OSDirSeparator+'##'+OSDirSeparator,s)+4,255);
       NewEntry;
     end;
     {$IFNDEF BPLFN}
     FindNext(DirInfo);
     {$ELSE}
     touchlfn.FindNext(DirInfo);
     {$ENDIF}
   end;
  end
  else if s='#' then begin
   x:='.'+OSDirSeparator+'#'+OSDirSeparator+'*.*';
   NewEntry;
  end
  else if s='##' then begin
   x:='.'+OSDirSeparator+'##'+OSDirSeparator+'*.*';
   NewEntry;
  end
  else if s='###' then begin
   {$IFDEF BP}
   x:='#:'+OSDirSeparator+'##'+OSDirSeparator+'*.*';
   NewEntry;
   {$ENDIF}
  end;
end;

function Testtime(ftime:longint;dateset,timeset:boolean):longint;
var foldtime:longint;
{$IFDEF WINDOWS }
    dt2     : TDateTime;
{$ELSE }
    dt2     : DateTime;
{$ENDIF }
begin
 {dateset und timeset testtime:=ftime}
 {nur dateset       time aus Datei}
 {nur timeset       date aus Datei}
 {nichts            testtime:=ftime}
 if not (dateset xor timeset) then testtime:=ftime else begin
 GetFTime(f,foldtime);
 UnpackTime(foldtime,dt2);
 if dateset then begin
    {zeitangaben von dt2 nach dt kopieren}
    dt.Hour:=dt2.Hour;
    dt.Min:=dt2.Min;
    dt.Sec:=dt2.Sec;
   end
   else
   begin
    {datum von dt2 nach dt kopieren}
     dt.Year:=dt2.Year;
     dt.Month:=dt2.Month;
     dt.Day:=dt2.Day;
   end;
 Packtime(dt,foldtime);
 testtime:=foldtime;
 end;
end;

function isnoWild(fname:string):boolean;
var t : boolean;
    i : byte;
begin
  t:=true;
  for i:=1 to 255 do
  begin
   if fname[i]='*' then t:=false;
   if fname[i]='?' then t:=false;
  end;  
  if (fname[length(fname)]=OSDirSeparator) then t:=false;
  {weitere Wildcards?}
  isnoWild:=t;
end;

function testname(fname,reffile:string):boolean;
var i  : integer;
    a,b:string;
begin
  {Reffile im Suchautomaten?}
  for i:=1 to length(fname) do a[i]:=upcase(fname[i]);
  for i:=1 to length(reffile) do b[i]:=upcase(reffile[i]);
  if a<>b then testname:=false else testname:=true;
end;

procedure init_touch;
begin
  files:=anyfile;
  st:=nil;
  n:=nil;
  dateSet:=false;
  timeSet:=false;
  sim:=false;
  uc:=false;
  nt:=false;
  zcout:=false;
  randomize;
  {$IFDEF WINDOWS}
  nc:=false;
  {$ENDIF}
end;

{$IFDEF BPLFN}
function LFNuseage:boolean;
var t:boolean;
    i:integer;
    j:byte;
    s,u:string;
begin
  if ParamCount = 0 then begin
    LFNuseage:=false;
  end
  else
  begin
   for i:=1 to ParamCount do
   begin
     t:=false;
     s:='';
     u:=ParamStr(i);
     for j:=1 to 4 do s:=s+upcase(u[j]);
     if s=Paramark+'LFN' then t:=true;
   end;
   LFNuseage:=t;
  end;
end;
{$ENDIF}

function strs(v:integer):string;
var s:string;
begin
  str(v,s);
  strs:=s;
end;

procedure ZC;
begin
  writeln(g,'EMP: /TEST'+CR);
  writeln(g,'ABS: TOUCH@touch.invalid'+CR);
  writeln(g,'BET: Testnachricht '+touchname+pform+CR);
  writeln(g,'EDA: '+strs(dt.Year)+strs(dt.Month)+strs(dt.Day)+
                    strs(dt.Hour)+strs(dt.Min)+strs(dt.Sec)+
                    'W+0'+CR);
  writeln(g,'MID: '+strs(dt.Year)+strs(dt.Month)+strs(dt.Day)+
                    strs(dt.Hour)+strs(dt.Min)+strs(dt.Sec)+
                    '.'+strs(random(10))+strs(random(10))+strs(random(10))+strs(random(10))+
                    strs(random(10))+strs(random(10))+strs(random(10))+strs(random(10))+'@touch.invalid'+CR);
  writeln(g,'ROT: touch.invalid!test'+CR);
  writeln(g,'MAILER: '+touchname+pform+CR);
  writeln(g,'LEN: 30'+CR);
  writeln(g,''+CR);
  writeln(g,'Dies ist eine Testnachricht.'+CR);
end;

function validparm:boolean;
begin
  {$IFDEF WINDOWS}
  if ((ParamCount = 1) and ((ParamStr(1)=Paramark+'NC') or (ParamStr(1)=Paramark+'nc'))) then begin
      validparm:=false;
      nc:=true;
    end
  else validparm:=true;
  {$ELSE}
  validparm:=true;
  {$ENDIF}
end;

begin
  {$IFNDEF BP }
    { FreePascal }
    {$IFDEF WINDOWS }
      {$M 65520,655360}
    {$ELSE}
      {$M 65520}
    {$ENDIF }
  {$ELSE }
    { Borland Pascal }
    {$IFDEF MSDOS}
      {$M 65520,0,655360}
    {$ENDIF}
    {$IFDEF DPMI}
      {$M 65520}
    {$ENDIF}
    {$IFDEF WINDOWS}
      {.$M 65520,655360}
    {$ENDIF}
  {$ENDIF }
  {$IFDEF BPLFN}
  if LFNuseage then EnableLFN;
  {$ENDIF}
  {$IFDEF WINDOWS}
  logo;
  InitWinCrt;
  {$ELSE}
  StandardIO;
  logo;
  {$ENDIF}
  init_touch;
  if ((ParamCount = 0) or (validparm=false)) then hilfe
  else
  begin
    {Aktuelle Uhrzeit ermitteln}
    GetTime(h,mi,se,hund);
    Getdate(y,mo,d,dw);
    ref:=false;
    {Erstmal nach Sonderparametern suchen ...}
    for i:=1 to paramcount do
    begin
      s:=ParamStr(i);
      if (copy(s,1,1)=Paramark) then begin
       s[2]:=UpCase(s[2]);
       s[3]:=UpCase(s[3]);
       {Parameter gefunden}
       if (copy(s,2,2)='T=') then begin
         {Uhrzeit lesen}
         {/t=hh:mm:ss}
         u:=Copy(s,4,255);
         s:=u;
         val(copy(s,0,(pos(':',s)-1)),h,t);
         isok(2);
         s:=Copy(s,(pos(':',s)+1),255);
         val(copy(s,0,(pos(':',s)-1)),mi,t);
         isok(2);
         s:=Copy(s,(pos(':',s)+1),255);
         val(s,se,t);
         isok(2);
        if (((h<0) or (h>23)) or ((mi<0) or (mi>59)) or ((se<0) or (se>59))) then begin
           writeln('Zeitangabe ungueltig'+CR);
           halt(1);
         end;
         timeSet:=true;
       end;
       if (copy(s,2,2)='D=') then begin
         {Datum lesen}
         {/d=tt.mm.yy}
         u:=Copy(s,4,255);
         s:=u;
         val(copy(s,0,(pos('.',s)-1)),d,t);
         isok(1);
         s:=Copy(s,(pos('.',s)+1),255);
         val(copy(s,0,(pos('.',s)-1)),mo,t);
         isok(1);
         s:=Copy(s,(pos('.',s)+1),255);
         val(s,y,t);
         isok(1);
         if (((d<1) or (d>31)) or ((mo<1) or (mo>12)) or ((y<0) or ((y>99) and ((y<1980) or (y>2107))))) then begin
            Writeln('Datumsangabe ungueltig'+CR);
            halt(1);
         end;
         dateSet:=true;
       end;
       {Hidden-Files auch}
       if (copy(s,2,1)='H') then files:=files or $02;
       {System-Files auch}
       if (copy(s,2,1)='S') then files:=files or $04;
       {Simulationslauf}
       if (copy(s,2,1)='V') then begin
         sim:=true;
         writeln ('Simulationslauf - keine Veraenderungen werden getaetigt'+CR);
       end;
       if (copy(s,2,2)='ZC') then begin
         zcout:=true;
         Writeln ('Neue Dateien werden als ZConnect-PUFFER erstellt.'+CR);
       end;
       if (copy(s,2,1)='G') then uc:=true;
       if (copy(s,2,1)='K') then nt:=true;
       {$IFDEF WINDOWS}
       if (copy(s,2,2)='NC') then nc:=true;
       {$ENDIF}
       if ((copy(s,2,2)='R=') or (copy(s,2,2)='F=')) then begin
         {Referenzdatei}
         filemode:=0;
         s:=copy(s,4,255);
         reffile:=s;
         Assign(f,s);
         {$I-}
         Reset(f,1);
         {$I+}
         If Ioresult<>0 then begin
           Writeln('Referenzdatei nicht gefunden'+CR);
           halt(1);
         end;
         GetFTime(f,Ftime);
         ref:=true;
         Close(f);
         filemode:=2;
        end;
       if (copy(s,2,2)='J=') then begin
         {Jobfile}
         filemode:=0;
         s:=copy(s,4,255);
         Assign(g,s);
         {$I-}
         Reset(g);
         {$I+}
         If Ioresult<>0 then begin
           Writeln('Jobdatei nicht gefunden'+CR);
           halt(1);
         end;
         while not EOF(g) do
         begin
           Readln(g,s);
           newmacro;
         end;
         Close(g);
         filemode:=2;
       end;
       if (copy(s,2,1)='I') then begin
        {Interaktiver Modus}
        Readln(s);
        while not (s='') do
        begin
          newmacro;
          Readln(s);
        end;
       end;
      end
      else newmacro;
    end;
    if ((ref and dateset) or (ref and timeset)) then begin
      Writeln('Entweder Datum/Uhrzeit oder Referenzdatei'+CR);
      halt(1);
    end;
    if not (nt and uc) then begin
       if dateset then writeln('Datei-Datum wird gesetzt'+CR);
       if timeset then writeln('Datei-Zeit wird gesetzt'+CR);
       if not (dateset or timeset) then writeln ('Datei-Datum und Datei-Zeit werden aktualisiert'+CR);
    end;
    if uc then writeln('Dateinamen grossschreiben'+CR);
    {Datetime packen}
    if not ref then begin
       dt.Year:=y;
       dt.Month:=mo;
       dt.Day:=d;
       dt.Hour:=h;
       dt.Min:=mi;
       dt.Sec:=se;
       PackTime(dt,Ftime);
    end;
    {Dateien verarbeiten}
    if st=nil then begin
      writeln('Dateiangabe fehlt'+CR);
      halt(1);
    end;
    n:=st;
    repeat
      s:=n^.text;
      st:=n^.next;
      dispose(n);
      n:=st;
      if ismacro then exmacro else
      begin
       {kein Sonderparameter also Dateiname}
       if (s[length(s)]=OSDirSeparator) then s:=s else begin
         findone:=false;
         {$IFDEF WINDOWS }
         StrPCopy(sp,s);
         FileSplit(sp,Dir,Name,Ext);
         FindFirst(sp,files,DirInfo);
         {$ELSE}
         {$IFNDEF BPLFN}
         FSplit(s,Dir,Name,Ext);
         FindFirst(s,files,DirInfo);
         {$ELSE}
         touchlfn.FSplit(s,Dir,Name,Ext);
         touchlfn.FindFirst(s,files,DirInfo);             
         {$ENDIF}
         {$ENDIF}
         while DosError = 0 do
         begin           
           fname:=DirInfo.name;
           findone:=true;
           {$IFDEF WINDOWS }
           If StrPas(Dir)='' then begin
             StrPCopy(fnamep,fname);
             FileExpand(Dir,fnamep);
             StrCopy(Dir,fnamep);
             fname:=StrPas(fnamep);
           end
           {$ELSE}
           If Dir='' then begin
             fname:=FExpand(fname);
           end
           {$ENDIF}
           else fname:=Dir+fname;
           if fname<>own then begin
             write(fname);
             {Refdatei nicht touchen}
             if ref and testname(reffile,fname) then writeln(' Referenz'+CR)
             else begin
               if (sim=false) then begin                
                  Assign(f,fname);
                  if (nt and uc) then GetFtime(f,ftime);
                  {$I-}
                  if uc then begin
                     rename(f,'temp.$$$');
                     if IOResult <> 0 then writeln(' Umbenennen der Datei fehlgeschlagen'+CR);
                     for i:=1 to length(fname) do fname[i]:=upcase(fname[i]);
                     rename(f,fname);
                     if IOResult <> 0 then begin
                       writeln(' Umbenennen der Datei kritisch fehlgeschlagen'+CR);
                       halt(1);
                     end;
                  end;
                  Reset(f,1);
                  {$I+}
                  if IOResult <> 0 then writeln(' Oeffnen der Datei fehlgeschlagen'+CR);
                  if not (nt and uc) then ftime:=Testtime(ftime,dateset,timeset);
                  {$IFNDEF unix}
                  SetFtime(f,Ftime);
                  if Doserror<>0 then writeln('!'+CR) else writeln(''+CR);
                  close(f);
                  {$ELSE}
                  close(f);
                  if unixsetftime(s,ftime2epoch(ftime)) then writeln(''+CR) else writeln('!'+CR);
                  {$ENDIF}
               end
               else writeln(''+CR);             
             end;
           end;
           {$IFNDEF BPLFN}
           FindNext(DirInfo);
           {$ELSE}
           touchlfn.FindNext(DirInfo);
           {$ENDIF}
         end;
         {Keine Datei gefunden ? Dann neu anlegen!!}
         if findone=false then begin
          if isnoWild(fname) then begin
           writeln(s+CR);
           if (sim=false) then begin             
                 Assign(g,s);
                 {$I-}
                 Rewrite(g);
                 {$I+}
                 if IOResult <> 0 then writeln(' Anlegen der neuen Datei fehlgeschlagen'+CR)
                 else if zcout=true then ZC;
                 {$IFNDEF unix}
                 {$I-}
                 Reset(g);
                 {$I+}
                 if IOResult <> 0 then writeln(' Anlegen der neuen Datei fehlgeschlagen'+CR);
                 {$I-}                                  
                 SetFtime(g,Ftime);
                 {$I+}
                 if IOResult <> 0 then writeln (' Touchen der neuen Datei fehlgeschlagen'+CR);
                 {$ENDIF}
                 {$I-}
                 close(g);
                 {$I+}
                 if ioresult <> 0 then writeln (' Schliessen der neuen Datei fehlgeschlagen'+CR);
                 {$IFDEF unix}                 
                 if unixsetftime(s,ftime2epoch(ftime)) then write('') 
                 else writeln(' Touchen der neuen Datei fehlgeschlagen'+CR);
                 {$ENDIF}
           end;
          end;
         end;
         {$IFNDEF BP }
         {FP needs Findclose, BP has no Findclose}
         Findclose(DirInfo);
         {$ENDIF }
        end;
      end;
    until n=nil;
  end;
  {$IFDEF WINDOWS}
  if nc then Readln;
  DoneWinCrt;
  {$ENDIF}
end.
{
  $Log: touch.pas,v $
  Revision 1.22  2005/09/29 08:33:15  mw
  MW: - Bugfix: Schreibgeschtzte Refernzdateien fhrten zum Abbruch

  Revision 1.21  2005/01/01 11:16:28  mw
  MW: - Willkommen im Jahr 2005

  Revision 1.20  2004/11/28 11:45:38  mw
  MW: - Touch ist nun echte Freeware.

  Revision 1.19  2004/11/18 16:04:11  mw
  MW: - Update auf Touch 1.2

  Revision 1.18  2004/11/09 10:56:11  mw
  MW: - Fehlerbereinigung

  Revision 1.16  2004/11/09 09:54:50  mw
  MW: - bernahme von TOUCH 1.1d

  Revision 1.14  2004/11/07 09:31:05  mw
  MW: - bernahme von TOUCH 1.1c

  Revision 1.13  2004/11/06 21:56:42  mw
  MW: - bernahme von TOUCH 1.1b

  Revision 1.12  2004/11/06 15:52:38  mw
  MW: - bernahme von TOUCH 1.1a

  Revision 1.11  2004/08/12 11:15:49  mw
  MW: - bernahme von TOUCH 1.1
}
