/*
 * Copyright (c) 1990, 1999 Erick Engelke
 */
#include <rtos.h>
#include <stdio.h>
#include <string.h>
#include <dos.h>
#include <stdlib.h>
#include <net.h>
#include <mem.h>
#include <graph.h>
#include <values.h>

void *gr_alloc( int width, int height )
{
    DWORD bytes;
    int i;
    graph_x *g;
    BYTE *bp;

    bytes = (DWORD)width * (DWORD)height;
    i = bytes;
    if ( i < bytes ) return( NULL );
    bp = kcalloc( i, 1 );
    if ( bp == NULL ) return( NULL );

    g = kcalloc( sizeof( graph_x ), 1 );
    if ( g == NULL ) {
        kfree( bp );
        return( NULL );
    }
    g->g_data = bp;
    g->g_width = width;
    g->g_height = height;
    return( g );
}
void gr_free( void *x )
{
    graph_x *g = x;
    if ( g != NULL ) {
        kfree( g->g_data );
        kfree( g );
    }
}
void gr_background( void *z, int col )
{
    graph_x *g = z;

    g->g_background = col;
    memset( g->g_data, col, g->g_width * g->g_height );
}
void gr_setpixel( void *z, int x, int y, int cols )
{
    graph_x *g = z;

    if (( x >= 0 ) && ( x < g->g_width ) && ( y >= 0 ) && ( y < g->g_height ))
        g->g_data[ x + ( y * g->g_width) ] = cols;
}
int gr_getpixel( void *z, int x, int y )
{
    graph_x *g = z;
    static int oldy = 0, ymult = 0;

    /* avoid multiplications when we can */
    if ( oldy != y ) {
        ymult = y * g->g_width;
        oldy = y;
    }

    if (( x >= 0 ) && ( x < g->g_width ) && ( y >= 0 ) && ( y < g->g_height ))
        return( g->g_data[ x + ymult  ]  );
    else
        return( g->g_background );
}

static void swapxy( int *x1, int *y1, int *x2, int *y2 )
{
    int temp;
    temp = *x1; *x1 = *x2; *x2 = temp;
    temp = *y1; *y1 = *y2; *y2 = temp;
}
void gr_line( void *z, int x1, int y1, int x2, int y2, int color )
{
    int difx, dify;
    int temp;

    difx = x2 - x1;
    if ( difx < 0 ) {
        swapxy( &x1, &y1, &x2, &y2 );
        difx = x2 - x1;
    }
    /* now x1 < x2 */

    dify = y2 - y1;
    temp = dify;
    if ( temp < 0 ) temp = -temp;

    if ( difx > temp ) {
        for ( temp = 0 ; temp <= difx ; ++temp )
            gr_setpixel( z, temp + x1, temp*dify/difx + y1,color);
    } else {
        if ( dify < 0 ) {
            swapxy( &x1, &y1, &x2, &y2 );
            difx = -difx;
            dify = -dify;
        }
        for ( temp = 0 ; temp < dify ; ++temp )
            gr_setpixel( z, temp*difx/dify + x1, temp + y1, color);
    }
}



#define HLEN 9

#if defined(__TURBOC__) || defined(__BORLANDC__)
static char font[96][HLEN] = {
        0000,0000,0000,0000,0000,0000,0000,0000,0000,   /* sp */
        0010,0010,0010,0010,0010,0000,0010,0000,0000,   /* ! */
        0024,0024,0024,0000,0000,0000,0000,0000,0000,   /* QUOTE */
        0024,0024,0076,0024,0076,0024,0024,0000,0000,   /* # */
        0010,0036,0050,0034,0012,0074,0010,0000,0000,   /* $ */
        0060,0062,0004,0010,0020,0046,0006,0000,0000,   /* % */
        0010,0024,0024,0030,0052,0044,0032,0000,0000,   /* & */
        0010,0010,0020,0000,0000,0000,0000,0000,0000,   /* ' */
        0004,0010,0020,0020,0020,0010,0004,0000,0000,   /* ( */
        0020,0010,0004,0004,0004,0010,0020,0000,0000,   /* ) */
        0000,0010,0052,0034,0052,0010,0000,0000,0000,   /* * */
        0000,0010,0010,0076,0010,0010,0000,0000,0000,   /* + */
        0000,0000,0000,0000,0000,0030,0030,0010,0020,   /* , */
        0000,0000,0000,0076,0000,0000,0000,0000,0000,   /* - */
        0000,0000,0000,0000,0000,0030,0030,0000,0000,   /* . */
        0001,0002,0004,0010,0020,0040,0100,0000,0000,   /* / */
        0034,0042,0046,0052,0062,0042,0034,0000,0000,   /* 0 */
        0010,0030,0010,0010,0010,0010,0034,0000,0000,   /* 1 */
        0034,0042,0002,0004,0010,0020,0076,0000,0000,   /* 2 */
        0076,0004,0010,0004,0002,0042,0034,0000,0000,   /* 3 */
        0004,0014,0024,0044,0076,0004,0004,0000,0000,   /* 4 */
        0076,0040,0074,0002,0002,0042,0034,0000,0000,   /* 5 */
        0014,0020,0040,0074,0042,0042,0034,0000,0000,   /* 6 */
        0076,0002,0004,0010,0020,0020,0020,0000,0000,   /* 7 */
        0034,0042,0042,0034,0042,0042,0034,0000,0000,   /* 8 */
        0034,0042,0042,0036,0002,0004,0030,0000,0000,   /* 9 */
        0000,0030,0030,0000,0030,0030,0000,0000,0000,   /* : */
        0000,0030,0030,0000,0030,0030,0010,0020,0000,   /* ; */
        0002,0004,0010,0020,0010,0004,0002,0000,0000,   /* < */
        0000,0000,0076,0000,0076,0000,0000,0000,0000,   /* = */
        0040,0020,0010,0004,0010,0020,0040,0000,0000,   /* > */
        0034,0042,0002,0004,0010,0000,0010,0000,0000,   /* ? */
        0014,0022,0056,0052,0056,0040,0036,0000,0000,   /* @ */
        0034,0042,0042,0076,0042,0042,0042,0000,0000,   /* A */
        0074,0042,0042,0074,0042,0042,0074,0000,0000,   /* B */
        0034,0042,0040,0040,0040,0042,0034,0000,0000,   /* C */
        0070,0044,0042,0042,0042,0044,0070,0000,0000,   /* D */
        0076,0040,0040,0074,0040,0040,0076,0000,0000,   /* E */
        0076,0040,0040,0074,0040,0040,0040,0000,0000,   /* F */
        0036,0040,0040,0046,0042,0042,0036,0000,0000,   /* G */
        0042,0042,0042,0076,0042,0042,0042,0000,0000,   /* H */
        0034,0010,0010,0010,0010,0010,0034,0000,0000,   /* I */
        0034,0010,0010,0010,0010,0050,0020,0000,0000,   /* J */
        0042,0044,0050,0060,0050,0044,0042,0000,0000,   /* K */
        0040,0040,0040,0040,0040,0040,0076,0000,0000,   /* L */
        0042,0066,0052,0052,0042,0042,0042,0000,0000,   /* M */
        0042,0042,0062,0052,0046,0042,0042,0000,0000,   /* N */
        0034,0042,0042,0042,0042,0042,0034,0000,0000,   /* O */
        0074,0042,0042,0074,0040,0040,0040,0000,0000,   /* P */
        0034,0042,0042,0042,0052,0044,0032,0000,0000,   /* Q */
        0074,0042,0042,0074,0050,0044,0042,0000,0000,   /* R */
        0034,0042,0040,0034,0002,0042,0034,0000,0000,   /* S */
        0076,0010,0010,0010,0010,0010,0010,0000,0000,   /* T */
        0042,0042,0042,0042,0042,0042,0034,0000,0000,   /* U */
        0042,0042,0042,0024,0024,0010,0010,0000,0000,   /* V */
        0042,0042,0042,0052,0052,0052,0024,0000,0000,   /* W */
        0042,0042,0024,0010,0024,0042,0042,0000,0000,   /* X */
        0042,0042,0024,0010,0010,0010,0010,0000,0000,   /* Y */
        0076,0002,0004,0010,0020,0040,0076,0000,0000,   /* Z */
        0034,0020,0020,0020,0020,0020,0034,0000,0000,   /* [ */
        0100,0040,0020,0010,0004,0002,0001,0000,0000,   /* \ */
        0034,0004,0004,0004,0004,0004,0034,0000,0000,   /* ] */
        0010,0024,0042,0000,0000,0000,0000,0000,0000,   /* ^ */
        0000,0000,0000,0000,0000,0000,0076,0000,0000,   /* _ */
        0010,0010,0004,0000,0000,0000,0000,0000,0000,   /* ` */
        0000,0000,0034,0002,0036,0042,0036,0000,0000,   /* a */
        0040,0040,0074,0042,0042,0042,0074,0000,0000,   /* b */
        0000,0000,0030,0044,0040,0044,0030,0000,0000,   /* c */
        0002,0002,0036,0042,0042,0042,0036,0000,0000,   /* d */
        0000,0000,0034,0042,0076,0040,0034,0000,0000,   /* e */
        0014,0022,0070,0020,0020,0020,0020,0000,0000,   /* f */
        0000,0000,0032,0046,0042,0046,0032,0002,0034,   /* g */
        0040,0040,0074,0042,0042,0042,0042,0000,0000,   /* h */
        0010,0000,0030,0010,0010,0010,0034,0000,0000,   /* i */
        0004,0000,0004,0004,0004,0004,0004,0044,0030,   /* j */
        0040,0040,0044,0050,0064,0042,0042,0000,0000,   /* k */
        0030,0010,0010,0010,0010,0010,0034,0000,0000,   /* l */
        0000,0000,0064,0052,0052,0052,0052,0000,0000,   /* m */
        0000,0000,0074,0042,0042,0042,0042,0000,0000,   /* n */
        0000,0000,0034,0042,0042,0042,0034,0000,0000,   /* o */
        0000,0000,0054,0062,0042,0062,0054,0040,0040,   /* p */
        0000,0000,0032,0046,0042,0046,0032,0002,0002,   /* q */
        0000,0000,0054,0062,0040,0040,0040,0000,0000,   /* r */
        0000,0000,0036,0040,0034,0002,0074,0000,0000,   /* s */
        0020,0020,0070,0020,0020,0022,0014,0000,0000,   /* t */
        0000,0000,0042,0042,0042,0046,0032,0000,0000,   /* u */
        0000,0000,0042,0042,0042,0024,0010,0000,0000,   /* v */
        0000,0000,0042,0042,0052,0052,0024,0000,0000,   /* w */
        0000,0000,0042,0024,0010,0024,0042,0000,0000,   /* x */
        0000,0000,0042,0042,0042,0046,0032,0002,0034,   /* y */
        0000,0000,0076,0004,0010,0020,0076,0000,0000,   /* z */
        0014,0020,0020,0040,0020,0020,0014,0000,0000,   /* { */
        0010,0010,0010,0000,0010,0010,0010,0000,0000,   /* | */
        0030,0004,0004,0002,0004,0004,0030,0000,0000,   /* } */
        0020,0052,0004,0000,0000,0000,0000,0000,0000,   /* ~ */
        0177,0177,0177,0177,0177,0177,0177,0177,0177,   /* del */
};
#elif defined(__DJGPP__)
static char font[96][HLEN] = {
      { 0000,0000,0000,0000,0000,0000,0000,0000,0000 },   /* sp */
      { 0010,0010,0010,0010,0010,0000,0010,0000,0000},  /* ! */
      { 0024,0024,0024,0000,0000,0000,0000,0000,0000},  /* QUOTE */
      { 0024,0024,0076,0024,0076,0024,0024,0000,0000},  /* # */
      { 0010,0036,0050,0034,0012,0074,0010,0000,0000},  /* $ */
      { 0060,0062,0004,0010,0020,0046,0006,0000,0000},  /* % */
      { 0010,0024,0024,0030,0052,0044,0032,0000,0000},  /* & */
      { 0010,0010,0020,0000,0000,0000,0000,0000,0000},  /* ' */
      { 0004,0010,0020,0020,0020,0010,0004,0000,0000},  /* ( */
      { 0020,0010,0004,0004,0004,0010,0020,0000,0000},  /* ) */
      { 0000,0010,0052,0034,0052,0010,0000,0000,0000},  /* * */
      { 0000,0010,0010,0076,0010,0010,0000,0000,0000},  /* + */
      { 0000,0000,0000,0000,0000,0030,0030,0010,0020},  /* , */
      { 0000,0000,0000,0076,0000,0000,0000,0000,0000},  /* - */
      { 0000,0000,0000,0000,0000,0030,0030,0000,0000},  /* . */
      { 0001,0002,0004,0010,0020,0040,0100,0000,0000},  /* / */
      { 0034,0042,0046,0052,0062,0042,0034,0000,0000},  /* 0 */
      { 0010,0030,0010,0010,0010,0010,0034,0000,0000},  /* 1 */
      { 0034,0042,0002,0004,0010,0020,0076,0000,0000},  /* 2 */
      { 0076,0004,0010,0004,0002,0042,0034,0000,0000},  /* 3 */
      { 0004,0014,0024,0044,0076,0004,0004,0000,0000},  /* 4 */
      { 0076,0040,0074,0002,0002,0042,0034,0000,0000},  /* 5 */
      { 0014,0020,0040,0074,0042,0042,0034,0000,0000},  /* 6 */
      { 0076,0002,0004,0010,0020,0020,0020,0000,0000},  /* 7 */
      { 0034,0042,0042,0034,0042,0042,0034,0000,0000},  /* 8 */
      { 0034,0042,0042,0036,0002,0004,0030,0000,0000},  /* 9 */
      { 0000,0030,0030,0000,0030,0030,0000,0000,0000},  /* : */
      { 0000,0030,0030,0000,0030,0030,0010,0020,0000},  /* ; */
      { 0002,0004,0010,0020,0010,0004,0002,0000,0000},  /* < */
      { 0000,0000,0076,0000,0076,0000,0000,0000,0000},  /* = */
      { 0040,0020,0010,0004,0010,0020,0040,0000,0000},  /* > */
      { 0034,0042,0002,0004,0010,0000,0010,0000,0000},  /* ? */
      { 0014,0022,0056,0052,0056,0040,0036,0000,0000},  /* @ */
      { 0034,0042,0042,0076,0042,0042,0042,0000,0000},  /* A */
      { 0074,0042,0042,0074,0042,0042,0074,0000,0000},  /* B */
      { 0034,0042,0040,0040,0040,0042,0034,0000,0000},  /* C */
      { 0070,0044,0042,0042,0042,0044,0070,0000,0000},  /* D */
      { 0076,0040,0040,0074,0040,0040,0076,0000,0000},  /* E */
      { 0076,0040,0040,0074,0040,0040,0040,0000,0000},  /* F */
      { 0036,0040,0040,0046,0042,0042,0036,0000,0000},  /* G */
      { 0042,0042,0042,0076,0042,0042,0042,0000,0000},  /* H */
      { 0034,0010,0010,0010,0010,0010,0034,0000,0000},  /* I */
      { 0034,0010,0010,0010,0010,0050,0020,0000,0000},  /* J */
      { 0042,0044,0050,0060,0050,0044,0042,0000,0000},  /* K */
      { 0040,0040,0040,0040,0040,0040,0076,0000,0000},  /* L */
      { 0042,0066,0052,0052,0042,0042,0042,0000,0000},  /* M */
      { 0042,0042,0062,0052,0046,0042,0042,0000,0000},  /* N */
      { 0034,0042,0042,0042,0042,0042,0034,0000,0000},  /* O */
      { 0074,0042,0042,0074,0040,0040,0040,0000,0000},  /* P */
      { 0034,0042,0042,0042,0052,0044,0032,0000,0000},  /* Q */
      { 0074,0042,0042,0074,0050,0044,0042,0000,0000},  /* R */
      { 0034,0042,0040,0034,0002,0042,0034,0000,0000},  /* S */
      { 0076,0010,0010,0010,0010,0010,0010,0000,0000},  /* T */
      { 0042,0042,0042,0042,0042,0042,0034,0000,0000},  /* U */
      { 0042,0042,0042,0024,0024,0010,0010,0000,0000},  /* V */
      { 0042,0042,0042,0052,0052,0052,0024,0000,0000},  /* W */
      { 0042,0042,0024,0010,0024,0042,0042,0000,0000},  /* X */
      { 0042,0042,0024,0010,0010,0010,0010,0000,0000},  /* Y */
      { 0076,0002,0004,0010,0020,0040,0076,0000,0000},  /* Z */
      { 0034,0020,0020,0020,0020,0020,0034,0000,0000},  /* [ */
      { 0100,0040,0020,0010,0004,0002,0001,0000,0000},  /* \ */
      { 0034,0004,0004,0004,0004,0004,0034,0000,0000},  /* ] */
      { 0010,0024,0042,0000,0000,0000,0000,0000,0000},  /* ^ */
      { 0000,0000,0000,0000,0000,0000,0076,0000,0000},  /* _ */
      { 0010,0010,0004,0000,0000,0000,0000,0000,0000},  /* ` */
      { 0000,0000,0034,0002,0036,0042,0036,0000,0000},  /* a */
      { 0040,0040,0074,0042,0042,0042,0074,0000,0000},  /* b */
      { 0000,0000,0030,0044,0040,0044,0030,0000,0000},  /* c */
      { 0002,0002,0036,0042,0042,0042,0036,0000,0000},  /* d */
      { 0000,0000,0034,0042,0076,0040,0034,0000,0000},  /* e */
      { 0014,0022,0070,0020,0020,0020,0020,0000,0000},  /* f */
      { 0000,0000,0032,0046,0042,0046,0032,0002,0034},  /* g */
      { 0040,0040,0074,0042,0042,0042,0042,0000,0000},  /* h */
      { 0010,0000,0030,0010,0010,0010,0034,0000,0000},  /* i */
      { 0004,0000,0004,0004,0004,0004,0004,0044,0030},  /* j */
      { 0040,0040,0044,0050,0064,0042,0042,0000,0000},  /* k */
      { 0030,0010,0010,0010,0010,0010,0034,0000,0000},  /* l */
      { 0000,0000,0064,0052,0052,0052,0052,0000,0000},  /* m */
      { 0000,0000,0074,0042,0042,0042,0042,0000,0000},  /* n */
      { 0000,0000,0034,0042,0042,0042,0034,0000,0000},  /* o */
      { 0000,0000,0054,0062,0042,0062,0054,0040,0040},  /* p */
      { 0000,0000,0032,0046,0042,0046,0032,0002,0002},  /* q */
      { 0000,0000,0054,0062,0040,0040,0040,0000,0000},  /* r */
      { 0000,0000,0036,0040,0034,0002,0074,0000,0000},  /* s */
      { 0020,0020,0070,0020,0020,0022,0014,0000,0000},  /* t */
      { 0000,0000,0042,0042,0042,0046,0032,0000,0000},  /* u */
      { 0000,0000,0042,0042,0042,0024,0010,0000,0000},  /* v */
      { 0000,0000,0042,0042,0052,0052,0024,0000,0000},  /* w */
      { 0000,0000,0042,0024,0010,0024,0042,0000,0000},  /* x */
      { 0000,0000,0042,0042,0042,0046,0032,0002,0034},  /* y */
      { 0000,0000,0076,0004,0010,0020,0076,0000,0000},  /* z */
      { 0014,0020,0020,0040,0020,0020,0014,0000,0000},  /* { */
      { 0010,0010,0010,0000,0010,0010,0010,0000,0000},  /* | */
      { 0030,0004,0004,0002,0004,0004,0030,0000,0000},  /* } */
      { 0020,0052,0004,0000,0000,0000,0000,0000,0000},  /* ~ */
      { 0177,0177,0177,0177,0177,0177,0177,0177,0177 }  /* del */
};
#endif

void gr_char_at( void *z , char ch, int x, int y, int color )
{
    graph_x *g;
    int xx, yy;
    char *cp;
    BYTE b, mask;

    g = z;
    cp = font[ ch - ' ' ];

    for ( yy = 8 ; yy > 0 ; --yy ) {
        b = *cp++;
        for ( xx = 0 , mask = 0x80 ; mask ; ++xx, mask >>= 1 ) {
            if ( b & mask )
                gr_setpixel( g, x + xx, y + yy, color );
        }
    }
}
void gr_text_at( void *z , char *s, int x, int y, int color )
{
    int i;

    while (*s) {
        gr_char_at( z, *s++, x, y, color );
        x += 9;
    }
}

void gr_linegraph( void *z, int numpoints, int *ys,
    char *x1, char *x2, int textcolor, int color )
{
    int i;
    int max = -MAXINT;
    int min = MAXINT;
    graph_x *g;
    char buffer[ 16 ];
    int prevx, curx, cury, dif;

    g = z;
    for ( i = 0 ; i < numpoints ; ++i ) {
        cury = ys[i];
        if ( cury > max ) max = cury;
        if ( cury < min ) min = cury;
    }
    if ( max == min ) max++;
    dif = max - min;

    gr_line( g, 0, 9, g->g_width -1, 9, 0 );
    gr_line( g, 0, 9, 0, g->g_height-1, 0 );
    itoa( max, buffer, 10 );
    gr_text_at( g, buffer, 1, g->g_height - 10, textcolor );
    itoa( min, buffer, 10 );
    gr_text_at( g, buffer, 1, 10, textcolor );
    if ( x1 != NULL ) gr_text_at( g, x1, 1, 0, textcolor );
    if ( x2 != NULL ) gr_text_at( g, x2,
            g->g_width - strlen( x2 ) * 9, 0,  textcolor );


#define SCALEX( x ) (int)( (DWORD)(x) * g->g_width / numpoints )
#define SCALEY( y ) ((int)( (DWORD)(y-min) * (g->g_height - 10) / dif )+9)

    curx = 0;
    for ( i = 1 ; i < numpoints ; ++i ) {
        prevx = curx;
        curx = SCALEX( i );

        gr_setpixel( g, curx, 8, 0 );
        gr_line( g, prevx, // SCALEX(i - 1),
                    SCALEY( ys[i-1] ),
                    curx, // SCALEX( i ),
                    SCALEY( ys[ i ] ),
                    color );
    }
}

/*
 * Gif Conversion - this section must be single threaded
 */
static graph_x *cur = NULL;
#include "gifsave.h"

static int gpixel(int x, int y)
{
    return gr_getpixel(cur, x, cur->g_height - y);
}

void gr_gif( tcp_Socket *s, void *z )
{
    graph_x *g;


#define NUMCOLORS          8  /* Number of different colors */
#define BITS_PR_PRIM_COLOR 1  /* Two bits pr primary color */

    int q;                      /* Counter */

    sock_mode( s, TCP_MODE_BINARY | TCP_MODE_NONAGLE );

    g = z;
    cur = g;
    GIF_Create(
        s,
        g->g_width, g->g_height-1, NUMCOLORS, BITS_PR_PRIM_COLOR );

    /*
     *  Set each color according to the values extracted from
     *  the palette
     */
    for (q = 0; q < NUMCOLORS; q++)
        /*   Red, Green, Blue */
        GIF_SetColor(q, q & 1, (q >> 1) &1, (q>>2) & 1 );

    /*
     *  Store the entire screen as an image using the user defined
     *  callback function gpixel() to get pixel values from the screen
     */
    GIF_CompressImage(z, 0, 0, -1, -1, gr_getpixel);

    /*
     *  Finish it all and close the file
     */
    GIF_Close();
}



