/*
 * Copyright (c) 1990, 1999 Erick Engelke
 */
#include <rtos.h>
#include <net.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <syslog.h>


#define SYSLOG_PORT 514

CODE prioritynames[] = {
	"alert",	LOG_ALERT,
	"crit",		LOG_CRIT,
	"debug",	LOG_DEBUG,
	"emerg",	LOG_EMERG,
	"err",		LOG_ERR,
	"error",	LOG_ERR,		/* DEPRECATED */
	"info",		LOG_INFO,
	"notice",	LOG_NOTICE,
	"panic", 	LOG_EMERG,		/* DEPRECATED */
	"warn",		LOG_WARNING,		/* DEPRECATED */
	"warning",	LOG_WARNING,
	"",		-1,
};

int priority_msg_to_number( msg )
char *msg;
{
int i;

for( i=0; prioritynames[i].c_val != -1; i++ )
  if( !stricmp( msg, prioritynames[i].c_name ) )
    return( prioritynames[i].c_val );

return( -1 );
}

CODE facilitynames[] = {
	"auth",		LOG_AUTH,
	"authpriv",	LOG_AUTHPRIV,
	"cron", 	LOG_CRON,
	"daemon",	LOG_DAEMON,
	"ftp",		LOG_FTP,
	"kern",		LOG_KERN,
	"lpr",		LOG_LPR,
	"mail",		LOG_MAIL,
	"news",		LOG_NEWS,
	"security",	LOG_AUTH,		/* DEPRECATED */
	"syslog",	LOG_SYSLOG,
	"user",		LOG_USER,
	"uucp",		LOG_UUCP,
	"local0",	LOG_LOCAL0,
	"local1",	LOG_LOCAL1,
	"local2",	LOG_LOCAL2,
	"local3",	LOG_LOCAL3,
	"local4",	LOG_LOCAL4,
	"local5",	LOG_LOCAL5,
	"local6",	LOG_LOCAL6,
	"local7",	LOG_LOCAL7,
	"",		-1,
};

int facility_msg_to_number( msg )
char *msg;
{
int i;

for( i=0; facilitynames[i].c_val != -1; i++ )
  if( !stricmp( msg, facilitynames[i].c_name ) )
    return( facilitynames[i].c_val );

return( -1 );
}




int syslog( DWORD host, int file, int level, char *msg )
{
    udp_Socket *s;
    char *p;
    int len, res = -1;

    s = kcalloc( sizeof( udp_Socket ), 1 );
    if ( s == NULL ) return( -1 );

    len = strlen( msg );
    p = kcalloc( len + 8, 1 );
    if ( p == NULL ) {
        kfree( s );
        return( -1 );
    }

    *p = '<';
    itoa( level + file, p + 1, 10 );
    strcat( p, ">");

    strcat( p, msg );

    if (udp_open( s, 0, host, SYSLOG_PORT, NULL )) {
        sock_write( s, p, strlen( p ));
        res = 0;
        sock_close( s );
    }

    kfree( p );
    kfree( s );
    return( res );
}

