/*
 * Copyright (c) 1990, 1999 Erick Engelke
 */
#ifndef _STRLST_H
#define _STRLST_H

#ifndef RTOS_H
#include <rtos.h>
#endif

#define _STRLST_SE_SIG 0x475833ffL
typedef struct _stringentry {
    DWORD se_sig;
    struct _stringentry *se_next;
    char *se_string;
    void *se_data;
} stringentry;

#define _STRLST_SL_SIG 0x7654f323L
typedef struct _stringlist {
    DWORD sl_sig;
    stringentry *sl_list;
} stringlist;

stringlist *strlst_new( void );
int   strlst_adddata( stringlist *sl, char *s, void *d );
int   strlst_add( stringlist *sl, char *s );
void  strlst_del( stringlist *sl, int index );
void  strlst_freeall( stringlist *sl );
char *strlst_getfirst( stringlist *sl, void **dummy, BYTE **data );
char *strlst_getnext( stringlist *sl, void **dummy, BYTE **data );
char *strlst_findfirst( stringlist *sl, char *text, void **dummy, BYTE **data );

#endif
