/**************************************************************************/
/* test5 - shows byte queue tools                                         */
/**************************************************************************/

#include "rtos.h"
#include <stdio.h>
#include <stdlib.h>

void *peer = NULL;
bq_str *bq = NULL;  /* byte queue */

void switcher1(DWORD arg)
{
    int x;

#if defined(__TURBOC__)||defined(__BORLANDC__)
    randomize();
#else
    srand( time( 0 ));
#endif

    do {
        rt_yield();
        x = rand();
        if ( x > 25000 ) {
            x = ( x & 255 );
            cprintf( " sending %u ", x );
            bq_writebyte( bq, x );
            bq_writebyte( bq, x );
            bq_writebyte( bq, x );
            bq_writebyte( bq, x );
            bq_writebyte( bq, x );
        }
    } while ( 1 );
}
void switcher2(DWORD arg)
{
    int x, cnt, i;
    do {
        rt_yield();
        cnt = bq_readcount( bq );
        if ( cnt == 0 ) cprintf(".");
        else for ( i = 0 ; i < cnt ; ++i ) {
            if ( bq_readbyte( bq , &x ))
                cprintf(" read %u \r\n", x );
        }
    } while ( 1 );
}

main()
{
    kdebug = 1;
    rt_init(100);
    bq = bq_alloc( 100 );
    cputs("starting...\r\n");
    peer = rt_newthread( switcher2, 2,4096, 0, "worker 2" );
    rt_newthread( switcher1, 1,4096, 0, "worker 1" );
    rt_sleep( 10000 );
}


