#include <rtos.h>
#include <emath.h>

/*------------------------------------------------------------------------*/

void test( char *s )
{
    char buffer[128];
    EM x;
    x = strtoem( s );
    cprintf("converting %s -> %s (internally stored as %lu)\n\r",
        s, emtostr( x, buffer ), x);
}


test2( char *a, char *b)
{
    char buffer[ 128 ], buffer2[128];

    /* demonstrates how to assign EM numbers from ASCII strings */
    EM x = strtoem( a );
    EM y = strtoem( b );

    /* show our x and y values */

    cprintf("x = %s, y = %s \r\n", emtostr( x, buffer ), emtostr(y, buffer2));

    /* conversion from EM back to long integer scaled by factor of 10 */
    cprintf("convert to long : emtol(x,10) = %lu\r\n", emtol( x, 10 ));

    cputs("Arithmetic Functions :\r\n");
    cprintf(" x + y = %s    ", emtostr( x + y , buffer ));
    cprintf(" x - y = %s\r\n", emtostr( x - y , buffer ));
    cprintf(" x y   = %s    ", emtostr( EM_MUL(x, y) , buffer ));
    cprintf(" x / y = %s\r\n", emtostr( EM_DIV(x,y) , buffer ));

    cprintf("Mathematical Functions\r\n");
    cprintf(" int(x) = %s\r\n", emtostr( EM_INT(x ), buffer ));
    cprintf(" round(x) = %s\r\n", emtostr( EM_ROUND(x ), buffer ));
    cprintf(" sqrt(x) = %s\r\n", emtostr( EM_SQR( x ), buffer ));
    cprintf(" log10(x) = %s\r\n", emtostr( EM_LOG10( x ), buffer ));
    cprintf(" ln(x) = %s\r\n", emtostr( EM_LN( x ), buffer ));
    cprintf(" 10^(x) = %s\r\n", emtostr( EM_POWER10( x ), buffer ));
    cprintf(" e^(x) = %s\r\n", emtostr( EM_EXP( x ), buffer ));
    cprintf(" x^y   = %s\r\n", emtostr( EM_POWER( x, y ), buffer ));
    cprintf(" cos(x) = %s\r\n", emtostr( EM_COS( x ), buffer ));
    cprintf(" sin(x) = %s\r\n", emtostr( EM_SIN( x ), buffer ));
    cprintf(" tan(x) = %s\r\n", emtostr( EM_TAN( x ), buffer ));
    cprintf(" asin(x) = %s\r\n", emtostr( EM_ASIN(x), buffer ));
    cprintf(" acos(x) = %s\r\n", emtostr( EM_ACOS(x), buffer ));
    cprintf(" atan(x) = %s\r\n", emtostr( EM_ATAN(x), buffer ));
    cprintf(" x -> %s radians   x -> %s degrees\r\n",
        emtostr( EM_RAD( x ), buffer ),
        emtostr( EM_DEG( x ), buffer2 ));
}

test3()
{
    EM x, y, r;
    long u, v;
    EM degree;
    EM fullcircle;

    clrscr();
    cputs("Drawing a circle... it will look like an elipse due to screen aspect ratio.");

    fullcircle = EM_ASSIGN( 360, 1 );    /* 360/1 = 360.0000 */
    r = EM_ASSIGN( 10, 1 );     /* r = 10/1 = 10.0000 */

    for ( degree = EM_ZERO ;
          degree < fullcircle ;
          degree= EM_ADD( degree, EM_ONE )) {

       /* x = r * sin( rad( degree ) ) */
       /* y = r * cos( rad( degree ) ) */
       x = EM_MUL( r, EM_SIN( EM_RAD( degree ) ) );
       y = EM_MUL( r, EM_COS( EM_RAD( degree ) ) );

       /* convert to integers, and add 60, 15 to roughly center on screen */
       u = emtol( EM_ROUND(x), 1 ) + 40;
       v = emtol( EM_ROUND(y), 1 ) + 15;

       gotoxy( u, v );
       cputs("*");
    }
    gotoxy( 1, 2 );
    puts("Press any key to continue...");
    getch();
    clrscr();

}


main(int argc, char **argv)
{
    char buffer[ 128];

    rt_init( 100 );

    if ( argc < 3 ) {
        test3();
        cputs("Here are some sample numbers:\r\n");
        test( "1.125" );
        test( "10.002" );
        test( "3.14159" );
        test( "32799.24");
        test( "-243.34");
        test( "-.05");
        cprintf(" pi = %s (%lu)   \r\n", emtostr( EM_PI, buffer ), EM_PI );

        /* demonstrates how to ASSIGN from fraction (numerator/denominator) */
        cprintf(" 314/100 = %s\r\n", emtostr(EM_ASSIGN(314,100), buffer ) );

        cputs("Run this program with two arguments (eg mathtest 2 3) and see results\r\n");
    } else {
        test2( argv[1] , argv[2] );
    }
}

