{: test that conformant array value parameters
   may not have file components }

{$d+}
program e130( output );

type
   recType = record
                i : integer;
                f : file of char;
             end;

var
   a : array[1..10] of recType;

{!!! error, value parameter with file components}
procedure test(aa : array[lo..hi : integer] of recType);
var
   aa1 : array[0..10] of integer;
   z   : 0..10;
begin
   z := lo;
   aa[z].i := 3;
   aa[hi].i := 3;
   writeln( 'error not detected:',
            'conformant array value parameter with file component' );
end;

procedure ok(var aa : array[lo..hi : integer] of recType);
var
   aa1 : array[0..10] of integer;
   z   : 0..10;
begin
   z := lo;
   aa[z].i := 3;
   aa[hi].i := 3;
   writeln( 'procedure ok success' );
end;

begin {e130}

   ok(a);     {ok, var parameter }
   test(a);   { !!! array of file components }

end. { e130 }

