{: test that assigning to a set outside its bounds causes a fatal error
   here we test bounds error at lower set boundary for set * vlist (with range)
}

{ this is ageneric test, many versions of this test will be built with
  cpp -D ARG1=ARG -D ARG2=(ARG+ADJ)
  for all combinatiopns of ARG & ADJ

ARG   -17 -16 -15 -1 0 2 15 16 17
ADJ   -1 -7 -8

}

{$d+}
program d222( output );

#if !defined ARG1 || ! defined ARG2
#error "ARG2 or ARG1 not defined"
#endif

const
   top = 40;
   lo  = ARG1;
   hi  = top;
   lo1 = lo;
   offset = ARG2;
var
   i  : integer;
   s0  : set of lo..hi;    {dst}
   s2  : set of -top..top; {src}

begin {d222}

   i := lo;                  {min element of s0}
   s2 := [i, i+4, hi-4, hi]; {this should be OK}

   writeln( 'INFO: s0 is [', lo:1, '..', hi:1, ']' );

   i := offset;
   s0 := [i .. i+4] * s2;  {OK}
   s2 := s2 + [i] - [lo];
   s0 := [i .. i+4, lo..lo] * s2;  {!!! assignment outside bounds}

   writeln('failed to detect set assign error');

end. { d222 }

