{: test that assigning to a set outside its bounds causes a fatal error
   here we test bounds error at upper set boundary for set *
}

{ this is ageneric test, many versions of this test will be built with
  cpp -D ARG1=ARG -D ARG2=(ARG+ADJ)
  for all combinatiopns of ARG & ADJ

ARG   -17 -16 -15 -1 0 2 15 16 17
ADJ   1 7 8 9 15 16

}

{$d+}
program d221( output );

#if !defined ARG1 || ! defined ARG2
#error "ARG2 or ARG1 not defined"
#endif
#if ARG2 < ARG1
#error "ARG2 must be >= than ARG1"
#endif

const
   top = 40;
   lo  = -top;
   hi  = ARG1;
   lo1 = lo;
   hi1 = ARG2;
   t   = lo1;
var
   i  : integer;
   s0  : set of lo..hi;    {dst}
   s1  : set of lo1..hi1;  {src}
   s2  : set of -top..top;  {src}

begin {d221}

   i := lo;
   s2 := [lo, lo+4, hi-4, hi]; {this should be OK}
   s1 := [hi+1] + s2;

   i := t;
   writeln( 'INFO: s0 is [', lo:1, '..', hi:1, '], s1 is [', lo1:1, '..', hi1:1, ']' );


   s0 := s2*s1;  {OK}
   s2 := s2 + [hi+1] - [hi];
   s0 := s2*s1;  {!!! assignment outside bounds}

   writeln('failed to detect set assign error');

end. { d221 }

