{: test that assigning to a set outside its bounds causes a fatal error
   here we test a range assigned to a set,
   vary the size and overlap of the range
}

{ this is ageneric test, many versions of this test will be built with
  cpp -D ARG1=ARG -D ARG2=(ARG+ADJ)
  for all combinatiopns of ARG & ADJ

ARG   -18 -11 4 11
ADJ   7

}

{$d+}
program d210( output );

#if !defined ARG1 || ! defined ARG2
#error "ARG2 or ARG1 not defined"
#endif
#if ARG2 < ARG1
#error "ARG2 must be >= than ARG1"
#endif

const
   lo  = -10;
   hi  = 10;
   lo1 = ARG1;
   hi1 = ARG2;
var
   i  : integer;
   s  : set of lo..hi;    {dst}

begin {d210}

   i := lo;
   s := [lo..lo+4, hi-4..hi]; {this should be OK}

   i := lo1;
   writeln( 'INFO: s is [', lo:1, '..', hi:1, '], range is [', i:1, '..', hi1:1, ']' );

   s := [hi1..i]; {should be OK}
   s := [i..hi1]; {!!! assignment outside bounds}

   writeln('failed to detect set assign error');

end. { d210 }

