{: test that assigning to a set outside its bounds causes a fatal error
   here we test various values where sets are disjoint,
   vary the size of src set
}

{ this is ageneric test, many versions of this test will be built with
  cpp -D ARG1=ARG -D ARG2=(ARG+ADJ)
  for all combinatiopns of ARG & ADJ

ARG   9 8 7 6 1 0 -1 -7 -8 -9 -15 -16 -17 -23 -24 -25
ADJ    0 1 2 7 8 9 15 16 17

}

{$d+}
program d206( output );

#if !defined ARG1 || ! defined ARG2
#error "ARG2 or ARG1 not defined"
#endif
#if ARG2 < ARG1
#error "ARG2 must be >= than ARG1"
#endif

const
   lo  = 27;
   hi  = 40;
   lo1 = ARG1; {varies -25 ..  +9}
   hi1 = ARG2; {varies -25 .. +26}
var
   i  : integer;
   s  : set of lo..hi;    {dst}
   s1 : set of lo1..hi1; {src}

begin {d206}

   s1 := [];
   s := s1; {this should be OK}

   i := (lo1 + hi1) div 2;
   writeln( 'INFO: s is [', lo:1, '..', hi:1, '], s1 is [', lo1:1, '..', hi1:1, '], test bit ', i:1 );

   s1 := [i];
   s := s1; {!!! assignment outside bounds}

   writeln('failed to detect set assign error');

end. { d206 }

