{: test that assigning to a set outside its bounds causes a fatal error
   here we test various values where sets overlap on the lower bound,
   lowest value of src set
}

{ this is ageneric test, many versions of this test will be built with
  cpp -D ARG1=ARG -D ARG2=(ARG+ADJ)
  for all combinatiopns of ARG & ADJ

ARG   -7 -8 -9 -15 -16 -17 -23 -24 -25 -31 -32 -33
ADJ    1 2 7 8 9 15 16 17

}

{$d+}
program d203( output );

#if !defined ARG1 || ! defined ARG2
#error "ARG2 or ARG1 not defined"
#endif
#if ARG2 <= ARG1
#error "ARG2 must be greater than ARG1"
#endif

const
   lo  = ARG2; {varies -32 .. +10}
   lo1 = ARG1;  {varies -33 .. -7}
var
   i  : integer;
   s  : set of lo..20;   {dst}
   s1 : set of lo1..10;  {src}

begin {d203}

   s1 := [lo..10];
   s := s1; {this should be OK}

   writeln( 'INFO: s is [', lo:1, '..20], s1 is [', lo1:1, '..10], test bit ', lo1:1 );

   s1 := [lo1..lo1+1];
   s := s1; {!!! assignment beyond lower bound}

   writeln('failed to detect set assign error');

end. { d203 }

