
{: test that assigning a packed record variant with an invalid tag value
   causes a fatal error }

{$d+,v+}
program d113( output );

type
   tinyInt = 0..9;
   colour  =  ( red, oramge, green );

var
   myRec0 :  array[1..9] of packed record
               case boolean of
                 true  : ( i: tinyInt );
                 false : ( c: colour);
               end; {record }
   myRec :  array[1..9] of packed record
               case t: boolean of
                 true  : ( i: tinyInt);
                 false : ( c: colour);
               end; {record }

   k: integer;

function side: integer;
begin
   side := k;
   k := k+1;
end; { side }

begin { d113 }

   { no tag in myRec0, so this is OK }
   k := 1;
   myRec0[side].c := red;
   if k <> 2 then
      writeln( '**** record access has side effects ****' );
   k := 1;
   if myRec0[side].c = red then
      write( 'c is red' )
   else
      writeln( ', colour is not red' );
   if k <> 2 then
      writeln( '**** record access has side effects ****' );
   k := 1;
   myRec0[side].i := 3;
   if k <> 2 then
      writeln( '**** record access has side effects ****' );
   k := 1;
   write( ', integer is ', myRec0[side].i );
   if k <> 2 then
      writeln( '**** record access has side effects ****' );
   k := 1;
   if myRec0[side].c = red then
      writeln( ', c is red' )
   else
      writeln( ', colour is not red' );

   if k <> 2 then
      writeln( '**** record access has side effects ****' );

   k := 1;
   myRec[side].t := true;  { access i varaint }
   if k <> 2 then
      writeln( '**** record access has side effects ****' );
   k := 1;
   myRec[side].i := 3;
   if k <> 2 then
      writeln( '**** record access has side effects ****' );
   k := 1;
   write( 'integer is ', myRec[side].i );
   if k <> 2 then
      writeln( '**** record access has side effects ****' );

   k := 1;
   myRec[side].t := false;  { access c varaint }
   if k <> 2 then
      writeln( '**** record access has side effects ****' );
   k := 1;
   myRec[side].c := green;
   if k <> 2 then
      writeln( '**** record access has side effects ****' );
   k := 1;
   if myRec[side].c = green then
      writeln( ', c is green' )
   else
      writeln( ', colour is not green' );
   if k <> 2 then
      writeln( '**** record access has side effects ****' );

   k := 1;
   myRec[side].i := 5;   { !!! incorrect tag/variant combo }

   writeln( 'use of invalid tag not detected' );
end. { d113 }

