{: test that a record variant with an invalid tag value as a var parameter
   causes a fatal error }

{$d+}
program d112( output );

var
   myRec0 :  array[1..9] of record
               case boolean of
                 true  : ( i: integer);
                 false : ( x: real);
               end; {record }
   myRec :  array[1..9] of record
               case t: boolean of
                 true  : ( i: integer);
                 false : ( x: real);
               end; {record }

   k: integer;

procedure p(var ai : integer);
begin
   ai := -1;
   writeln( 'ai is ', ai:1 );
end; { p }

function side: integer;
begin
   side := k;
   k := k+1;
end; { side }

begin { d112 }

   { no tag in myRec0, so this is OK }
   k := 1;
   p(myRec0[side].i);
   if k <> 2 then
      writeln( '**** record access has side effects ****' );
   k := 1;
   writeln( 'integer is ', myRec0[side].i );
   if k <> 2 then
      writeln( '**** record access has side effects ****' );
   k := 1;


   myRec[side].t := true;  { access i varaint }
   if k <> 2 then
      writeln( '**** record access has side effects ****' );
   k := 1;
   p(myRec[side].i);
   if k <> 2 then
      writeln( '**** record access has side effects ****' );
   k := 1;
   write( 'integer is ', myRec[side].i );
   if k <> 2 then
      writeln( '**** record access has side effects ****' );
   k := 1;

   myRec[side].t := false;  { access x varaint }
   if k <> 2 then
      writeln( '**** record access has side effects ****' );
   k := 1;
   myRec[side].x := 100.6;
   if k <> 2 then
      writeln( '**** record access has side effects ****' );
   k := 1;
   writeln( ', x is ', myRec[side].x:1:1 );
   if k <> 2 then
      writeln( '**** record access has side effects ****' );
   k := 1;

   p( myRec[side].i );  { !!! incorrect tag/variant combo }
   if k <> 2 then
      writeln( '**** record access has side effects ****' );

   writeln( 'use of invalid tag not detected' );
end. { d112 }

