{%%%%%%%%% Copyright (c) 2017 Trevor Blight All rights reserved. %%%%%%%%%

   test functions in p5x string library
}

program tstring(input, output);

#include "string.inc.pas"

{check reinclude  guard is present}
#include "string.inc.pas"

var
   s1, s2 : STRING(20);
   c      : char;
   i      : integer;
   x      : real;
   ok     : boolean;
   f      : text;

begin
   write('enter a string (up to ', strmax(s2):1, ' chars) ');
   readString(input, s2);
   writeln('you entered ''', s2, ''', ', strlen(s2):1, ' chars');

   s1 := 'this is string1';
   if strPos(s1, 'this') <> 1 then
      writeln('strPos failed at line ', __LINE__);
   if strPos(s1, 'is') <> 3 then
      writeln('strPos failed at line ', __LINE__);
   if strPos(s1, '1') <> strlen(s1) then
      writeln('strPos failed at line ', __LINE__);
   if strPos(s1, 'xyz') <> 0 then
      writeln('strPos failed at line ', __LINE__);
   if strPos(s1, s1) <> 1 then
      writeln('strPos failed at line ', __LINE__);
   if strPos(s1, 'this is string1x') <> 0 then
      writeln('strPos failed at line ', __LINE__);

   for i := 1 to strmax(s2) do begin
      c := succ('A',i-1);
      s2[i] := c;
      setStrLen(s2, i);
      writeln(s2);
      if s2[strlen(s2)] <> c then
         writeln('strLen/setStrLen failed at line ', __LINE__);
   end;

   str(s2, 1, 3, s1);
   if strPos(s1, 'ABC') <> 1 then begin
      writeln('strLen/setStrLen failed at line ', __LINE__);
      writeln('s1 is ''', s1, ''', s2 is ''', s2, ''', strPos(s1, ''ABC'') is ', strPos(s1, 'ABC'));
   end;
   if s1 <> 'ABC' then
      writeln('strLen/setStrLen failed at line ', __LINE__);

   str(s2, 2, 3, s1);
   if strPos(s1, 'BCD') <> 1 then
      writeln('strLen/setStrLen failed at line ', __LINE__);
   if s1 <> 'BCD' then
      writeln('strLen/setStrLen failed at line ', __LINE__);
   str(s2, strmax(s2)-2, 3, s1);
   if strPos(s1, 'RST') <> 1 then
      writeln('strLen/setStrLen failed at line ', __LINE__);
   if s1 <> 'RST' then
      writeln('strLen/setStrLen failed at line ', __LINE__);

   setstrlen(s2, 10);
   str(s2, 8, 3, s1);
   if strPos(s1, 'HIJ') <> 1 then
      writeln('strLen/setStrLen failed at line ', __LINE__);
   if s1 <> 'HIJ' then
      writeln('strLen/setStrLen failed at line ', __LINE__);
   str(s2, 9, 2, s1);
   if strPos(s1, 'IJ') <> 1 then
      writeln('strLen/setStrLen failed at line ', __LINE__);
   if s1 <> 'IJ' then
      writeln('strLen/setStrLen failed at line ', __LINE__);

   strAppend(s2, '123');
   if strLen(s2) <> 13 then
      writeln('strAppend failed at line ', __LINE__);
   if strPos(s2, '123') <> 11 then
      writeln('strAppend failed at line ', __LINE__);
   strAppend(s2, '4567890');
   if strLen(s2) <> 20 then
      writeln('strAppend failed at line ', __LINE__);
   if strPos(s2, '0') <> 20 then
      writeln('strAppend failed at line ', __LINE__);

   strdelete(s2, 11, 3);
   if strLen(s2) <> 17 then
      writeln('strDelete failed at line ', __LINE__);
   if strPos(s2, 'ABCDEFGHIJ4567890') <> 1 then
      writeln('strDelete failed at line ', __LINE__);
   if s2 <> 'ABCDEFGHIJ4567890' then
      writeln('strDelete failed at line ', __LINE__);

   strdelete(s2, 1, 3);
   if strLen(s2) <> 14 then
      writeln('strDelete failed at line ', __LINE__);
   if strPos(s2, 'DEFGHIJ4567890') <> 1 then
      writeln('strDelete failed at line ', __LINE__);
   if s2 <> 'DEFGHIJ4567890' then
      writeln('strDelete failed at line ', __LINE__);

   strdelete(s2, 12, 3);
   if strLen(s2) <> 11 then
      writeln('strDelete failed at line ', __LINE__);
   if strPos(s2, 'DEFGHIJ4567') <> 1 then
      writeln('strDelete failed at line ', __LINE__);
   if s2 <> 'DEFGHIJ4567' then
      writeln('strDelete failed at line ', __LINE__);
   strdelete(s2, 1, strLen(s2));
   if strLen(s2) <> 0 then
      writeln('strDelete failed at line ', __LINE__);

   s2 := '   123';
   strltrim(s2);
   if strlen(s2) <> 3 then
     writeln('strltrim failed at line ', __LINE__);
   if strPos(s2, '123') <> 1 then
      writeln('strltrim failed at line ', __LINE__);
   if s2 <> '123' then
      writeln('strltrim failed at line ', __LINE__);
   s2 := '';
   strltrim(s2);
   if strlen(s2) <> 0 then
      writeln('strltrim failed at line ', __LINE__);

   s2 := '123   ';
   strrtrim(s2);
   if strlen(s2) <> 3 then
      writeln('strrtrim failed at line ', __LINE__);
   if strPos(s2, '123') <> 1 then
      writeln('strrtrim failed at line ', __LINE__);
   if s2 <> '123' then
      writeln('strrtrim failed at line ', __LINE__);

   s2 := '';
   strrtrim(s2);
   if strlen(s2) <> 0 then
      writeln('strrtrim failed at line ', __LINE__);

   s1 := '';
   strInsert('12345', s1, 1);
   if strlen(s1) <> 5 then
     writeln('strInsert failed at line ', __LINE__);
   if strPos(s1, '12345') <> 1 then
      writeln('strInsert failed at line ', __LINE__);
   if s1 <> '12345' then
      writeln('strInsert failed at line ', __LINE__);

   strInsert('67890', s1, 6);
   if strlen(s1) <> 10 then
     writeln('strInsert failed at line ', __LINE__);
   if strPos(s1, '1234567890') <> 1 then
      writeln('strInsert failed at line ', __LINE__);
   if s1 <> '1234567890' then
      writeln('strInsert failed at line ', __LINE__);

   s2 := s1;
   strInsert('abcde', s1, 6);
   if strlen(s1) <> 15 then
     writeln('strInsert failed at line ', __LINE__);
   if strPos(s1, '12345abcde67890') <> 1 then
      writeln('strInsert failed at line ', __LINE__);
   if s1 <> '12345abcde67890' then
      writeln('strInsert failed at line ', __LINE__);

   s1 := s2;
   strInsert('abcde', s1, 1);
   if strlen(s1) <> 15 then
     writeln('strInsert failed at line ', __LINE__);
   if strPos(s1, 'abcde1234567890') <> 1 then
      writeln('strInsert failed at line ', __LINE__);
   if s1 <> 'abcde1234567890' then
      writeln('strInsert failed at line ', __LINE__);

   s1 := s2;
   strInsert('ABCDEFGHIJ', s1, 11);
   if strlen(s1) <> 20 then
     writeln('strInsert failed at line ', __LINE__);
   if strPos(s1, '1234567890ABCDEFGHIJ') <> 1 then
      writeln('strInsert failed at line ', __LINE__);
   if s1 <> '1234567890ABCDEFGHIJ' then
      writeln('strInsert failed at line ', __LINE__);

   s1 := s2;
   strInsert('ABCDEFGHIJ', s1, 1);
   if strlen(s1) <> 20 then
     writeln('strInsert failed at line ', __LINE__);
   if strPos(s1, 'ABCDEFGHIJ1234567890') <> 1 then
      writeln('strInsert failed at line ', __LINE__);
   if s1 <> 'ABCDEFGHIJ1234567890' then
      writeln('strInsert failed at line ', __LINE__);

   s1 := s2;
   strInsert('ABCDEFGHIJ', s1, 6);
   if strlen(s1) <> 20 then
     writeln('strInsert failed at line ', __LINE__);
   if strPos(s1, '12345ABCDEFGHIJ67890') <> 1 then
      writeln('strInsert failed at line ', __LINE__);
   if s1 <> '12345ABCDEFGHIJ67890' then
      writeln('strInsert failed at line ', __LINE__);

   s1 := '';
   strInsert('ABCDEFGHIJKLMNOPQRST', s1, 1);
   if strlen(s1) <> 20 then
     writeln('strInsert failed at line ', __LINE__);
   if strPos(s1, 'ABCDEFGHIJKLMNOPQRST') <> 1 then
      writeln('strInsert failed at line ', __LINE__);
   if s1 <> 'ABCDEFGHIJKLMNOPQRST' then
      writeln('strInsert failed at line ', __LINE__);

   write('appending '''' to ''', s1, '''');
   strAppend(s1, '');
   writeln(', s1 is now ''', s1, '''');

   x := 987654321;
   strwrnum(x, s1, 3, 8);
   if s1 <> 'AB 9.9e+08KLMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(9e8, s1, 3, -8);
   if s1 <> 'AB 9e+08  KLMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   x := x/10;
   strwrnum(x, s1, 3, 8);
   if s1 <> 'AB 9.9e+07KLMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   x := x/10;
   strwrnum(x, s1, 3, 8);
   if s1 <> 'AB 9876543KLMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   x := x/10;
   strwrnum(x, s1, 3, 8);
   if s1 <> 'AB  987654KLMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(x, s1, 3, -8);
   if s1 <> 'AB 987654 KLMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   x := x/10;
   strwrnum(x, s1, 3, 8);
   if s1 <> 'AB 98765.4KLMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   x := x/10;
   strwrnum(x, s1, 3, 8);
   if s1 <> 'AB 9876.54KLMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   x := x/10;
   strwrnum(x, s1, 3, 8);
   if s1 <> 'AB 987.654KLMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   x := x/10;
   strwrnum(x, s1, 3, 8);
   if s1 <> 'AB 98.7654KLMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   x := x/10;
   strwrnum(x, s1, 3, 8);
   if s1 <> 'AB 9.87654KLMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   x := x/10;
   strwrnum(x, s1, 3, 8);
   if s1 <> 'AB 0.98765KLMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   x := x/10;
   strwrnum(x, s1, 3, 8);
   if s1 <> 'AB 0.09877KLMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   x := x/10;
   strwrnum(x, s1, 3, 8);
   if s1 <> 'AB 0.00988KLMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   x := x/10;
   strwrnum(x, s1, 3, 8);
   if s1 <> 'AB 0.00099KLMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   x := x/10;
   strwrnum(x, s1, 3, 8);
   if s1 <> 'AB 9.9e-05KLMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   x := x/10;
   strwrnum(x, s1, 3, 8);
   if s1 <> 'AB 9.9e-06KLMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;

   s1 := 'ABCDEFGHIJKLMNOPQRST';
   strwrnum(0, s1, 3, 1);
   if s1 <> 'AB#DEFGHIJKLMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(1, s1, 3, 1);
   if s1 <> 'AB#DEFGHIJKLMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(0, s1, 3, 2);
   if s1 <> 'AB 0EFGHIJKLMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(1, s1, 3, 2);
   if s1 <> 'AB 1EFGHIJKLMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(1.5, s1, 3, 2);
   if s1 <> 'AB 2EFGHIJKLMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(10, s1, 3, 2);
   if s1 <> 'AB##EFGHIJKLMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(20, s1, 3, 2);
   if s1 <> 'AB##EFGHIJKLMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(0.5, s1, 3, 2);
   if s1 <> 'AB 1EFGHIJKLMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(9, s1, 3, 2);
   if s1 <> 'AB 9EFGHIJKLMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(9.5, s1, 3, 2);
   if s1 <> 'AB##EFGHIJKLMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(10, s1, 3, 2);
   if s1 <> 'AB##EFGHIJKLMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;


   strwrnum(0.1, s1, 3, 3);
   if s1 <> 'AB###FGHIJKLMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(0.1, s1, 3, 4);
   if s1 <> 'AB 0.1GHIJKLMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(0.01, s1, 3, 4);
   if s1 <> 'AB####GHIJKLMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(0.01, s1, 3, 5);
   if s1 <> 'AB 0.01HIJKLMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(0.001, s1, 3, 5);
   if s1 <> 'AB#####HIJKLMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(0.001, s1, 3, 6);
   if s1 <> 'AB 0.001IJKLMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(0.0001, s1, 3, 6);
   if s1 <> 'AB 1e-04IJKLMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;

   s1 := 'ABCDEFGHIJKLMNOPQRST';
   strwrnum(12345, s1, 3, 5);
   if s1 <> 'AB#####HIJKLMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(1234.5, s1, 3, 6);
   if s1 <> 'AB  1235IJKLMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(12345, s1, 3, 6);
   if s1 <> 'AB 12345IJKLMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(123456, s1, 3, 6);
//   writeln('s1 is now ''', s1, '''');
   if s1 <> 'AB 1e+05IJKLMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(1234, s1, 3, 6);
   if s1 <> 'AB  1234IJKLMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(1234, s1, 3, -6);
   if s1 <> 'AB 1234 IJKLMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;


   s1 := 'abcdef';
   strwrnum(1234, s1, 3, 8);
   if s1 <> 'ab    1234' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   s1 := 'abcdef';
   strwrnum(1234, s1, 3, -8);
   if s1 <> 'ab 1234   ' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   s1 := 'abcdef';
   strwrnum(1234567890, s1, 3, -8);
   if s1 <> 'ab 1.2e+09' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;

   s1 := '';
   strwrnum(1234567890, s1, 1, 10);
   if s1 <> ' 1.235e+09' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(1234567890, s1, 1, 10);
   if s1 <> ' 1.235e+09' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;

   s1 := 'ABCDEFGHIJKLMNOPQRST';
   strwrnum(1234567890, s1, 11, 10);
   if s1 <> 'ABCDEFGHIJ 1.235e+09' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(123456789, s1, 11, 10);
   if s1 <> 'ABCDEFGHIJ 123456789' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;

   s1 := 'ABCDEFGHIJKLMNOPQRST';
   strwrnum(0.9, s1, 11, 2);
   if s1 <> 'ABCDEFGHIJ 1MNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(2.1, s1, 11, 2);
   if s1 <> 'ABCDEFGHIJ 2MNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(2.1, s1, 11, 3);
   if s1 <> 'ABCDEFGHIJ  2NOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(32.1, s1, 11, 3);
   if s1 <> 'ABCDEFGHIJ 32NOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(432.1, s1, 11, 4);
   if s1 <> 'ABCDEFGHIJ 432OPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(5432.1, s1, 11, 5);
   if s1 <> 'ABCDEFGHIJ 5432PQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(10000, s1, 11, 5);
   if s1 <> 'ABCDEFGHIJ#####PQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;

   s1 := 'ABCDEFGHIJKLMNOPQRST';
   strwrnum(9999, s1, 11, 4);
   if s1 <> 'ABCDEFGHIJ####OPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(9999, s1, 11, 5);
   if s1 <> 'ABCDEFGHIJ 9999PQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(9999.9, s1, 11, 5);
   if s1 <> 'ABCDEFGHIJ#####PQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(9999, s1, 11, 6);
   if s1 <> 'ABCDEFGHIJ  9999QRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(9999.9, s1, 11, 6);
   if s1 <> 'ABCDEFGHIJ 10000QRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(9999.9, s1, 11, 7);
   if s1 <> 'ABCDEFGHIJ 9999.9RST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;

   s1 := 'ABCDEFGHIJKLMNOPQRST';
   strwrnum(99.9, s1, 11, 4);
   if s1 <> 'ABCDEFGHIJ 100OPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(100, s1, 11, 4);
   if s1 <> 'ABCDEFGHIJ 100OPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(100, s1, 11, -4);
   if s1 <> 'ABCDEFGHIJ 100OPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(100, s1, 11, 4);
   if s1 <> 'ABCDEFGHIJ 100OPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(100, s1, 11, -4);
   if s1 <> 'ABCDEFGHIJ 100OPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(100.1, s1, 11, 4);
   if s1 <> 'ABCDEFGHIJ 100OPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(100.1, s1, 11, -4);
   if s1 <> 'ABCDEFGHIJ 100OPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(100, s1, 11, -5);
   if s1 <> 'ABCDEFGHIJ 100 PQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(-100, s1, 11, -5);
   if s1 <> 'ABCDEFGHIJ-100 PQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(100.1, s1, 11, -5);
   if s1 <> 'ABCDEFGHIJ 100 PQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(99.9, s1, 11, 5);
   if s1 <> 'ABCDEFGHIJ 99.9PQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;

   s1 := 'ABCDEFGHIJKLMNOPQRST';
   strwrnum(5432.1, s1, 11, 1);
   if s1 <> 'ABCDEFGHIJ#LMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(5432.1, s1, 11, 2);
   if s1 <> 'ABCDEFGHIJ##MNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(5432.1, s1, 11, 3);
   if s1 <> 'ABCDEFGHIJ###NOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(5432.1, s1, 11, 4);
   if s1 <> 'ABCDEFGHIJ####OPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(5432.1, s1, 11, 5);
   if s1 <> 'ABCDEFGHIJ 5432PQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(5432.1, s1, 11, 6);
   if s1 <> 'ABCDEFGHIJ  5432QRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(5432.1, s1, 11, 7);
   if s1 <> 'ABCDEFGHIJ 5432.1RST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(5432.1, s1, 11, 8);
   if s1 <> 'ABCDEFGHIJ  5432.1ST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;

   s1 := 'ABCDEFGHIJKLMNOPQRST';
   strwrnum(0, s1, 11, 1);
   if s1 <> 'ABCDEFGHIJ#LMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(0, s1, 11, 2);
   if s1 <> 'ABCDEFGHIJ 0MNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(0, s1, 11, -2);
   if s1 <> 'ABCDEFGHIJ 0MNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(0, s1, 11, 3);
   if s1 <> 'ABCDEFGHIJ  0NOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(0, s1, 11, -3);
   if s1 <> 'ABCDEFGHIJ 0 NOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;

   s1 := 'ABCDEFGHIJKLMNOPQRST';
//   writeln('line ', __LINE__, ', s1 is ''', s1, '''');
   strwrnum(0.1, s1, 11, 1);
   if s1 <> 'ABCDEFGHIJ#LMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(0.1, s1, 11, 2);
   if s1 <> 'ABCDEFGHIJ##MNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(0.1, s1, 11, 3);
   if s1 <> 'ABCDEFGHIJ###NOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(-0.1, s1, 11, 4);
   if s1 <> 'ABCDEFGHIJ-0.1OPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(0.1, s1, 11, -5);
   if s1 <> 'ABCDEFGHIJ 0.1 PQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;

   s1 := 'ABCDEFGHIJKLMNOPQRST';
   writeln('line ', __LINE__, ', s1 is ''', s1, ''', ');
   strwrnum(0.05, s1, 11, 1);
   if s1 <> 'ABCDEFGHIJ#LMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(0.05, s1, 11, 2);
   if s1 <> 'ABCDEFGHIJ##MNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(0.05, s1, 11, 3);
   if s1 <> 'ABCDEFGHIJ###NOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(-0.15, s1, 11, 4);
   if s1 <> 'ABCDEFGHIJ-0.1OPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(0.051, s1, 11, -5);
   if s1 <> 'ABCDEFGHIJ 0.05PQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(0.05, s1, 11, -6);
   if s1 <> 'ABCDEFGHIJ 0.05 QRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;

   s1 := 'ABCDEFGHIJKLMNOPQRST';
   strwrnum(0.01, s1, 11, 1);
   if s1 <> 'ABCDEFGHIJ#LMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(0.01, s1, 11, 2);
   if s1 <> 'ABCDEFGHIJ##MNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(0.01, s1, 11, 3);
   if s1 <> 'ABCDEFGHIJ###NOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(-0.01, s1, 11, 4);
   if s1 <> 'ABCDEFGHIJ####OPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(0.01, s1, 11, -5);
   if s1 <> 'ABCDEFGHIJ 0.01PQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(-0.01, s1, 11, -6);
   if s1 <> 'ABCDEFGHIJ-0.01 QRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;

   s1 := 'ABCDEFGHIJKLMNOPQRST';
   strwrnum(0.001, s1, 11, 1);
   if s1 <> 'ABCDEFGHIJ#LMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(0.001, s1, 11, 2);
   if s1 <> 'ABCDEFGHIJ##MNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(0.001, s1, 11, 3);
   if s1 <> 'ABCDEFGHIJ###NOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(-0.001, s1, 11, 4);
   if s1 <> 'ABCDEFGHIJ####OPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(0.001, s1, 11, -5);
   if s1 <> 'ABCDEFGHIJ#####PQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(-0.001, s1, 11, -6);
   if s1 <> 'ABCDEFGHIJ-0.001QRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(-0.001, s1, 11, 7);
   if s1 <> 'ABCDEFGHIJ -0.001RST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;

   s1 := 'ABCDEFGHIJKLMNOPQRST';
   strwrnum(0.0001, s1, 11, 1);
   if s1 <> 'ABCDEFGHIJ#LMNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(0.0001, s1, 11, 2);
   if s1 <> 'ABCDEFGHIJ##MNOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(0.0001, s1, 11, 3);
   if s1 <> 'ABCDEFGHIJ###NOPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(-0.0001, s1, 11, 4);
   if s1 <> 'ABCDEFGHIJ####OPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(0.0001, s1, 11, -5);
   if s1 <> 'ABCDEFGHIJ#####PQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(-0.00015, s1, 11, -6);
   if s1 <> 'ABCDEFGHIJ-1e-04QRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(-0.00025, s1, 11, 7);
   if s1 <> 'ABCDEFGHIJ -3e-04RST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(0.00015, s1, 11, -8);
   if s1 <> 'ABCDEFGHIJ 0.00015ST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(0.000155, s1, 11, 9);
   if s1 <> 'ABCDEFGHIJ 0.000155T' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;

   s1 := 'ABCDEFGHIJKLMNOPQRST';
   strwrnum(9.4, s1, 11, 4);
   if s1 <> 'ABCDEFGHIJ 9.4OPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(9.6, s1, 11, 4);
   if s1 <> 'ABCDEFGHIJ 9.6OPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(10, s1, 11, 4);
   if s1 <> 'ABCDEFGHIJ  10OPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;
   strwrnum(10.1, s1, 11, 4);
   if s1 <> 'ABCDEFGHIJ  10OPQRST' then begin
      write('s1 is ''', s1, ''', ');
      writeln('strwrnum failed at line ', __LINE__);
   end;

{ strval() tests }

   strval(s1, 10, x, ok);
   if ok then begin
      write('expcted invalid x, s1 is ''', s1, ''', ');
      writeln('strval failed at line ', __LINE__);
   end;

   strval(s1, 11, x, ok);
   if not ok then begin
      write('expcted valid x, s1 is ''', s1, ''', ');
      writeln('strval failed at line ', __LINE__);
   end
   else if x <> 10 then begin
      write('expcted x = 10, x is ''', x, ''', ');
      writeln('strval failed at line ', __LINE__);
   end;

   strval(s1, 13, x, ok);
   if not ok then begin
      write('expcted valid x, s1 is ''', s1, ''', ');
      writeln('strval failed at line ', __LINE__);
   end
   else if x <> 10 then begin
      write('expcted x = 10, x is ''', x, ''', ');
      writeln('strval failed at line ', __LINE__);
   end;

   s1 := 'abcd123efgh';
   strval(s1, 5, x, ok);
   if not ok then begin
      write('expcted valid x, s1 is ''', s1, ''', ');
      writeln('strval failed at line ', __LINE__);
   end
   else if x <> 123 then begin
      write('expcted x = 123, x is ''', x, ''', ');
      writeln('strval failed at line ', __LINE__);
   end;

   strval(s1, 6, x, ok);
   if not ok then begin
      write('expcted valid x, s1 is ''', s1, ''', ');
      writeln('strval failed at line ', __LINE__);
   end
   else if x <> 23 then begin
      write('expcted x = 23, x is ''', x, ''', ');
      writeln('strval failed at line ', __LINE__);
   end;

   strval(s1, 7, x, ok);
   if not ok then begin
      write('expcted valid x, s1 is ''', s1, ''', ');
      writeln('strval failed at line ', __LINE__);
   end
   else if x <> 3 then begin
      write('expcted x = 3, x is ''', x, ''', ');
      writeln('strval failed at line ', __LINE__);
   end;

   strval(s1, 4, x, ok);
   if ok then begin
      write('expcted invalid x, s1 is ''', s1, ''', ');
      writeln('strval failed at line ', __LINE__);
   end;

   strval(' 123.5', 1, x, ok);
   if not ok then begin
      write('expcted valid x, s1 is ''', s1, ''', ');
      writeln('strval failed at line ', __LINE__);
   end
   else if x <> 123.5 then begin
   write('expcted x = 123.5, x is ''', x, ''', ');
      writeln('strval failed at line ', __LINE__);
   end;

   strval(' +123.5  ', 1, x, ok);
   if not ok then begin
      write('expcted valid x, s1 is ''', s1, ''', ');
      writeln('strval failed at line ', __LINE__);
   end
   else if x <> 123.5 then begin
   write('expcted x = 123.5, x is ''', x, ''', ');
      writeln('strval failed at line ', __LINE__);
   end;

   strval(' -123.5  ', 1, x, ok);
   if not ok then begin
      write('expcted valid x, s1 is ''', s1, ''', ');
      writeln('strval failed at line ', __LINE__);
   end
   else if x <> -123.5 then begin
   write('expcted x = 123.5, x is ''', x, ''', ');
      writeln('strval failed at line ', __LINE__);
   end;

   strval('123.5', 1, x, ok);
   if not ok then begin
      write('expcted valid x, s1 is ''', s1, ''', ');
      writeln('strval failed at line ', __LINE__);
   end
   else if x <> 123.5 then begin
   write('expcted x = 123.5, x is ''', x, ''', ');
      writeln('strval failed at line ', __LINE__);
   end;

   strval('+123.5  ', 1, x, ok);
   if not ok then begin
      write('expcted valid x, s1 is ''', s1, ''', ');
      writeln('strval failed at line ', __LINE__);
   end
   else if x <> 123.5 then begin
   write('expcted x = 123.5, x is ''', x, ''', ');
      writeln('strval failed at line ', __LINE__);
   end;

   strval('-123.5  ', 1, x, ok);
   if not ok then begin
      write('expcted valid x, s1 is ''', s1, ''', ');
      writeln('strval failed at line ', __LINE__);
   end
   else if x <> -123.5 then begin
   write('expcted x = 123.5, x is ''', x, ''', ');
      writeln('strval failed at line ', __LINE__);
   end;

   strval(' -132.5e-1  ', 1, x, ok);
   if not ok then begin
      write('expcted valid x, s1 is ''', s1, ''', ');
      writeln('strval failed at line ', __LINE__);
   end
   else if x <> -13.25 then begin
   write('expcted x = -13.25, x is ''', x, ''', ');
      writeln('strval failed at line ', __LINE__);
   end;

   strval('.5e1', 1, x, ok);
   if not ok then begin
      write('expcted valid x, s1 is ''', s1, ''', ');
      writeln('strval failed at line ', __LINE__);
   end
   else if x <> 5 then begin
   write('expcted x = 5, x is ''', x, ''', ');
      writeln('strval failed at line ', __LINE__);
   end;

   strval(' .5e+1  ', 1, x, ok);
   if not ok then begin
      write('expcted valid x, s1 is ''', s1, ''', ');
      writeln('strval failed at line ', __LINE__);
   end
   else if x <> 5 then begin
      write('expcted x = 5, x is ''', x, ''', ');
      writeln('strval failed at line ', __LINE__);
   end;


{ strcmp() tests }

   if strCompare('123', '1234') <> -1 then begin
      writeln('strcmp failed at line ', __LINE__);
   end;

   if strCompare('123', '1243') <> -1 then begin
      writeln('strcmp failed at line ', __LINE__);
   end;

   if strCompare('123', '1223') <> 1 then begin
      writeln('strcmp failed at line ', __LINE__);
   end;

   if strCompare('1234', '123') <> 1 then begin
      writeln('strcmp failed at line ', __LINE__);
   end;

   if strCompare('1243', '123') <> 1 then begin
      writeln('strcmp failed at line ', __LINE__);
   end;

   if strCompare('1223', '123') <> -1 then begin
      writeln('strcmp failed at line ', __LINE__);
   end;

   if strCompare('1234', '1234') <> 0 then begin
      writeln('strcmp failed at line ', __LINE__);
   end;

   if strCompare('1234', '1243') <> -1 then begin
      writeln('strcmp failed at line ', __LINE__);
   end;

   if strCompare('1243', '1234') <> 1 then begin
      writeln('strcmp failed at line ', __LINE__);
   end;


   {readstring tests}
   s1 := 'abcdef';
   s2 := '    UVWXYZ';
   rewrite(f);
   writeln(f, s1);
   writeln(f, s2);
   reset(f);
   readString(f, s1);
   if strCompare(s1, 'abcdef') <> 0 then begin
      writeln('readString failed at line ', __LINE__);
   end;
   readString(f, s1);
   strltrim(s2);
   if strCompare(s1, s2) <> 0 then begin
      writeln('readString failed at line ', __LINE__);
   end;

   {upcase & downcase}
   if toupper('a') <> 'A' then begin
      writeln('toupper failed at line ', __LINE__);
   end;
   if toupper('z') <> 'Z' then begin
      writeln('toupper failed at line ', __LINE__);
   end;

   if toupper('A') <> 'A' then begin
      writeln('toupper failed at line ', __LINE__);
   end;
   if toupper(' ') <> ' ' then begin
      writeln('toupper failed at line ', __LINE__);
   end;
   if toupper(pred('a')) <> pred('a') then begin
      writeln('toupper failed at line ', __LINE__);
   end;
   if toupper(succ('z')) <> succ('z') then begin
      writeln('toupper failed at line ', __LINE__);
   end;

   if tolower('A') <> 'a' then begin
      writeln('tolower failed at line ', __LINE__);
   end;
   if tolower('Z') <> 'z' then begin
      writeln('tolower failed at line ', __LINE__);
   end;

   if tolower('a') <> 'a' then begin
      writeln('tolower failed at line ', __LINE__);
   end;
   if tolower(' ') <> ' ' then begin
      writeln('tolower failed at line ', __LINE__);
   end;
   if tolower(pred('A')) <> pred('A') then begin
      writeln('tolower failed at line ', __LINE__);
   end;
   if tolower(succ('Z')) <> succ('Z') then begin
      writeln('tolower failed at line ', __LINE__);
   end;

   for i := 0 to 255 do begin
      if (not (chr(i) in ['a'..'z'])) and (toupper(tolower(chr(i))) <> chr(i)) then begin
         writeln('toupper(tolower(', chr(i), ')) failed at line ', __LINE__);
      end;
   end;

   for c := chr(0) to chr(255) do begin
      if (not (c in ['A'..'Z'])) and (tolower(toupper(c)) <> c) then begin
         writeln('tolower(toupper(', c, ') failed at line ', __LINE__);
      end;
   end;


   writeln('end of string tests');

   {TODO: check 100*xlim }
{
TODO:
   test with random numbers,
   x := rand /100
   wid := 9 - rand mod 18
   make val() into a strrdnum function
   need to check if it doesn't fit, or put in numbers that will fit??
}

end.


{%%%%%%%%%%%%%%%%%%%%%%%%%%%%% end of tstring.pas %%%%%%%%%%%%%%%%%%%%%%%%%%%%%}
