{: test that constant expression overflow causes a compilation error }

program e1061( output );

type
   colour = ( black, brown, red, orange, yellow, green, blue, violet, grey, white);

const
   m1   = maxint-1;
   m2   = -maxint + 1;

   { find sqrt maxint by newton's method ...}
   r0 = 32767;
   r1 = (r0 + maxint div r0) div 2;
   r2 = (r1 + maxint div r1) div 2;
   r3 = (r2 + maxint div r2) div 2;
   r4 = (r3 + maxint div r3) div 2;
   r5 = (r4 + maxint div r4) div 2;
   r6 = (r5 + maxint div r5) div 2;
   r7 = (r6 + maxint div r6) div 2;
   r8 = (r7 + maxint div r7) div 2;
   r9 = (r8 + maxint div r8) div 2;
   r10 = (r9 + maxint div r9) div 2;
   r11 = (r10 + maxint div r10) div 2;
   r12 = (r11 + maxint div r11) div 2;
   r13 = (r12 + maxint div r12) div 2;
   r14 = (r13 + maxint div r13) div 2;
   r15 = (r14 + maxint div r14) div 2;
   r16 = (r15 + maxint div r15) div 2;
   r17 = (r16 + maxint div r16) div 2;
   r18 = (r17 + maxint div r17) div 2;
   r19 = (r18 + maxint div r18) div 2;
   r20 = (r19 + maxint div r19) div 2;
   r21 = (r20 + maxint div r20) div 2;
   r22 = (r21 + maxint div r21) div 2;
   r23 = (r22 + maxint div r22) div 2;
   r24 = (r23 + maxint div r23) div 2;
   r25 = (r24 + maxint div r24) div 2;
   r26 = (r25 + maxint div r25) div 2;
   r27 = (r26 + maxint div r26) div 2;
   r28 = (r27 + maxint div r27) div 2;
   r29 = (r28 + maxint div r28) div 2;
   r30 = (r29 + maxint div r29) div 2;  {= sqrt(maxint) +/- d, 0<=d<1}

   {if the solution oscillates, r29 & r30 will be above & below sqrt(maxint)}
   csm = (r30 + r29 - abs(r30 - r29)) div 2;  {csm = min(r29,r30)}


   cp01 = m1+1;          {OK}
   cp11 = m1+2;          {!!! overflow }

   cp02 = m2 + (-1);     {OK}
   cp12 = m2 + (-2);     {!!! underflow}

   cp21 = 1+m1;          {OK}
   cp31 = 2+m1;          {!!! overflow }

   cp22 = (-1) + m2;     {OK}
   cp32 = (-2) + m2;     {!!! underflow}


   cm01 = m1 - (-1);     {OK}
   cm11 = m1 - (-2);     {!!! overflow }

   cm02 = m2 - 1;        {OK}
   cm12 = m2 - 2;        {!!! underflow}

   cm21 = 1 - m2;        {OK}
   cm31 = 2 - m2;        {!!! overflow }

   cm22 = (-1) - m1;     {OK}
   cm32 = (-2) - m1;     {!!! underflow}

   cd01 = maxint div 2;  {OK}
   cd11 = 1 div 0;       {!!! division by zero error}

   co01 = maxint mod 2;  {OK}
   co11 = 1 mod 0;       {!!! division by zero error}

   cx01 = cd01 * 2;      {OK}
   cx11 = (cd01+1) * 2;  {!!! overflow }

   cx21 = -cd01 * 2;      {OK}
   cx31 = (-cd01-1) * 2;  {!!! underflow }

   cc00 = ord(maxchar);
   cc01 = chr(cc00);      {OK}
   cc11 = chr(cc00+1);    {!!! overflow }

   cc21 = chr(0);         {OK}
   cc31 = chr(-1);        {!!! underflow }

   csq0 = sqr(csm);    {OK}
   csq1 = sqr(csm+1);  {!!! overflow}

   csq2 = sqr(-csm);    {OK}
   csq3 = sqr(-csm-1);  {!!! overflow}

var
   e : colour;
   i,n,m : integer;
   s : packed array[1..20] of char;

begin { e1061 }

   e := black;
   n := 2;

   writeln( 'r0 is ', r0:1 );
   writeln( 'r1 is ', r1:1 );
   writeln( 'r2 is ', r2:1 );
   writeln( 'r3 is ', r3:1 );
   writeln( 'r4 is ', r4:1 );
   writeln( 'r5 is ', r5:1 );
   writeln( 'r6 is ', r6:1 );

   writeln( 'r7 is ', r7:1 );
   writeln( 'r8 is ', r8:1 );
   writeln( 'r9 is ', r9:1 );
   writeln( 'r10 is ', r10:1 );
   writeln( 'r11 is ', r11:1 );
   writeln( 'r12 is ', r12:1 );
   writeln( 'r13 is ', r13:1 );
   writeln( 'r14 is ', r14:1 );
   writeln( 'r15 is ', r15:1 );
   writeln( 'r16 is ', r16:1 );
   writeln( 'r17 is ', r17:1 );
   writeln( 'r18 is ', r18:1 );
   writeln( 'r19 is ', r19:1 );
   writeln( 'r20 is ', r20:1 );
   writeln( 'r21 is ', r21:1 );
   writeln( 'r22 is ', r22:1 );
   writeln( 'r23 is ', r23:1 );
   writeln( 'r24 is ', r24:1 );
   writeln( 'r25 is ', r25:1 );
   writeln( 'r26 is ', r26:1 );
   writeln( 'r27 is ', r27:1 );
   writeln( 'r28 is ', r28:1 );
   writeln( 'r29 is ', r29:1 );
   writeln( 'r30 is ', r30:1 );

   n := 32767;
   m := maxint;
   writeln( 'm is ', m:1, ', sqrt m is ', sqrt(m):1:2 );
   for i := 1 to 26 do begin
      writeln( 'i is ', i:1, ', n is ', n:1{, ', sqr(n) is ', sqr(n):1} );
      n := (n + m div n) div 2;
   end;

   writeln( 'constant expression overflow error not detected' );
end. { e1061 }

