{: test a compilation error occurs when a file component is passed
   as a value parameter }

{$d+}
program e031( output );

type
   fileRec  =  record
                  a : integer;
                  case b: boolean of
                    true  : ( f : text; );
                    false : ( x : real; );
               end;

var
   farray : array[1..3,1..3] of fileRec;


{ verify that a file can be passed into a function as a var param }
{ !!!    -----------v---- value parameter with a file component ---------v----  }
procedure checkFile(aa : array[a..b: integer] of array[c..d: integer] of fileRec );
var i,j,z :  integer;
begin
   for i := a to b do for j := c to d do begin
      with aa[i,j] do begin
         b := true;
         rewrite(f);
         a := 100*i +j;
         writeln(f,a);
      end;
   end;
   for i := a to b do for j := c to d do begin
      with aa[i,j] do begin
         reset(f);
         read(f,z);
         if z <> a then begin
            writeln( 'file arg test failed' );
         end;
      end;
   end;
end; { checkFile }



begin {e031}

   checkFile(farray );
   writeln( 'fails: file component as value parameter error not detected' );

end. {e031}

