{: test that a record variant with an invalid tag value as a var parameter
   causes a fatal error }

{$d+}
program d122( output );

var
   w0 : record
          myRec0 :  array[1..9] of record
               case boolean of
                 true  : ( i: integer);
                 false : ( x: real);
               end; {record }
        end;

   w1 : record
          myRec :  array[1..9] of record
               case t: boolean of
                 true  : ( i: integer);
                 false : ( x: real);
               end; {record }
        end;

   k: integer;

procedure p(var ai : integer);
begin
   ai := -1;
   writeln( 'ai is ', ai:1 );
end; { p }

function side: integer;
begin
   side := k;
   k := k+1;
end; { side }

begin { d122 }

   { no tag in myRec0, so this is OK }
   with w0 do begin
      k := 1;
      p(myRec0[side].i);
      if k <> 2 then
         writeln( '**** record access has side effects ****' );
      k := 1;
      writeln( 'integer is ', myRec0[side].i );
      if k <> 2 then
         writeln( '**** record access has side effects ****' );
   end;

   with w1 do begin
      k := 1;
      myRec[side].t := true;  { access i varaint }
      if k <> 2 then
         writeln( '**** record access has side effects ****' );
      k := 1;
      p(myRec[side].i);
      if k <> 2 then
         writeln( '**** record access has side effects ****' );
      k := 1;
      write( 'integer is ', myRec[side].i );
      if k <> 2 then
         writeln( '**** record access has side effects ****' );
      k := 1;

      myRec[side].t := false;  { access x varaint }
      if k <> 2 then
         writeln( '**** record access has side effects ****' );
      k := 1;
      myRec[side].x := 100.6;
      if k <> 2 then
         writeln( '**** record access has side effects ****' );
      k := 1;
      writeln( ', x is ', myRec[side].x:1:1 );
      if k <> 2 then
         writeln( '**** record access has side effects ****' );
      k := 1;

      p( myRec[side].i );  { !!! incorrect tag/variant combo }
      if k <> 2 then
         writeln( '**** record access has side effects ****' );
   end;

   writeln( 'use of invalid tag not detected' );
end. { d122 }

