
{: test that accessing a record variant with an invalid tag value
   causes a fatal error }

{$d+,v+}
program d121( output );

var
   w0 : record
          myRec0 :  array[1..9] of record
            case integer of
              1,2,3  : ( i: integer);
              0 : ( x: real);
            end; {record }
        end; {record}

   w1 : record
          myRec :  array[1..9] of record
            case t: integer of
              1,2,3  : ( i: integer);
              0 : ( x: real);
            end; {record }
        end; {record}


   k: integer;

function side: integer;
begin
   side := k;
   k := k+1;
end; { side }

begin { d121 }

   { no tag in myRec0, so this is OK }
   with w0 do begin
      k := 1;
      myRec0[side].x := 100.6;
      if k <> 2 then
         writeln( '**** record access has side effects ****' );
      k := 1;
      write( 'x is ', myRec0[side].x:1:1 );
      if k <> 2 then
         writeln( '**** record access has side effects ****' );
      k := 1;
      myRec0[side].i := -1;
      if k <> 2 then
         writeln( '**** record access has side effects ****' );
      k := 1;
      write( ', integer is ', myRec0[side].i );
      if k <> 2 then
         writeln( '**** record access has side effects ****' );
      k := 1;
      writeln( ', x is ', myRec0[side].x:1:1 );
      if k <> 2 then
         writeln( '**** record access has side effects ****' );
      k := 1;
   end;

   with w1 do begin
      myRec[side].t := 2;  { access i varaint }
      if k <> 2 then
         writeln( '**** record access has side effects ****' );
      k := 1;
      myRec[side].i := -1;
      if k <> 2 then
         writeln( '**** record access has side effects ****' );
      k := 1;
      write( 'integer is ', myRec[side].i );
      if k <> 2 then
         writeln( '**** record access has side effects ****' );
      k := 1;

      myRec[side].t := 0;  { access x varaint }
      if k <> 2 then
         writeln( '**** record access has side effects ****' );
      k := 1;
      myRec[side].x := 100.6;
      if k <> 2 then
         writeln( '**** record access has side effects ****' );
      k := 1;
      writeln( ', x is ', myRec[side].x:1:1 );
      if k <> 2 then
         writeln( '**** record access has side effects ****' );
      k := 1;

      write( 'integer is ', myRec[side].i ); { !!! incorrect tag/variant combo }
      if k <> 2 then
         writeln( '**** record access has side effects ****' );
   end;

   writeln( 'use of invalid tag not detected' );
end. { d121 }

