
{: test that assigning a record variant with an invalid tag value
   causes a fatal error }

{$d+,v+}
program d115( output );

var
   myRec :  record
               case t1: boolean of
                 true  : ( case t2: boolean of
                               true: (i1: integer);
                               false: (c1: char);
                          );
                 false : ( x: real);
               end; {record }
begin { d115 }


   myRec.t1 := true;
   myRec.t2 := true;  { access i1 varaint }

   myRec.i1 := -1;
   write( 'integer is ', myRec.i1 );

   myRec.t2 := false;
   myRec.c1 := 'a';
   write( ', c1 is ', myRec.c1 );


   myRec.t1 := false;  { access x varaint }

   { this is incorrect, but is detected only if all tags are checked
     t2 has not been overwritten, so if only tag t2 is examined,
     it will (accidently) appear correct
   }
   myRec.c1 := 'z';   { !!! incorrect tag/variant combo }


   myRec.x := 100.6;   { this should overwrite t2 }
   writeln( ', x is ', myRec.x:1:1 );

   myRec.c1 := 'z';   { !!! incorrect tag/variant combo }

   writeln( 'use of invalid tag not detected' );
end. { d115 }

