{: test that exp(y*ln(x)) causes a fatal error if x < 0
Note:z := exp(y*ln(0)) is mathematically valid, (z == 1 iff y is 0, z == 0 otherwise),
      so allow x to be 0 in this test
}

{$d+}
program d089( output );

var
   e,k : real;

function side : real;
begin
   side := k;
   k := k+1;
end;
begin {d089}

   k := 1;
   writeln( 'exp(0.5*ln(1)) is ', exp(0.5*ln(side)):1:2);
   if k <> 2 then
      writeln( 'exp(y*ln(x)) for debug has side effects' );

   k := 1;
   writeln( 'exp(0.5*ln(1)) is ', exp(0.5*ln(side)):1:2);
   if k <> 2 then
      writeln( 'exp(y*ln(x)) for debug has side effects' );

   k := 1;
   while k > 0 do begin
      e := k;
      k := k/2;
   end;
   writeln( 'exp(10*ln(', e, ')) is ', exp(10*ln(e)):9:4 );

   k := -1;
   while k < 0 do begin
      e := k;
      k := k/2;
   end;
   writeln( 'exp(10*ln(', e, ')) is ', exp(10*ln(e)):9 ); {!!!error}
   writeln( 'fails: negative arg error in exp(10*ln(arg)) is not detected' );
end. { d089 }

