{: test that getting a variable from a file causes a fatal error if
   there is a file error}

{$d+}
program d04f( output );
const
   testTemp = 30;
type
   temperature = -10..40;
var
   f  : array[0..1] of file of temperature;
   pr : packed record
           t1, t2 : temperature;
        end;
   k  : integer;

function side : integer;
begin
   side := k;
   k := k+1;
end;
begin {d04f}
   rewrite( f[0] );
   k := 0;
   f[side]^ := testTemp;
   if k <> 1 then
      writeln( 'assign binary file buffer for debug has side effects' );
   k := 0;
   put(f[side]);
   if k <> 1 then
      writeln( 'put binary for debug has side effects' );


   f[0]^ := testTemp+1;
   put(f[0]);


   k := 0;
   reset( f[side] );
   if k <> 1 then
      writeln( 'reset binary for debug has side effects' );

   k := 0;
   pr.t1 := f[side]^;
   if k <> 1 then
      writeln( 'read file buffer for binary for debug has side effects' );

   k := 0;
   get( f[side] );
   if k <> 1 then
      writeln( 'get binary for debug has side effects' );

   pr.t2 := f[0]^;

   if (pr.t1 <> testTemp) or (pr.t2 <> testTemp+1) then
      writeln( 'expected (', testTemp:1, ' ', testtemp+1:1, '), found (',
                pr.t1:1, ', ', pr.t2, ')' );

   get(f[0]);         {lazy i/o ==> f[0]^ is empty}
   writeln(f[0]^);    { end of file! no data ==> file error }
   writeln( 'fails: get packed binary file error not detected' );
end. { d04f }

