#ifndef ASSERT_INC_PAS
#define ASSERT_INC_PAS

{%%%%%%%%% Copyright (c) 2019 Trevor Blight All rights reserved. %%%%%%%%%

   provide an assert statement, equivalent to assert in standard c

   This checks the sanity of code by halting the program if some condition
   is incorrect.
   It's equivalent to saying "make sure my code is behaving as I expect".
   For example:

         include "assert.inc.pas"
         var x: real;
            ....
            assert(x >= 0);  // make sure x is valid
            writeln( 'sqrt(x) is ', sqrt(x) );

   - disabled if NDEBUG is defined

   here's a good discussion on using assert to build solid code:
   https://barrgroup.com/Embedded-Systems/How-To/Use-Assert-Macro
}


#if defined NDEBUG
#define assert(cond)
#else
#define assert(cond) \
   if cond then {OK} else begin \
      writeln('file ''', __FILE__, ''', line ', __LINE__, ': assertion ''', #cond, ''' failed'); \
      halt; \
   end
#endif // NDEBUG

#endif // ASSERT_INC_PAS

