// Copyright (c) 2010-2017 Trevor Blight ////
//
// system header file for p5c generated code
//

#ifndef __P5C_H__
#define __P5C_H__  100

#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <inttypes.h>
#include <stdbool.h>
#include <math.h>
#include <limits.h>
#include <float.h>
#include <setjmp.h>
#include <unistd.h>

// translate pascal names to equivalent c name
static inline double arctan( double x ) { return atan(x); }
static inline double ln( double x ) { return log(x); }

// file handling
typedef struct {
    FILE *f;
    char *name;
    int flags;
    unsigned char buffer;
} text;

struct _PcleanupInf {
     int level;
     void (*cuFunc)(void);
     struct _PcleanupInf *link;
};
extern struct _PcleanupInf *_Phead;

static void  __attribute__ ((__noreturn__))
_Pfatal( char *const s, const int l )
{
fprintf( stderr, "fatal error at line %d: %s\n", l, s);
exit(EXIT_FAILURE);
} // _Pfatal()

#endif //__P5C_H__
