/* mpi.h - header for multiprecision integer math

   AUTHOR: Gregory Pietsch

   This file has been put into the public domain by its author.
   
   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
   IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
   OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
   ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
   OTHER DEALINGS IN THE SOFTWARE.
*/

#ifndef _MPILIB
#define _MPILIB

#include "config.h"
#if defined(HAVE_STDC_HEADERS) || defined(HAVE_LIMITS_H)
#include <limits.h>
#else
#error NO limits.h!
#endif
#if defined(HAVE_STDC_HEADERS) || defined(HAVE_STDDEF_H)
#include <stddef.h>
#else
#error NO stddef.h!
#endif

#define BASE		(1U << CHAR_BIT)
#define MULBASE(x)	((x) << CHAR_BIT)
#define DIVBASE(x)	((x) >> CHAR_BIT)
#define MODBASE(x)	((x) & ~(~0U << CHAR_BIT))

typedef unsigned char *_MPI_T;

/* functions */

_MPI_T _Adi (_MPI_T c, _MPI_T a, _MPI_T b, int prec);
_MPI_T _Adu (_MPI_T c, _MPI_T a, _MPI_T b, int prec);
_MPI_T _And (_MPI_T c, _MPI_T a, _MPI_T b, int prec);
_MPI_T _Cii (_MPI_T c, int cprec, _MPI_T a, int aprec);
_MPI_T _Ciu (_MPI_T c, int cprec, _MPI_T a, int aprec);
int _Cmp (_MPI_T a, _MPI_T b, int prec);
void *_Cpy (void *d, const void *s, size_t n);
_MPI_T _Cui (_MPI_T c, int cprec, _MPI_T a, int aprec);
_MPI_T _Cuu (_MPI_T c, int cprec, _MPI_T a, int aprec);
_MPI_T _Dec (_MPI_T c, _MPI_T a, int prec);
int _Div (_MPI_T q, _MPI_T r, _MPI_T a, _MPI_T b, int prec);
_MPI_T _Dvi (_MPI_T c, _MPI_T a, _MPI_T b, int prec);
_MPI_T _Dvu (_MPI_T c, _MPI_T a, _MPI_T b, int prec);
int _Eqi (_MPI_T a, _MPI_T b, int prec);
int _Equ (_MPI_T a, _MPI_T b, int prec);
int _Gei (_MPI_T a, _MPI_T b, int prec);
int _Geu (_MPI_T a, _MPI_T b, int prec);
int _Gti (_MPI_T a, _MPI_T b, int prec);
int _Gtu (_MPI_T a, _MPI_T b, int prec);
_MPI_T _Inc (_MPI_T c, _MPI_T a, int prec);
_MPI_T _Ior (_MPI_T c, _MPI_T a, _MPI_T b, int prec);
int _Lei (_MPI_T a, _MPI_T b, int prec);
int _Leu (_MPI_T a, _MPI_T b, int prec);
_MPI_T _Lsi (_MPI_T c, _MPI_T a, int b, int prec);
_MPI_T _Lsu (_MPI_T c, _MPI_T a, int b, int prec);
int _Lti (_MPI_T a, _MPI_T b, int prec);
int _Ltu (_MPI_T a, _MPI_T b, int prec);
_MPI_T _Mdi (_MPI_T c, _MPI_T a, _MPI_T b, int prec);
_MPI_T _Mdu (_MPI_T c, _MPI_T a, _MPI_T b, int prec);
_MPI_T _Mli (_MPI_T c, _MPI_T a, _MPI_T b, int prec);
_MPI_T _Mlu (_MPI_T c, _MPI_T a, _MPI_T b, int prec);
int _Nei (_MPI_T a, _MPI_T b, int prec);
int _Neu (_MPI_T a, _MPI_T b, int prec);
_MPI_T _Ngi (_MPI_T c, _MPI_T a, int prec);
_MPI_T _Not (_MPI_T c, _MPI_T a, int prec);
_MPI_T _Rsi (_MPI_T c, _MPI_T a, int b, int prec);
_MPI_T _Rsu (_MPI_T c, _MPI_T a, int b, int prec);
_MPI_T _Sbi (_MPI_T c, _MPI_T a, _MPI_T b, int prec);
_MPI_T _Sbu (_MPI_T c, _MPI_T a, _MPI_T b, int prec);
int _Sgn (_MPI_T x, int prec);
_MPI_T _Xor (_MPI_T c, _MPI_T a, _MPI_T b, int prec);
int _Zeq (_MPI_T x, int prec);
void *_Zer (void *c, size_t n);
int _Zne (_MPI_T x, int prec);

#endif

/* END OF FILE */

