/* mlu.c - unsigned multiplication of two multiprecision integers

   AUTHOR: Gregory Pietsch

   DESCRIPTION:
   
   c = a * b; c, a, and b are unsigned integers with precision prec.
   
   This file has been put into the public domain by its author.
   
   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
   IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
   OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
   ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
   OTHER DEALINGS IN THE SOFTWARE.
*/

#include "ordering.h"
#include "mpi.h"

_MPI_T
_Mlu (_MPI_T c, _MPI_T a, _MPI_T b, int prec)
{
  unsigned char z[prec + prec + 1], x;
  int i, j, k, aprec = 0, bprec = 0, carry, zp = prec + prec + 1;
  unsigned int t, t0, t1;

  _Zer (z, zp);
  for (i = 0; i < prec && (aprec == 0 || bprec == 0); ++i)
    {
      if (aprec == 0 && a[_Byte (i, prec)] != 0)
	aprec = prec - i;
      if (bprec == 0 && b[_Byte (i, prec)] != 0)
	bprec = prec - i;
    }
  if (aprec && bprec)
    {
      for (i = 0; i < aprec; ++i)
	{
	  for (j = 0; j < bprec; ++j)
	    {
	      t0 = a[_Byte (prec - 1 - i, prec)];
	      t1 = b[_Byte (prec - 1 - j, prec)];
	      if (t0 != 0 && t1 != 0)
		{
		  t = t0 * t1;
		  for (k = i + j, carry = 0; k < zp && (t || carry); ++k)
		    {
		      x = MODBASE (t);
		      z[k] += x + carry;
		      carry = (z[k] < (x + carry));
		      t = DIVBASE (t);
		    }
		}
	    }
	}
    }
  for (i = 0; i < prec; ++i)
    c[_Byte (prec - 1 - i, prec)] = z[i];
  return c;
}

/* END OF FILE */
