/* mdi.c - divide signed multiprecision integers, return remainder

   Returns a null pointer iff b == 0.

   AUTHOR: Gregory Pietsch

   DESCRIPTION:
   
   c = a % b; a and b are signed integers with precision prec.
   
   This file has been put into the public domain by its author.
   
   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
   IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
   OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
   ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
   OTHER DEALINGS IN THE SOFTWARE.
*/

#include "mpi.h"

_MPI_T
_Mdi (_MPI_T c, _MPI_T a, _MPI_T b, int prec)
{
  unsigned char q[prec], r[prec], x[prec], y[prec];
  int sq = 0, sr = 0;

  if (_Sgn (a, prec))
    {
      sq ^= 1;
      sr ^= 1;
      _Ngi (x, a, prec);
    }
  else
    _Cpy (x, a, prec);
  if (_Sgn (b, prec))
    {
      sq ^= 1;
      _Ngi (y, b, prec);
    }
  else
    _Cpy (y, b, prec);
  if (_Div (q, r, x, y, prec))
    return 0;
  if (sr)
    _Ngi (c, r, prec);
  else
    _Cpy (c, r, prec);
  return c;
}

/* END OF FILE */
