/* lsi.c - left-shift a by b, store in c, a and c are signed

   AUTHOR: Gregory Pietsch

   DESCRIPTION:
   
   Both a and c are signed integers with precision prec.
   
   This file has been put into the public domain by its author.
   
   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
   IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
   OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
   ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
   OTHER DEALINGS IN THE SOFTWARE.   
*/

#include "ordering.h"
#include "mpi.h"

_MPI_T
_Lsi (_MPI_T c, _MPI_T a, int b, int prec)
{
  int i, q, r;
  unsigned char s = 0;

  if (b < 0)
    return _Rsi (c, a, -b, prec);
  if (b >= prec * CHAR_BIT)
    {
      _Zer (c, prec);
      return c;
    }
  if (b == 0)
    {
      if (c != a)
	_Cpy (c, a, prec);
      return c;
    }
  q = b / CHAR_BIT;
  r = b % CHAR_BIT;
  /* first, move q bytes left */
  for (i = 0; i < prec; ++i)
    {
      if (r)
	{
	  if (i + q >= prec - 1)
	    s = 0;
	  else
	    s = a[_Byte (i + q + 1, prec)] >> (CHAR_BIT - r);
	  c[_Byte (i, prec)] =
	    (((i + q < prec) ? a[_Byte (i + q, prec)] : 0) << r) | s;
	}
      else
	c[_Byte (i, prec)] = (i + q < prec) ? a[_Byte (i + q, prec)] : 0;
    }
  return c;
}

/* END OF FILE */
