/* div.c - unsigned division of two multiprecision integers

   AUTHOR: Gregory Pietsch
   
   DESCRIPTION:
   
   This function divides a by b, puts quotient in q and remainder in r.
   Returns 1 if b was initially zero, else 0.

   This file has been put into the public domain by its author.
   
   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
   IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
   OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
   ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
   OTHER DEALINGS IN THE SOFTWARE.
*/

#include "ordering.h"
#include "mpi.h"

int
_Div (_MPI_T q, _MPI_T r, _MPI_T a, _MPI_T b, int prec)
{
  int i, z = 0, sq, c;

  /* is b zero? */
  if (_Zeq (b, prec))
    return 1;

  /* Simplify a little */
  c = _Cmp (a, b, prec);
  if (c < 0)
    {
      /* a < b, q = 0, r = a */
      _Zer (q, prec);
      _Cpy (r, a, prec);
    }
  else if (c == 0)
    {
      /* a == b, q = 1, r = 0 */
      _Zer (q, prec);
      _Inc (q, q, prec);
      _Zer (r, prec);
    }
  else
    {
      /* a > b, do it the hard way */
      _Cpy (q, a, prec);
      _Zer (r, prec);

      /* divide by repeated subtraction */
      z = prec * CHAR_BIT;
      for (i = 0; i < z; ++i)
	{
	  sq = _Sgn (q, prec);
	  _Lsu (q, q, 1, prec);
	  _Lsu (r, r, 1, prec);
	  if (sq)
	    _Inc (r, r, prec);
	  if (_Geu (r, b, prec))
	    {
	      _Sbu (r, r, b, prec);
	      _Inc (q, q, prec);
	    }
	}
    }
  return 0;
}

/* END OF FILE */
