/* zeq.c - is number equal to zero?

   AUTHOR: Gregory Pietsch

   DESCRIPTION:
   
   This function is also the equivalent of the ! operator.  The integer x has
   the precision prec.
   
   This file has been put into the public domain by its author.
   
   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
   IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
   OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
   ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
   OTHER DEALINGS IN THE SOFTWARE.
*/

#include "mpi.h"

int
_Zeq (_MPI_T x, int prec)
{
  int i;

  for (i = 0; i < prec; ++i)
    {
      if (x[i])
	return 0;
    }
  return 1;
}

/* END OF FILE */
