/* rsi.c - right-shift a by b, store in c, a and c are signed

   AUTHOR: Gregory Pietsch

   DESCRIPTION:
   
   c = a >> b; a and c have the precision prec.  Because it's signed,
   the sign bit of a gets propagated.
   
   This file has been placed into the public domain by its author.
   
   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
   IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
   OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
   ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
   OTHER DEALINGS IN THE SOFTWARE.
*/

#include "ordering.h"
#include "mpi.h"

_MPI_T
_Rsi (_MPI_T c, _MPI_T a, int b, int prec)
{
  int i, q, r;
  unsigned char s = 0, fill;

  if (b < 0)
    return _Lsi (c, a, -b, prec);
  if (b >= prec * CHAR_BIT)
    {
      if (_Sgn (a, prec))
	{
	  for (i = 0; i < prec; ++i)
	    c[i] = ~0;
	}
      else
	_Zer (c, prec);
      return c;
    }
  if (b == 0)
    {
      if (c != a)
	_Cpy (c, a, prec);
      return c;
    }
  q = b / CHAR_BIT;
  r = b % CHAR_BIT;
  fill = _Sgn (a, prec) ? ~0 : 0;
  for (i = prec - 1; i >= 0; --i)
    {
      if (r)
	{
	  if (i < q)
	    s = fill;
	  else if (i == q)
	    s = (a[_Byte (0, prec)] >> r) | (fill << (CHAR_BIT - r));
	  else
	    s = (a[_Byte (i - q, prec)] >> r) |
	      (a[_Byte (i - q - 1, prec)] << (CHAR_BIT - r));
	  c[_Byte (i, prec)] = s;
	}
      else
	c[_Byte (i, prec)] = (i >= q) ? a[_Byte (i - q, prec)] : fill;
    }
  return c;
}

/* END OF FILE */
