/* ordering.h - #defines for byte orders

   AUTHOR: Gregory Pietsch

   This file has been put into the public domain by its author.
   
   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
   IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
   OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
   ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
   OTHER DEALINGS IN THE SOFTWARE.  
*/

#ifndef _ORDERING
#define _ORDERING

/* define __BYTE_ORDER */
#ifndef __BYTE_ORDER
#define __LITTLE_ENDIAN	(0)
#define __BIG_ENDIAN	(1)
#define __PDP_ENDIAN	(2)
#define __MIDDLE_ENDIAN	(3)
#define __BYTE_ORDER	__LITTLE_ENDIAN	/* change if not a PC... */
#endif
#if __BYTE_ORDER == __LITTLE_ENDIAN
#define _Byte(x,s) ((s)-(x)-1)
#elif __BYTE_ORDER == __BIG_ENDIAN
#define _Byte(x,s) (x)
#elif __BYTE_ORDER == __PDP_ENDIAN
#define _Byte(x,s) (((s)-(x)-1)^1)
#elif __BYTE_ORDER == __MIDDLE_ENDIAN
#define _Byte(x,s) ((x)^1)
#endif

#endif /* BYTE_ORDER */

/* END OF FILE */
