/* inc.c - increment a, store in c

   AUTHOR: Gregory Pietsch

   DESCRIPTION:
   
   Both a and c have the precision prec.  They both can be the same integer.
   
   This file has been put into the public domain by its author.
   
   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
   IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
   OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
   ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
   OTHER DEALINGS IN THE SOFTWARE.
*/

#include "ordering.h"
#include "mpi.h"

_MPI_T
_Inc (_MPI_T c, _MPI_T a, int prec)
{
  int i, z = 1;

  for (i = prec - 1; i >= 0; --i)
    {
      c[_Byte (i, prec)] = a[_Byte (i, prec)] + z;
      z = z && (c[_Byte (i, prec)] == 0);
    }
  return c;
}

/* END OF FILE */
