/* and.c - and two unsigned integers

   AUTHOR: Gregory Pietsch
   
   DESCRIPTION:
   
   This function ands a to b and stores result in c. The variables a, b, and
   c are considered to be unsigned integers with precision prec.
   
   This file has been put into the public domain by its author.
   
   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
   IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
   OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
   ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
   OTHER DEALINGS IN THE SOFTWARE.
*/

#include "ordering.h"
#include "mpi.h"

_MPI_T
_And (_MPI_T c, _MPI_T a, _MPI_T b, int prec)
{
  int i;

  for (i = 0; i < prec; ++i)
    c[i] = a[i] & b[i];
  return c;
}

/* END OF FILE */
