/* adu.c - add two unsigned integers

   AUTHOR: Gregory Pietsch
   
   DESCRIPTION:
   
   This function adds a to b and stores result in c. The variables a, b,
   and c are considered to be unsigned integers with precision prec.

   This file has been put into the public domain by its author.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
   IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
   OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
   ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
   OTHER DEALINGS IN THE SOFTWARE.
*/

#include "ordering.h"
#include "mpi.h"

_MPI_T
_Adu (_MPI_T c, _MPI_T a, _MPI_T b, int prec)
{
  int i;
  unsigned int carry = 0;

  for (i = prec - 1; i >= 0; --i)
    {
      carry += a[_Byte (i, prec)] + b[_Byte (i, prec)];
      c[_Byte (i, prec)] = MODBASE (carry);
      carry = DIVBASE (carry);
    }
  return c;
}

/* END OF FILE */
