/*
 ** TinyASM - 8086/8088 assembler for DOS
 **
 ** Instruction set.
 **
 ** by Oscar Toledo G.
 **
 ** Creation date: Oct/01/2019.
 */

#include <stdio.h>

/*
 ** This should have been 3 entries per line but DeSmet C only allows 500 strings per module.
 */

/*
 ** Notice some instructions are sorted by less byte usage first.
 */
char *instruction_set[] = {
    "ADD\0%d8,%r8\0x00 %d8%r8%d8",
    "ADD\0%d16,%r16\0x01 %d16%r16%d16",
    "ADD\0%r8,%d8\0x02 %d8%r8%d8",
    "ADD\0%r16,%d16\0x03 %d16%r16%d16",
    "ADD\0AL,%i8\0x04 %i8",
    "ADD\0AX,%i16\0x05 %i16",
    "PUSH\0ES\0x06",
    "POP\0ES\0x07",
    "OR\0%d8,%r8\0x08 %d8%r8%d8",
    "OR\0%d16,%r16\0x09 %d16%r16%d16",
    "OR\0%r8,%d8\0x0a %d8%r8%d8",
    "OR\0%r16,%d16\0x0b %d16%r16%d16",
    "OR\0AL,%i8\0x0c %i8",
    "OR\0AX,%i16\0x0d %i16",
    "PUSH\0CS\0x0e",
    "ADC\0%d8,%r8\0x10 %d8%r8%d8",
    "ADC\0%d16,%r16\0x11 %d16%r16%d16",
    "ADC\0%r8,%d8\0x12 %d8%r8%d8",
    "ADC\0%r16,%d16\0x13 %d16%r16%d16",
    "ADC\0AL,%i8\0x14 %i8",
    "ADC\0AX,%i16\0x15 %i16",
    "PUSH\0SS\0x16",
    "POP\0SS\0x17",
    "SBB\0%d8,%r8\0x18 %d8%r8%d8",
    "SBB\0%d16,%r16\0x19 %d16%r16%d16",
    "SBB\0%r8,%d8\0x1a %d8%r8%d8",
    "SBB\0%r16,%d16\0x1b %d16%r16%d16",
    "SBB\0AL,%i8\0x1c %i8",
    "SBB\0AX,%i16\0x1d %i16",
    "PUSH\0DS\0x1e",
    "POP\0DS\0x1f",
    "AND\0%d8,%r8\0x20 %d8%r8%d8",
    "AND\0%d16,%r16\0x21 %d16%r16%d16",
    "AND\0%r8,%d8\0x22 %d8%r8%d8",
    "AND\0%r16,%d16\0x23 %d16%r16%d16",
    "AND\0AL,%i8\0x24 %i8",
    "AND\0AX,%i16\0x25 %i16",
    "ES\0\0x26",
    "DAA\0\0x27",
    "SUB\0%d8,%r8\0x28 %d8%r8%d8",
    "SUB\0%d16,%r16\0x29 %d16%r16%d16",
    "SUB\0%r8,%d8\0x2a %d8%r8%d8",
    "SUB\0%r16,%d16\0x2b %d16%r16%d16",
    "SUB\0AL,%i8\0x2c %i8",
    "SUB\0AX,%i16\0x2d %i16",
    "CS\0\0x2e",
    "DAS\0\0x2f",
    "XOR\0%d8,%r8\0x30 %d8%r8%d8",
    "XOR\0%d16,%r16\0x31 %d16%r16%d16",
    "XOR\0%r8,%d8\0x32 %d8%r8%d8",
    "XOR\0%r16,%d16\0x33 %d16%r16%d16",
    "XOR\0AL,%i8\0x34 %i8",
    "XOR\0AX,%i16\0x35 %i16",
    "SS\0\0x36",
    "AAA\0\0x37",
    "CMP\0%d8,%r8\0x38 %d8%r8%d8",
    "CMP\0%d16,%r16\0x39 %d16%r16%d16",
    "CMP\0%r8,%d8\0x3a %d8%r8%d8",
    "CMP\0%r16,%d16\0x3b %d16%r16%d16",
    "CMP\0AL,%i8\0x3c %i8",
    "CMP\0AX,%i16\0x3d %i16",
    "DS\0\0x3e",
    "AAS\0\0x3f",
    "INC\0%r16\0b01000%r16",
    "DEC\0%r16\0b01001%r16",
    "PUSH\0%r16\0b01010%r16",
    "POP\0%r16\0b01011%r16",
    "JO\0%a8\0x70 %a8",
    "JNO\0%a8\0x71 %a8",
    "JB\0%a8\0x72 %a8",
    "JC\0%a8\0x72 %a8",
    "JNB\0%a8\0x73 %a8",
    "JNC\0%a8\0x73 %a8",
    "JZ\0%a8\0x74 %a8",
    "JNZ\0%a8\0x75 %a8",
    "JE\0%a8\0x74 %a8",
    "JNE\0%a8\0x75 %a8",
    "JBE\0%a8\0x76 %a8",
    "JA\0%a8\0x77 %a8",
    "JS\0%a8\0x78 %a8",
    "JNS\0%a8\0x79 %a8",
    "JPE\0%a8\0x7a %a8",
    "JPO\0%a8\0x7b %a8",
    "JL\0%a8\0x7C %a8",
    "JGE\0%a8\0x7D %a8",
    "JLE\0%a8\0x7E %a8",
    "JG\0%a8\0x7F %a8",
    "ADD\0%d16,%s8\0x83 %d16000%d16 %s8",
    "OR\0%d16,%s8\0x83 %d16001%d16 %s8",
    "ADC\0%d16,%s8\0x83 %d16010%d16 %s8",
    "SBB\0%d16,%s8\0x83 %d16011%d16 %s8",
    "AND\0%d16,%s8\0x83 %d16100%d16 %s8",
    "SUB\0%d16,%s8\0x83 %d16101%d16 %s8",
    "XOR\0%d16,%s8\0x83 %d16110%d16 %s8",
    "CMP\0%d16,%s8\0x83 %d16111%d16 %s8",
    "ADD\0%d8,%i8\0x80 %d8000%d8 %i8",
    "OR\0%d8,%i8\0x80 %d8001%d8 %i8",
    "ADC\0%d8,%i8\0x80 %d8010%d8 %i8",
    "SBB\0%d8,%i8\0x80 %d8011%d8 %i8",
    "AND\0%d8,%i8\0x80 %d8100%d8 %i8",
    "SUB\0%d8,%i8\0x80 %d8101%d8 %i8",
    "XOR\0%d8,%i8\0x80 %d8110%d8 %i8",
    "CMP\0%d8,%i8\0x80 %d8111%d8 %i8",
    "ADD\0%d16,%i16\0x81 %d16000%d16 %i16",
    "OR\0%d16,%i16\0x81 %d16001%d16 %i16",
    "ADC\0%d16,%i16\0x81 %d16010%d16 %i16",
    "SBB\0%d16,%i16\0x81 %d16011%d16 %i16",
    "AND\0%d16,%i16\0x81 %d16100%d16 %i16",
    "SUB\0%d16,%i16\0x81 %d16101%d16 %i16",
    "XOR\0%d16,%i16\0x81 %d16110%d16 %i16",
    "CMP\0%d16,%i16\0x81 %d16111%d16 %i16",
    "TEST\0%d8,%r8\0x84 %d8%r8%d8",
    "TEST\0%r8,%d8\0x84 %d8%r8%d8",
    "TEST\0%d16,%r16\0x85 %d16%r16%d16",
    "TEST\0%r16,%d16\0x85 %d16%r16%d16",
    
    "MOV\0AL,[%i16]\0xa0 %i16",
    "MOV\0AX,[%i16]\0xa1 %i16",
    "MOV\0[%i16],AL\0xa2 %i16",
    "MOV\0[%i16],AX\0xa3 %i16",
    "MOV\0%d8,%r8\0x88 %d8%r8%d8",
    "MOV\0%d16,%r16\0x89 %d16%r16%d16",
    "MOV\0%r8,%d8\0x8a %d8%r8%d8",
    "MOV\0%r16,%d16\0x8b %d16%r16%d16",
    
    "MOV\0%d16,ES\0x8c %d16000%d16",
    "MOV\0%d16,CS\0x8c %d16001%d16",
    "MOV\0%d16,SS\0x8c %d16010%d16",
    "MOV\0%d16,DS\0x8c %d16011%d16",
    "LEA\0%r16,%d16\0x8d %d16%r16%d16",
    "MOV\0ES,%d16\0x8e %d16000%d16",
    "MOV\0CS,%d16\0x8e %d16001%d16",
    "MOV\0SS,%d16\0x8e %d16010%d16",
    "MOV\0DS,%d16\0x8e %d16011%d16",
    "POP\0%d16\0x8f %d16000%d16",
    "NOP\0\0x90",
    "XCHG\0AX,%r16\0b10010%r16",
    "XCHG\0%r16,AX\0b10010%r16",
    "XCHG\0%d8,%r8\0x86 %d8%r8%d8",
    "XCHG\0%r8,%d8\0x86 %d8%r8%d8",
    "XCHG\0%d16,%r16\0x87 %d16%r16%d16",
    "XCHG\0%r16,%d16\0x87 %d16%r16%d16",
    "CBW\0\0x98",
    "CWD\0\0x99",
    "WAIT\0\0x9b",
    "PUSHF\0\0x9c",
    "POPF\0\0x9d",
    "SAHF\0\0x9e",
    "LAHF\0\0x9f",
    "MOVSB\0\0xa4",
    "MOVSW\0\0xa5",
    "CMPSB\0\0xa6",
    "CMPSW\0\0xa7",
    "TEST\0AL,%i8\0xa8 %i8",
    "TEST\0AX,%i16\0xa9 %i16",
    "STOSB\0\0xaa",
    "STOSW\0\0xab",
    "LODSB\0\0xac",
    "LODSW\0\0xad",
    "SCASB\0\0xae",
    "SCASW\0\0xaf",
    "MOV\0%r8,%i8\0b10110%r8 %i8",
    "MOV\0%r16,%i16\0b10111%r16 %i16",
    "RET\0%i16\0xc2 %i16",
    "RET\0\0xc3",
    "LES\0%r16,%d16\0b11000100 %d16%r16%d16",
    "LDS\0%r16,%d16\0b11000101 %d16%r16%d16",
    "MOV\0%db8,%i8\0b11000110 %d8000%d8 %i8",
    "MOV\0%dw16,%i16\0b11000111 %d16000%d16 %i16",
    "RETF\0%i16\0xca %i16",
    "RETF\0\0xcb",
    "INT3\0\0xcc",
    "INT\0%i8\0xcd %i8",
    "INTO\0\0xce",
    "IRET\0\0xcf",
    "ROL\0%d8,1\0xd0 %d8000%d8",
    "ROR\0%d8,1\0xd0 %d8001%d8",
    "RCL\0%d8,1\0xd0 %d8010%d8",
    "RCR\0%d8,1\0xd0 %d8011%d8",
    "SHL\0%d8,1\0xd0 %d8100%d8",
    "SHR\0%d8,1\0xd0 %d8101%d8",
    "SAR\0%d8,1\0xd0 %d8111%d8",
    "ROL\0%d16,1\0xd1 %d16000%d16",
    "ROR\0%d16,1\0xd1 %d16001%d16",
    "RCL\0%d16,1\0xd1 %d16010%d16",
    "RCR\0%d16,1\0xd1 %d16011%d16",
    "SHL\0%d16,1\0xd1 %d16100%d16",
    "SHR\0%d16,1\0xd1 %d16101%d16",
    "SAR\0%d16,1\0xd1 %d16111%d16",
    "ROL\0%d8,CL\0xd2 %d8000%d8",
    "ROR\0%d8,CL\0xd2 %d8001%d8",
    "RCL\0%d8,CL\0xd2 %d8010%d8",
    "RCR\0%d8,CL\0xd2 %d8011%d8",
    "SHL\0%d8,CL\0xd2 %d8100%d8",
    "SHR\0%d8,CL\0xd2 %d8101%d8",
    "SAR\0%d8,CL\0xd2 %d8111%d8",
    "ROL\0%d16,CL\0xd3 %d16000%d16",
    "ROR\0%d16,CL\0xd3 %d16001%d16",
    "RCL\0%d16,CL\0xd3 %d16010%d16",
    "RCR\0%d16,CL\0xd3 %d16011%d16",
    "SHL\0%d16,CL\0xd3 %d16100%d16",
    "SHR\0%d16,CL\0xd3 %d16101%d16",
    "SAR\0%d16,CL\0xd3 %d16111%d16",
    "AAM\0\0xd4 x0a",
    "AAD\0\0xd5 x0a",
    "XLAT\0\0xd7",
    "LOOPNZ\0%a8\0xe0 %a8",
    "LOOPNE\0%a8\0xe0 %a8",
    "LOOPZ\0%a8\0xe1 %a8",
    "LOOPE\0%a8\0xe1 %a8",
    "LOOP\0%a8\0xe2 %a8",
    "JCXZ\0%a8\0xe3 %a8",
    "IN\0AL,DX\0xec",
    "IN\0AX,DX\0xed",
    "OUT\0DX,AL\0xee",
    "OUT\0DX,AX\0xef",
    "IN\0AL,%i8\0xe4 %i8",
    "IN\0AX,%i8\0xe5 %i8",
    "OUT\0%i8,AL\0xe6 %i8",
    "OUT\0%i8,AX\0xe7 %i8",
    "CALL\0FAR %d16\0xff %d16011%d16",
    "JMP\0FAR %d16\0xff %d16101%d16",
    "CALL\0%f32\0x9a %f32",
    "JMP\0%f32\0xea %f32",
    "CALL\0%d16\0xff %d16010%d16",
    "JMP\0%d16\0xff %d16100%d16",
    "JMP\0%a8\0xeb %a8",
    "JMP\0%a16\0xe9 %a16",
    "CALL\0%a16\0xe8 %a16",
    "LOCK\0\0xf0",
    "REPNZ\0\0xf2",
    "REPNE\0\0xf2",
    "REPZ\0\0xf3",
    "REPE\0\0xf3",
    "REP\0\0xf3",
    "HLT\0\0xf4",
    "CMC\0\0xf5",
    "TEST\0%db8,%i8\0xf6 %d8000%d8 %i8",
    "NOT\0%db8\0xf6 %d8010%d8",
    "NEG\0%db8\0xf6 %d8011%d8",
    "MUL\0%db8\0xf6 %d8100%d8",
    "IMUL\0%db8\0xf6 %d8101%d8",
    "DIV\0%db8\0xf6 %d8110%d8",
    "IDIV\0%db8\0xf6 %d8111%d8",
    "TEST\0%dw16,%i16\0xf7 %d8000%d8 %i16",
    "NOT\0%dw16\0xf7 %d8010%d8",
    "NEG\0%dw16\0xf7 %d8011%d8",
    "MUL\0%dw16\0xf7 %d8100%d8",
    "IMUL\0%dw16\0xf7 %d8101%d8",
    "DIV\0%dw16\0xf7 %d8110%d8",
    "IDIV\0%dw16\0xf7 %d8111%d8",
    "CLC\0\0xf8",
    "STC\0\0xf9",
    "CLI\0\0xfa",
    "STI\0\0xfb",
    "CLD\0\0xfc",
    "STD\0\0xfd",
    "INC\0%db8\0xfe %d8000%d8",
    "DEC\0%db8\0xfe %d8001%d8",
    "INC\0%dw16\0xff %d16000%d16",
    "DEC\0%dw16\0xff %d16001%d16",
    "PUSH\0%d16\0xff %d16110%d16",
    NULL,NULL,NULL
};

