#ifndef agnnet_h
#define agnnet_h

/* default address */
#define ADDRESS "localhost"
/* default port number */
#define PORT 1234

/* in Linux socklen_t is overwritten although assigned */
#ifndef __linux__
#ifndef socklen_t
#define socklen_t int
#endif
#endif


/* misc. definitions */
#ifdef _WIN32
#define close_socket(x) closesocket((x))
#else
#define close_socket(x) close((x))
#endif


#undef AGN_SOCKET
#ifdef _WIN32
#  define AGN_SOCKET SOCKET
#else
#  define AGN_SOCKET int
#endif

#undef AGN_FAMILY
#ifdef _WIN32
#  define AGN_FAMILY int
#else
#  define AGN_FAMILY sa_family_t
#endif

#ifndef _WIN32
#  ifndef INVALID_SOCKET
#    define INVALID_SOCKET ((int)(~0))
#  endif
#endif

#ifdef _WIN32
#  define SHUTDOWN_RD SD_RECEIVE
#  define SHUTDOWN_WR SD_SEND
#  define SHUTDOWN_RDWR SD_BOTH
#else
#  define SHUTDOWN_RD SHUT_RD
#  define SHUTDOWN_WR SHUT_WR
#  define SHUTDOWN_RDWR SHUT_RDWR
#endif


typedef struct socket_status {
  char isserver;         /* server socket ? */
  char *address;         /* server address */
  size_t port;           /* server port */
  size_t family;         /* network protocol */
  char blocking;         /* blocking/non-blocking mode */
  char connected;        /* socket connected ?, needed for Linux would crash in unconnected cases */
  int shutdown;          /* shutdown mode: SHUT_RD - no more receive's, SHUT_WR, no more send's, SHUT_RDWR - both */
} STATUS;


/* implementation of a binary tree */

typedef struct node {
  AGN_SOCKET index;
  STATUS *status;
  struct node *left;
  struct node *right;
} NODE;


typedef struct tree {
  struct node *root;
  unsigned int size;
} TREE;

#endif

