@echo off
rem To build and install the additional libraries, execute this file in the \agena\src subfolder
rem in a plain NT shell, and not in MinGW.

set gccopts=-Wall -O3 -shared -I. -L. -lagena

set OLDPATH=%PATH%
set PATH=%PATH%;c:\mingw\bin

del ads.o calc.o linalg.o stats.o fractals.o phq.o net.o xbase.o interp.o moon.o sunriset.o astro.o skycrane.o

echo Buildung ADS.
gcc %gccopts% -o ads.dll ads.c agnhlps.c

rem echo Buildung phonetiQs.
rem gcc %gccopts% -o phq.dll plus/phq.c
rem copy phq.dll ..\phq >> NUL
rem del phq.dll

echo Buildung calc.
gcc -O2 -DLUA_BUILD_AS_DLL -c -o calc.o calc.c
gcc -O2 -DLUA_BUILD_AS_DLL -c -o interp.o interp.c
gcc -O -shared -fpic -o calc.dll calc.o interp.o cephes.o -L. -lagena

echo Buildung stats.
gcc -O2 -DLUA_BUILD_AS_DLL -c -o stats.o stats.c
gcc -O -shared -fpic -o stats.dll stats.o -L. -lagena

echo Buildung linalg.
gcc %gccopts% -o linalg.dll linalg.c

echo Buildung fractals.
gcc %gccopts% -o fractals.dll fractals.c

echo Buildung xbase.
gcc -O2 -DLUA_BUILD_AS_DLL -c -o xbase.o xbase.c
gcc -O -shared -fpic -o xbase.dll xbase.o agnt64.o -L. -lagena

echo Buildung net.
gcc %gccopts% -o net.dll net.c agnhlps.c -lwsock32

echo Buildung bags.
gcc %gccopts% -o bags.dll bags.c

echo Buildung astro.
gcc -O2 -DLUA_BUILD_AS_DLL -c -o astro.o astro.c
gcc -O2 -DLUA_BUILD_AS_DLL -c -o sunriset.o sunriset.c
gcc -O2 -DLUA_BUILD_AS_DLL -c -o moon.o moon.c
gcc -O -shared -fpic -o astro.dll astro.o sunriset.o moon.o sofa.o -L. -lagena

echo Buildung skycrane.
gcc %gccopts% -o skycrane.dll skycrane.c

echo Buildung llist.
gcc %gccopts% -o llist.dll llist.c

rem echo Buildung compress.
rem gcc %gccopts% -o compress.dll compress.c lcompress.c agnhlps.c

rem echo Buildung words.
rem gcc %gccopts% -o words.dll words.c

echo.
echo Slimming and moving packages.
strip --strip-unneeded *.dll
copy ads.dll ..\lib >> NUL
copy calc.dll ..\lib >> NUL
copy stats.dll ..\lib >> NUL
copy linalg.dll ..\lib >> NUL
copy fractals.dll ..\lib >> NUL
copy xbase.dll ..\lib >> NUL
copy net.dll ..\lib >> NUL
copy bags.dll ..\lib >> NUL
copy astro.dll ..\lib >> NUL
copy skycrane.dll ..\lib >> NUL
copy llist.dll ..\lib >> NUL

echo Installed all libraries into Agena /lib folder.

del ads.dll
del calc.dll
del stats.dll
del linalg.dll
del fractals.dll
del xbase.dll
del net.dll
del bags.dll
del astro.dll
del skycrane.dll
del llist.dll

set gccopts=
set PATH=%OLDPATH%
set OLDPATH=